/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.client.session.EditableSqlCheck;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecutionInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;

public class DataModelImplementationDetails {
    private static final Pattern FILL_COLUMN_NAME_PATTERN = Pattern.compile(".+:([^:]+):[^:]+$");
    private ISession _session;
    private SQLExecutionInfo _exInfo;

    public DataModelImplementationDetails() {
    }

    public DataModelImplementationDetails(ISession session) {
        this._session = session;
    }

    public DataModelImplementationDetails(ISession session, SQLExecutionInfo exInfo) {
        this._session = session;
        this._exInfo = exInfo;
    }

    public String getTableName(ColumnDisplayDefinition colDef) {
        Matcher matcher;
        String tableNameFromSQL;
        if (null != this._exInfo && !StringUtilities.isEmpty(tableNameFromSQL = new EditableSqlCheck(this._exInfo).getTableNameFromSQL(), true)) {
            return tableNameFromSQL;
        }
        if (!StringUtilities.isEmpty(colDef.getTableName(), true)) {
            return colDef.getTableName();
        }
        if (!StringUtilities.isEmpty(colDef.getFullTableColumnName(), true) && (matcher = FILL_COLUMN_NAME_PATTERN.matcher(colDef.getFullTableColumnName())).matches()) {
            return matcher.group(1);
        }
        return "PressCtrlH";
    }

    public String getStatementSeparator() {
        if (null == this._session) {
            return ";";
        }
        return this._session.getProperties().getSQLStatementSeparator();
    }

    public SQLExecutionInfo getSQLExecutionInfo() {
        return this._exInfo;
    }
}

