/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.builders.UIFactory;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.preferences.DataTypePreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.GeneralPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.GlobalPreferencesActionListener;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.PreferenceType;
import net.sourceforge.squirrel_sql.client.preferences.PrefrenceTabActvivationListener;
import net.sourceforge.squirrel_sql.client.preferences.ProxyPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.SQLPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.WikiTablePreferencesTab;
import net.sourceforge.squirrel_sql.client.preferences.codereformat.FormatSqlConfigPrefsTab;
import net.sourceforge.squirrel_sql.client.preferences.shortcut.ShortcutPrefsTab;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class GlobalPreferencesSheet
extends DialogWidget {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GlobalPreferencesSheet.class);
    private static final ILogger s_log = LoggerController.createLogger(GlobalPreferencesSheet.class);
    private static GlobalPreferencesSheet s_instance;
    private IApplication _app;
    private List<IGlobalPreferencesPanel> _panels = new ArrayList<IGlobalPreferencesPanel>();
    private JTabbedPane _tabPane;
    private JLabel _titleLbl = new JLabel();
    public static final String PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH = "Squirrel.globalPrefsSheetWidth";
    public static final String PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT = "Squirrel.globalPrefsSheetHeight";
    private static ArrayList<GlobalPreferencesActionListener> _listeners;

    private GlobalPreferencesSheet(IApplication app) {
        super(s_stringMgr.getString("GlobalPreferencesSheet.title"), true, app);
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        this._app = app;
        this.createGUI();
        for (IGlobalPreferencesPanel pnl : this._panels) {
            try {
                pnl.initialize(this._app);
            }
            catch (Throwable th) {
                String msg = s_stringMgr.getString("GlobalPreferencesSheet.error.loading", pnl.getTitle());
                s_log.error(msg, th);
                this._app.showErrorDialog(msg, th);
            }
        }
        this.setSize(this.getDimension());
        app.getMainFrame().addWidget(this);
        DialogWidget.centerWithinDesktop(this);
        this.setVisible(true);
    }

    private Dimension getDimension() {
        return new Dimension(Props.getInt(PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH, 650), Props.getInt(PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT, 600));
    }

    public static void addGlobalPreferencesActionListener(GlobalPreferencesActionListener listener) {
        _listeners.add(listener);
    }

    public static void removeGlobalPreferencesActionListener(GlobalPreferencesActionListener listener) {
        _listeners.remove(listener);
    }

    public static synchronized void showSheet(IApplication app, Class componentClassOfTabToSelect) {
        if (s_instance == null) {
            s_instance = new GlobalPreferencesSheet(app);
        } else {
            s_instance.moveToFront();
        }
        if (null != componentClassOfTabToSelect) {
            s_instance.selectTab(componentClassOfTabToSelect);
        }
        for (GlobalPreferencesActionListener listener : _listeners) {
            listener.onDisplayGlobalPreferences();
        }
    }

    private void selectTab(Class componentClassofTabToSelect) {
        for (int i = 0; i < this._tabPane.getTabCount(); ++i) {
            Component comp = this._tabPane.getComponentAt(i);
            if (JScrollPane.class.equals(comp.getClass())) {
                comp = ((JScrollPane)comp).getViewport().getView();
            }
            if (!componentClassofTabToSelect.equals(comp.getClass())) continue;
            this._tabPane.setSelectedIndex(i);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Dimension size = this.getSize();
        Props.putInt(PREF_KEY_GLOBAL_PREFS_SHEET_WIDTH, size.width);
        Props.putInt(PREF_KEY_GLOBAL_PREFS_SHEET_HEIGHT, size.height);
        for (IGlobalPreferencesPanel pnl : this._panels) {
            pnl.uninitialize(this._app);
        }
        Class<GlobalPreferencesSheet> clazz = GlobalPreferencesSheet.class;
        synchronized (GlobalPreferencesSheet.class) {
            s_instance = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            super.dispose();
            return;
        }
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(title);
        this._titleLbl.setText(title);
    }

    private void performClose() {
        this.dispose();
        for (GlobalPreferencesActionListener listener : _listeners) {
            listener.onPerformClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOk() {
        CursorChanger cursorChg = new CursorChanger(this._app.getMainFrame());
        cursorChg.show();
        try {
            boolean isDebug = s_log.isDebugEnabled();
            long start = 0L;
            Iterator<IGlobalPreferencesPanel> it = this._panels.iterator();
            while (it.hasNext()) {
                if (isDebug) {
                    start = System.currentTimeMillis();
                }
                IGlobalPreferencesPanel pnl = it.next();
                try {
                    pnl.applyChanges();
                }
                catch (Throwable th) {
                    String msg = s_stringMgr.getString("GlobalPreferencesSheet.error.saving", pnl.getTitle());
                    s_log.error(msg, th);
                    this._app.showErrorDialog(msg, th);
                }
                if (!isDebug) continue;
                s_log.debug("Panel " + pnl.getTitle() + " applied changes in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        finally {
            this._app.savePreferences(PreferenceType.DATATYPE_PREFERENCES);
            cursorChg.restore();
        }
        this.dispose();
        for (GlobalPreferencesActionListener listener : _listeners) {
            listener.onPerformOk();
        }
    }

    private void createGUI() {
        this.setDefaultCloseOperation(2);
        this.makeToolWindow(true);
        PrefrenceTabActvivationListener prefrenceTabActvivationListener = new PrefrenceTabActvivationListener(){

            @Override
            public void activateTabForClass(Class<?> tabClass) {
                GlobalPreferencesSheet.this.selectTab(tabClass);
            }
        };
        this._panels.add(new GeneralPreferencesPanel());
        this._panels.add(new SQLPreferencesPanel(this._app.getMainFrame()));
        this._panels.add(new ProxyPreferencesPanel());
        this._panels.add(new DataTypePreferencesPanel());
        this._panels.add(new WikiTablePreferencesTab());
        this._panels.add(new FormatSqlConfigPrefsTab(this._app));
        this._panels.add(new ShortcutPrefsTab());
        PluginInfo[] plugins = this._app.getPluginManager().getPluginInformation();
        for (int plugIdx = 0; plugIdx < plugins.length; ++plugIdx) {
            IGlobalPreferencesPanel[] pnls;
            PluginInfo pi = plugins[plugIdx];
            if (!pi.isLoaded() || (pnls = pi.getPlugin().getGlobalPreferencePanels()) == null || pnls.length <= 0) continue;
            for (int pnlIdx = 0; pnlIdx < pnls.length; ++pnlIdx) {
                this._panels.add(pnls[pnlIdx]);
            }
        }
        this._tabPane = UIFactory.getInstance().createTabbedPane();
        for (IGlobalPreferencesPanel pnl : this._panels) {
            String pnlTitle = pnl.getTitle();
            String hint = pnl.getHint();
            this._tabPane.addTab(pnlTitle, null, pnl.getPanelComponent(), hint);
        }
        JPanel contentPane = new JPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.setContentPane(contentPane);
        GridBagConstraints gbc = new GridBagConstraints();
        contentPane.setLayout(new GridBagLayout());
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        contentPane.add((Component)this._titleLbl, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        contentPane.add((Component)this._tabPane, gbc);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        contentPane.add((Component)this.createButtonsPanel(), gbc);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GlobalPreferencesSheet.this.performClose();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private JPanel createButtonsPanel() {
        JPanel pnl = new JPanel();
        JButton okBtn = new JButton(s_stringMgr.getString("GlobalPreferencesSheet.ok"));
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalPreferencesSheet.this.performOk();
            }
        });
        JButton closeBtn = new JButton(s_stringMgr.getString("GlobalPreferencesSheet.close"));
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalPreferencesSheet.this.performClose();
            }
        });
        GUIUtils.setJButtonSizesTheSame(new JButton[]{okBtn, closeBtn});
        pnl.add(okBtn);
        pnl.add(closeBtn);
        this.getRootPane().setDefaultButton(okBtn);
        return pnl;
    }

    static {
        _listeners = new ArrayList();
    }
}

