/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanel;
import net.sourceforge.squirrel_sql.client.gui.session.rowcolumnlabel.CaretPositionInfo;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.IMainPanelTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.SQLPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.BaseSQLTab;

public class RowColumnLabelSQLEntryPanelHandler {
    private ISQLEntryPanel _sqlEntryPanel;
    private MainPanel _mainPanel;
    private CaretListener _caretListener;

    public RowColumnLabelSQLEntryPanelHandler(ISQLEntryPanel sqlEntryPanel, CaretListener caretListener) {
        this._sqlEntryPanel = sqlEntryPanel;
        this._caretListener = caretListener;
        this._sqlEntryPanel.addCaretListener(this._caretListener);
    }

    public RowColumnLabelSQLEntryPanelHandler(MainPanel mainPanel, CaretListener caretListener) {
        this._mainPanel = mainPanel;
        this._mainPanel.addMainPanelTabSelectionListener(newSelectedMainPanelTab -> this.onMainTabSelected(newSelectedMainPanelTab));
        this._caretListener = caretListener;
        this._mainPanel.getMainSQLPanel().getSQLEntryPanel().addCaretListener(this._caretListener);
    }

    private void onMainTabSelected(IMainPanelTab newSelectedMainPanelTab) {
        if (newSelectedMainPanelTab instanceof BaseSQLTab) {
            ISQLEntryPanel sqlEntryPanel = ((BaseSQLTab)newSelectedMainPanelTab).getSQLPanel().getSQLEntryPanel();
            sqlEntryPanel.addCaretListener(this._caretListener);
            this.fireDummyCaretEventToTriggerRowColumnUpdate(sqlEntryPanel);
        }
    }

    private void fireDummyCaretEventToTriggerRowColumnUpdate(ISQLEntryPanel sqlEntryPanel) {
        this._caretListener.caretUpdate(new CaretEvent(sqlEntryPanel){

            @Override
            public int getDot() {
                throw new IllegalStateException("Should not be called");
            }

            @Override
            public int getMark() {
                throw new IllegalStateException("Should not be called");
            }
        });
    }

    public CaretPositionInfo getCaretPositionInfo() {
        if (null != this._sqlEntryPanel) {
            return new CaretPositionInfo(this._sqlEntryPanel.getCaretLineNumber(), this._sqlEntryPanel.getCaretLinePosition(), this._sqlEntryPanel.getCaretPosition());
        }
        SQLPanel sqlPanel = this._mainPanel.getSelectedSQLPanel();
        if (null == sqlPanel) {
            return null;
        }
        ISQLEntryPanel sqlEntryPanel = sqlPanel.getSQLEntryPanel();
        return new CaretPositionInfo(sqlEntryPanel.getCaretLineNumber(), sqlEntryPanel.getCaretLinePosition(), sqlEntryPanel.getCaretPosition());
    }
}

