/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupCompletionInfo;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupCompletorModel;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.SimpleSessionListener;
import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.Completor;
import net.sourceforge.squirrel_sql.fw.completion.CompletorListener;
import net.sourceforge.squirrel_sql.fw.props.Props;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class ToolsPopupController {
    public static final String TOOLS_POPUP_SELECTED_ACTION_COMMAND = "ToolsPopupSelected";
    private ToolsPopupCompletorModel _toolsPopupCompletorModel;
    private ISQLEntryPanel _sqlEntryPanel;
    private ISession _session;
    private Completor _toolsCompletor;
    private static final String PREFS_KEY_CTRL_T_COUNT = "squirrelSql_toolsPopup_ctrl_t_count";
    private int _ctrlTCount;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ToolsPopupController.class);

    public ToolsPopupController(ISession session, ISQLEntryPanel sqlEntryPanel) {
        this._sqlEntryPanel = sqlEntryPanel;
        this._session = session;
        this._toolsPopupCompletorModel = new ToolsPopupCompletorModel();
        CompletorListener completorListener = new CompletorListener(){

            @Override
            public void completionSelected(CompletionInfo completion, int replaceBegin, int keyCode, int modifiers) {
                ToolsPopupController.this.onToolsPopupActionSelected(completion);
            }
        };
        this._toolsCompletor = new Completor(this._sqlEntryPanel.getTextComponent(), this._toolsPopupCompletorModel, completorListener, new Color(255, 204, 204), true);
        sqlEntryPanel.getSession().addSimpleSessionListener(new SimpleSessionListener(){

            @Override
            public void sessionClosed() {
                ToolsPopupController.this._toolsCompletor.disposePopup();
            }
        });
        this._ctrlTCount = Props.getInt(PREFS_KEY_CTRL_T_COUNT, 0);
        if (3 > this._ctrlTCount) {
            this._session.showMessage(s_stringMgr.getString("ToolsPopupController.toolspopupmsg"));
        }
    }

    private void onToolsPopupActionSelected(CompletionInfo completion) {
        ToolsPopupCompletionInfo toExecute = (ToolsPopupCompletionInfo)completion;
        toExecute.getAction().actionPerformed(new ActionEvent(this._sqlEntryPanel.getTextComponent(), this._session.getIdentifier().hashCode(), TOOLS_POPUP_SELECTED_ACTION_COMMAND));
    }

    public void showToolsPopup() {
        if (3 > this._ctrlTCount) {
            int ctrlTCount = Props.getInt(PREFS_KEY_CTRL_T_COUNT, 0);
            Props.putInt(PREFS_KEY_CTRL_T_COUNT, ++ctrlTCount);
        }
        this._toolsCompletor.show();
    }

    public void addAction(String selectionString, Action action) {
        this._toolsPopupCompletorModel.addAction(selectionString, action);
    }
}

