/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.nio.charset.Charset;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.dataimport.gui.ImportFileDialogProps;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.csv.CSVSettingsBean;

public class CSVSettingsPanel
extends JPanel {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(CSVSettingsPanel.class);
    private CSVSettingsBean settings = null;
    private JTextField seperatorChar = null;
    private JTextField dateFormat = null;
    private JRadioButton useChar = null;
    private JRadioButton useTab = null;
    private JComboBox encoding = null;

    public CSVSettingsPanel(CSVSettingsBean settings) {
        this.settings = settings;
        this.init();
        this.loadSettings();
    }

    private void init() {
        ActionListener stateChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CSVSettingsPanel.this.stateChanged();
            }
        };
        KeyAdapter keyStateChangedListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CSVSettingsPanel.this.stateChanged();
            }
        };
        this.seperatorChar = new JTextField(2);
        this.seperatorChar.addActionListener(stateChangedListener);
        this.seperatorChar.addKeyListener(keyStateChangedListener);
        this.seperatorChar.setToolTipText(stringMgr.getString("CSVSettingsPanel.seperatorCharToolTip"));
        this.dateFormat = new JTextField(20);
        this.dateFormat.addActionListener(stateChangedListener);
        this.dateFormat.addKeyListener(keyStateChangedListener);
        this.useTab = new JRadioButton(stringMgr.getString("CSVSettingsPanel.useTab"));
        this.useChar = new JRadioButton(stringMgr.getString("CSVSettingsPanel.useChar"));
        this.useChar.setSelected(true);
        this.useTab.addActionListener(stateChangedListener);
        this.useChar.addActionListener(stateChangedListener);
        this.encoding = new JComboBox();
        for (String c : Charset.availableCharsets().keySet()) {
            this.encoding.addItem(c);
        }
        this.encoding.addActionListener(stateChangedListener);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.useTab);
        bg.add(this.useChar);
        FormLayout layout = new FormLayout("pref, 6dlu, pref, 12dlu, pref:grow", "pref, 6dlu, pref, 6dlu, pref, 6dlu, pref, 6dlu");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        builder.setDefaultDialogBorder();
        int y = 1;
        builder.addSeparator(stringMgr.getString("CSVSettingsPanel.csvSettings"), cc.xywh(1, y, 5, 1));
        builder.add((Component)this.useChar, cc.xy(1, y += 2));
        builder.add((Component)this.seperatorChar, cc.xy(3, y));
        builder.add((Component)this.useTab, cc.xy(5, y));
        builder.add((Component)new JLabel(stringMgr.getString("CSVSettingsPanel.inputFileEncoding")), cc.xywh(1, y += 2, 3, 1));
        builder.add((Component)this.encoding, cc.xy(5, y));
        builder.add((Component)new JLabel(stringMgr.getString("CSVSettingsPanel.dateFormat")), cc.xywh(1, y += 2, 3, 1));
        builder.add((Component)this.dateFormat, cc.xy(5, y));
        this.add(builder.getPanel());
    }

    private void applySettings() {
        if (this.useTab.isSelected()) {
            this.settings.setSeperator('\t');
        } else if (this.seperatorChar.getText().length() > 0) {
            this.settings.setSeperator(this.seperatorChar.getText().charAt(0));
        } else {
            this.settings.setSeperator(';');
        }
        this.settings.setImportCharset(Charset.forName(this.encoding.getSelectedItem().toString()));
        this.settings.setDateFormat(this.dateFormat.getText());
        ImportFileDialogProps.setCSVSeparator(this.settings.getSeperator());
        ImportFileDialogProps.setCSVDateFormat(this.settings.getDateFormat());
    }

    private void loadSettings() {
        if (this.settings.getSeperator() == '\t') {
            this.useTab.setSelected(true);
        } else {
            this.useChar.setSelected(true);
            this.seperatorChar.setText(Character.toString(this.settings.getSeperator()));
        }
        this.dateFormat.setText(this.settings.getDateFormat());
        this.encoding.setSelectedItem(this.settings.getImportCharset().name());
    }

    private void stateChanged() {
        if (this.seperatorChar.getText().length() > 1) {
            try {
                this.seperatorChar.setText(this.seperatorChar.getText(0, 1));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.useTab.isSelected()) {
            this.seperatorChar.setEnabled(false);
        } else {
            this.seperatorChar.setEnabled(true);
        }
        this.applySettings();
    }
}

