/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer;

import java.util.Calendar;
import java.util.Date;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class FailedToInterpretHandler {
    private static final StringManager stringMgr = StringManagerFactory.getStringManager(FailedToInterpretHandler.class);
    private static final ILogger s_log = LoggerController.createLogger(FailedToInterpretHandler.class);
    private int numberOfLogs = 0;

    public Double failedToInterpretNumeric(int column, String toInterpret) {
        if (10 == this.numberOfLogs) {
            String msg = stringMgr.getString("ExcelFileImporter.failed.to.interpret.numeric.no.more.messages", new Object[]{this.numberOfLogs});
            Main.getApplication().getMessageHandler().showErrorMessage(msg);
            s_log.error((Object)msg);
            ++this.numberOfLogs;
            return this.getNumericDummy();
        }
        if (10 < this.numberOfLogs) {
            return this.getNumericDummy();
        }
        String msg = stringMgr.getString("ExcelFileImporter.failed.to.interpret.numeric", new Object[]{toInterpret, column + 1, this.getNumericDummy()});
        Main.getApplication().getMessageHandler().showErrorMessage(msg);
        s_log.error((Object)msg);
        ++this.numberOfLogs;
        return this.getNumericDummy();
    }

    public Double getNumericDummy() {
        return -42.0;
    }

    public Date failedToInterpretDate(int column, String toInterpret) {
        String msg;
        if (10 == this.numberOfLogs) {
            msg = stringMgr.getString("ExcelFileImporter.failed.to.interpret.date.no.more.messages", new Object[]{this.numberOfLogs});
            Main.getApplication().getMessageHandler().showErrorMessage(msg);
            s_log.error((Object)msg);
            ++this.numberOfLogs;
        } else if (10 < this.numberOfLogs) {
            return this.getDummyDate();
        }
        msg = stringMgr.getString("ExcelFileImporter.failed.to.interpret.date", new Object[]{toInterpret, column + 1, this.getDummyDate()});
        Main.getApplication().getMessageHandler().showErrorMessage(msg);
        s_log.error((Object)msg);
        ++this.numberOfLogs;
        return this.getDummyDate();
    }

    private Date getDummyDate() {
        Calendar cal = Calendar.getInstance();
        cal.set(1977, 6, 7);
        return cal.getTime();
    }
}

