/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.smarttools.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.smarttools.SmarttoolsHelper;
import net.sourceforge.squirrel_sql.plugins.smarttools.comp.STButton;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.ISmarttoolFrame;
import net.sourceforge.squirrel_sql.plugins.smarttools.gui.SmarttoolCreateIndexD;

public class SmarttoolMissingIndicesFrame
extends DialogWidget
implements ISmarttoolFrame,
ActionListener {
    private static final long serialVersionUID = 3680564513241320485L;
    private final int START_WORKING = 1;
    private final int STOP_WORKING = 2;
    private final int COL_TABLENAME = 0;
    private final int COL_RECORDS = 1;
    private final int COL_PRIMARY = 2;
    private final int COL_UNIQUE = 3;
    private final int COL_SUMMARY = 4;
    private static final ILogger log = LoggerController.createLogger(SmarttoolMissingIndicesFrame.class);
    private static final StringManager stringManager = StringManagerFactory.getStringManager(SmarttoolMissingIndicesFrame.class);
    private ISession session;
    private Thread threadWork = null;
    private boolean threadSuspended;
    private Vector<String> vecHeader = new Vector();
    private Vector<Vector<Object>> vecData = new Vector();
    private JLabel lblTitleTable = new JLabel();
    private JLabel lblTablename = new JLabel();
    private JTextField tfTablename = new JTextField();
    private JRadioButton rbDisplayTypeAll = new JRadioButton();
    private ButtonGroup buttongroup1 = new ButtonGroup();
    private JRadioButton rbDisplayTypePK = new JRadioButton();
    private JRadioButton rbDisplayTypeUI = new JRadioButton();
    private JLabel lblDisplayType = new JLabel();
    private STButton btnStart = new STButton();
    private STButton btnStop = new STButton();
    private JLabel lblTitleTableResult = new JLabel();
    private JLabel lblFooterTableResult = new JLabel();
    private STButton btnPrint = new STButton();
    private STButton btnDdl = new STButton();
    private STButton btnRecordCount = new STButton();
    private JTable tblResult = null;
    private JProgressBar pbMain = new JProgressBar();

    public SmarttoolMissingIndicesFrame(ISession session, String title) {
        super("Smarttool - " + title, true, true, true, true, session.getApplication());
        this.session = session;
        this.initLayout();
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
        this.moveToFront();
    }

    private void initLayout() {
        this.getContentPane().setLayout(new BorderLayout());
        this.createTableHeader();
        this.tblResult = new JTable(this.vecData, this.vecHeader);
        this.getContentPane().add(this.createPanel());
        this.initVisualObjects();
    }

    public JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE", "CENTER:2DLU:NONE,FILL:DEFAULT:NONE,CENTER:DEFAULT:NONE,FILL:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,FILL:DEFAULT:GROW(1.0),CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        jpanel1.setLayout((LayoutManager)formlayout1);
        this.pbMain.setName("pbMain");
        this.pbMain.setValue(25);
        jpanel1.add((Component)this.pbMain, cc.xywh(2, 15, 3, 1));
        jpanel1.add((Component)this.createpanelTableAndColumn(), cc.xy(2, 2));
        jpanel1.add((Component)this.createpanelButton(), cc.xy(4, 2));
        this.lblTitleTableResult.setBackground(new Color(102, 102, 102));
        this.lblTitleTableResult.setName("lblTitleTableResult");
        this.lblTitleTableResult.setOpaque(true);
        this.lblTitleTableResult.setText(" Searching for ...");
        jpanel1.add((Component)this.lblTitleTableResult, cc.xy(2, 4));
        this.lblFooterTableResult.setBackground(new Color(102, 102, 102));
        this.lblFooterTableResult.setName("lblFooterTableResult");
        this.lblFooterTableResult.setOpaque(true);
        this.lblFooterTableResult.setText(" Finshed in ...");
        jpanel1.add((Component)this.lblFooterTableResult, cc.xywh(2, 13, 3, 1));
        this.btnPrint.setActionCommand("Print");
        this.btnPrint.setName("btnPrint");
        this.btnPrint.setText("Print");
        jpanel1.add((Component)this.btnPrint, cc.xy(4, 4));
        this.tblResult.setName("tblResult");
        JScrollPane jscrollpane1 = new JScrollPane();
        jscrollpane1.setViewportView(this.tblResult);
        jscrollpane1.setVerticalScrollBarPolicy(20);
        jscrollpane1.setHorizontalScrollBarPolicy(30);
        jpanel1.add((Component)jscrollpane1, cc.xywh(2, 7, 1, 5));
        this.btnDdl.setActionCommand("ddl");
        this.btnDdl.setName("btnDdl");
        this.btnDdl.setText("ddl");
        this.btnDdl.setToolTipText("create ddl statement for primary key or unique index");
        jpanel1.add((Component)this.btnDdl, cc.xy(4, 7));
        this.btnRecordCount.setActionCommand("records");
        this.btnRecordCount.setName("btnRecordCount");
        this.btnRecordCount.setText("records");
        this.btnRecordCount.setToolTipText("determine the record count of the displayed tables");
        jpanel1.add((Component)this.btnRecordCount, cc.xy(4, 9));
        return jpanel1;
    }

    public JPanel createpanelTableAndColumn() {
        JPanel panelTableAndColumn = new JPanel();
        panelTableAndColumn.setName("panelTableAndColumn");
        EtchedBorder etchedborder1 = new EtchedBorder(0, null, null);
        panelTableAndColumn.setBorder(etchedborder1);
        FormLayout formlayout1 = new FormLayout("FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:GROW(1.0),FILL:4DLU:NONE", "CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE,CENTER:2DLU:NONE");
        CellConstraints cc = new CellConstraints();
        panelTableAndColumn.setLayout((LayoutManager)formlayout1);
        this.lblTitleTable.setBackground(new Color(102, 102, 102));
        this.lblTitleTable.setName("lblTitleTable");
        this.lblTitleTable.setOpaque(true);
        this.lblTitleTable.setText(" Used tables");
        panelTableAndColumn.add((Component)this.lblTitleTable, cc.xywh(1, 1, 5, 1));
        this.lblTablename.setName("lblTablename");
        this.lblTablename.setText("table name");
        panelTableAndColumn.add((Component)this.lblTablename, cc.xy(2, 3));
        this.tfTablename.setName("tfTablename");
        panelTableAndColumn.add((Component)this.tfTablename, cc.xy(4, 3));
        panelTableAndColumn.add((Component)this.createpanelDisplayType(), cc.xy(4, 5));
        this.lblDisplayType.setName("lblDisplayType");
        this.lblDisplayType.setText("display");
        panelTableAndColumn.add((Component)this.lblDisplayType, cc.xy(2, 5));
        return panelTableAndColumn;
    }

    public JPanel createpanelDisplayType() {
        JPanel panelDisplayType = new JPanel();
        panelDisplayType.setName("panelDisplayType");
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE,FILL:4DLU:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        panelDisplayType.setLayout((LayoutManager)formlayout1);
        this.rbDisplayTypeAll.setActionCommand("all entries");
        this.rbDisplayTypeAll.setName("rbDisplayTypeAll");
        this.rbDisplayTypeAll.setText("all entries");
        this.buttongroup1.add(this.rbDisplayTypeAll);
        panelDisplayType.add((Component)this.rbDisplayTypeAll, cc.xy(1, 1));
        this.rbDisplayTypePK.setActionCommand("missing primary key");
        this.rbDisplayTypePK.setName("rbDisplayTypePK");
        this.rbDisplayTypePK.setText("missing primary key");
        this.buttongroup1.add(this.rbDisplayTypePK);
        panelDisplayType.add((Component)this.rbDisplayTypePK, cc.xy(3, 1));
        this.rbDisplayTypeUI.setActionCommand("missing unique index");
        this.rbDisplayTypeUI.setName("rbDisplayTypeUI");
        this.rbDisplayTypeUI.setText("missing unique index");
        this.buttongroup1.add(this.rbDisplayTypeUI);
        panelDisplayType.add((Component)this.rbDisplayTypeUI, cc.xy(5, 1));
        return panelDisplayType;
    }

    public JPanel createpanelButton() {
        JPanel panelButton = new JPanel();
        panelButton.setName("panelButton");
        FormLayout formlayout1 = new FormLayout("FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:2DLU:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cc = new CellConstraints();
        panelButton.setLayout((LayoutManager)formlayout1);
        this.btnStart.setActionCommand("Start");
        this.btnStart.setName("btnStart");
        this.btnStart.setText("Start");
        panelButton.add((Component)this.btnStart, cc.xy(1, 1));
        this.btnStop.setActionCommand("Stop");
        this.btnStop.setName("btnStop");
        this.btnStop.setText("Stop");
        panelButton.add((Component)this.btnStop, cc.xy(1, 3));
        return panelButton;
    }

    @Override
    public void setFocusToFirstEmptyInputField() {
    }

    private void initVisualObjects() {
        this.lblTitleTable.setText(this.getTitle());
        this.lblTablename.setText(i18n.LBL_TABLENAME);
        this.lblTitleTableResult.setText(" " + i18n.INFO_REPORT);
        this.lblFooterTableResult.setText("");
        this.lblDisplayType.setText(i18n.LBL_DISPLAYTYPE);
        this.tfTablename.setToolTipText(i18n.TOOLTIP_WILDCARD);
        this.rbDisplayTypeAll.setText(i18n.LBL_RB_DISPLAYTYPE_ALL);
        this.rbDisplayTypeAll.setToolTipText(i18n.TOOLTIP_RB_DISPLAYTYPE_ALL);
        this.rbDisplayTypePK.setText(i18n.LBL_RB_DISPLAYTYPE_PK);
        this.rbDisplayTypePK.setToolTipText(i18n.TOOLTIP_RB_DISPLAYTYPE_PK);
        this.rbDisplayTypeUI.setText(i18n.LBL_RB_DISPLAYTYPE_UI);
        this.rbDisplayTypeUI.setToolTipText(i18n.TOOLTIP_RB_DISPLAYTYPE_UI);
        this.rbDisplayTypeUI.setSelected(true);
        this.btnStart.setText(i18n.LBL_BTN_START);
        this.btnStart.setIcon(SmarttoolsHelper.loadIcon("start16x16.png"));
        this.btnStart.addActionListener(this);
        this.btnStop.setText(i18n.LBL_BTN_STOP);
        this.btnStop.setIcon(SmarttoolsHelper.loadIcon("stop16x16.png"));
        this.btnStop.addActionListener(this);
        this.btnStop.setEnabled(false);
        this.btnPrint.setText(i18n.LBL_BTN_PRINT);
        this.btnPrint.setIcon(SmarttoolsHelper.loadIcon("printer16x16.png"));
        this.btnPrint.addActionListener(this);
        this.btnPrint.setEnabled(false);
        this.btnDdl.setText(i18n.LBL_BTN_DDL);
        this.btnDdl.setToolTipText(i18n.TOOLTIP_BTN_DDL);
        this.btnDdl.setIcon(SmarttoolsHelper.loadIcon("change16x16.png"));
        this.btnDdl.addActionListener(this);
        this.btnDdl.setEnabled(false);
        this.btnRecordCount.setText(i18n.LBL_BTN_RECORDS);
        this.btnRecordCount.setToolTipText(i18n.TOOLTIP_BTN_RECORDS);
        this.btnRecordCount.setIcon(SmarttoolsHelper.loadIcon("count16x16.png"));
        this.btnRecordCount.addActionListener(this);
        this.btnRecordCount.setEnabled(false);
        this.initTableColumnWidth();
        this.tblResult.setDefaultRenderer(Object.class, new Renderer());
        this.pbMain.setValue(0);
        this.pbMain.setStringPainted(true);
    }

    private void createTableHeader() {
        this.vecHeader.add(i18n.GLOBAL_TABLE);
        this.vecHeader.add(i18n.TABLECOLUMN_RECORD_COUNT);
        this.vecHeader.add(i18n.TABLECOLUMN_PRIMARY_KEY_COUNT);
        this.vecHeader.add(i18n.TABLECOLUMN_UNIQUE_INDEX_COUNT);
        this.vecHeader.add(i18n.TABLECOLUMN_INDEX_COUNT);
    }

    public void controlComponents(int type) {
        if (type == 1 || type == 2) {
            boolean b = type == 2;
            this.tfTablename.setEnabled(b);
            this.btnStart.setEnabled(b);
            this.btnStop.setEnabled(!b);
            this.btnPrint.setEnabled(b && this.tblResult.getRowCount() > 0);
            this.btnDdl.setEnabled(this.btnPrint.isEnabled());
            this.btnRecordCount.setEnabled(this.btnPrint.isEnabled());
        }
    }

    private void startWork() {
        this.controlComponents(1);
        this.threadWork = new ThreadWork();
        this.threadWork.start();
    }

    private void stopWork() {
        this.threadSuspended = true;
        if (JOptionPane.showConfirmDialog((Component)this.session.getApplication().getMainFrame(), i18n.QUESTION_CANCEL_WORK, i18n.QUESTION_CANCEL_WORK_TITLE, 0) == 0) {
            this.threadWork = null;
            this.controlComponents(2);
        }
        this.threadSuspended = false;
    }

    private void printResult() {
        try {
            MessageFormat headerFormat = new MessageFormat(this.lblTitleTable.getText());
            MessageFormat footerFormat = new MessageFormat(i18n.GLOBAL_ALIAS + ": " + this.session.getAlias().getName() + " | " + DateFormat.getDateTimeInstance(2, 3).format(new Date()) + " | " + i18n.GLOBAL_PAGE + " {0} ");
            this.tblResult.print(JTable.PrintMode.FIT_WIDTH, headerFormat, footerFormat);
        }
        catch (PrinterException e) {
            log.error((Object)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRecordCounts() {
        Statement stmt = null;
        try {
            stmt = this.session.getSQLConnection().createStatement();
            for (int i = 0; i < this.tblResult.getRowCount() - 1; ++i) {
                int records = this.getRecordCount(stmt, (String)this.tblResult.getValueAt(i, 0));
                this.tblResult.setValueAt(new Integer(records), i, 1);
                ((DefaultTableModel)this.tblResult.getModel()).fireTableDataChanged();
            }
            stmt.close();
            stmt = null;
        }
        catch (SQLException e) {
            try {
                log.error((Object)e.getLocalizedMessage());
            }
            catch (Throwable throwable) {
                SQLUtilities.closeStatement(stmt);
                throw throwable;
            }
            SQLUtilities.closeStatement((Statement)stmt);
        }
        SQLUtilities.closeStatement((Statement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getRecordCount(Statement stmt, String tablename) throws SQLException {
        int recordCount = 0;
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT COUNT(*) FROM " + tablename);
            if (rs.next()) {
                recordCount = rs.getInt(1);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        return recordCount;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnStart) {
            this.startWork();
        } else if (e.getSource() == this.btnStop) {
            this.stopWork();
        } else if (e.getSource() == this.btnPrint) {
            this.printResult();
        } else if (e.getSource() == this.btnDdl) {
            if (this.tblResult.getSelectedRow() > -1) {
                new SmarttoolCreateIndexD(null, this.session, (String)this.tblResult.getValueAt(this.tblResult.getSelectedRow(), 0));
            } else {
                JOptionPane.showMessageDialog((Component)this.session.getApplication().getMainFrame(), i18n.ERROR_NO_ROW_SELECTED);
            }
        }
        if (e.getSource() == this.btnRecordCount) {
            this.getRecordCounts();
        }
    }

    private void initTableColumnWidth() {
        TableColumnModel tcm = this.tblResult.getTableHeader().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(190);
        tcm.getColumn(1).setPreferredWidth(80);
        tcm.getColumn(2).setPreferredWidth(90);
        tcm.getColumn(3).setPreferredWidth(100);
        tcm.getColumn(4).setPreferredWidth(60);
    }

    static /* synthetic */ StringManager access$000() {
        return stringManager;
    }

    private class Renderer
    implements TableCellRenderer {
        private ImageIcon iconMarked = SmarttoolsHelper.loadIcon("gridMarked16x16.png");
        private ImageIcon iconDemarked = SmarttoolsHelper.loadIcon("gridDemarked16x16.png");
        private ImageIcon iconMarkedSelected = SmarttoolsHelper.loadIcon("gridMarkedSelected16x16.png");
        private ImageIcon iconDemarkedSelected = SmarttoolsHelper.loadIcon("gridDemarkedSelected16x16.png");

        private Renderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel lbl = new JLabel(value + "");
            lbl.setOpaque(true);
            if (isSelected) {
                lbl.setBackground(SmarttoolMissingIndicesFrame.this.tblResult.getSelectionBackground());
                lbl.setForeground(SmarttoolMissingIndicesFrame.this.tblResult.getSelectionForeground());
            } else {
                lbl.setBackground(SmarttoolMissingIndicesFrame.this.tblResult.getBackground());
                lbl.setForeground(SmarttoolMissingIndicesFrame.this.tblResult.getForeground());
            }
            if (column >= 1) {
                if (column == 2) {
                    lbl.setText("");
                    if ((Integer)value == 0) {
                        if (isSelected) {
                            lbl.setIcon(this.iconDemarkedSelected);
                        } else {
                            lbl.setIcon(this.iconDemarked);
                        }
                    } else if (isSelected) {
                        lbl.setIcon(this.iconMarkedSelected);
                    } else {
                        lbl.setIcon(this.iconMarked);
                    }
                }
                lbl.setHorizontalAlignment(0);
                if ((Integer)value == 0) {
                    if (column == 2) {
                        lbl.setBackground(Color.ORANGE);
                    } else if (column > 2) {
                        lbl.setBackground(Color.RED);
                    }
                }
            } else {
                lbl.setHorizontalAlignment(10);
            }
            return lbl;
        }
    }

    class ThreadWork
    extends Thread {
        private Thread thisThread = null;

        ThreadWork() {
        }

        @Override
        public void run() {
            super.run();
            this.thisThread = Thread.currentThread();
            this.startTest();
            SmarttoolMissingIndicesFrame.this.controlComponents(2);
            SmarttoolMissingIndicesFrame.this.threadWork = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isThreadInvalid() {
            if (this.thisThread != SmarttoolMissingIndicesFrame.this.threadWork) {
                return true;
            }
            try {
                ThreadWork threadWork = this;
                synchronized (threadWork) {
                    while (SmarttoolMissingIndicesFrame.this.threadSuspended) {
                        this.wait(200L);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }

        private void startTest() {
            long startTime = System.currentTimeMillis();
            boolean error = false;
            ((DefaultTableModel)SmarttoolMissingIndicesFrame.this.tblResult.getModel()).setDataVector(new Vector(), SmarttoolMissingIndicesFrame.this.vecHeader);
            String tableNamePattern = SmarttoolMissingIndicesFrame.this.tfTablename.getText().trim();
            if (tableNamePattern.length() == 0) {
                tableNamePattern = "%";
            }
            try {
                ITableInfo[] tableInfoArray = SmarttoolMissingIndicesFrame.this.session.getMetaData().getTables(null, null, tableNamePattern, new String[]{"TABLE"}, null);
                SmarttoolMissingIndicesFrame.this.lblFooterTableResult.setText("");
                SmarttoolMissingIndicesFrame.this.pbMain.setValue(0);
                SmarttoolMissingIndicesFrame.this.pbMain.setMaximum(tableInfoArray.length);
                for (int iTableInfo = 0; iTableInfo < tableInfoArray.length; ++iTableInfo) {
                    ITableInfo tableInfo = tableInfoArray[iTableInfo];
                    SmarttoolMissingIndicesFrame.this.pbMain.setString(tableInfo.getSimpleName() + " " + (iTableInfo + 1) + "/" + SmarttoolMissingIndicesFrame.this.pbMain.getMaximum());
                    if (!this.checkIndices(tableInfo)) {
                        error = true;
                    }
                    SmarttoolMissingIndicesFrame.this.pbMain.setValue(iTableInfo + 1);
                    SmarttoolMissingIndicesFrame.this.pbMain.repaint();
                    if (this.isThreadInvalid()) break;
                }
                long diffTime = System.currentTimeMillis() - startTime;
                SmarttoolMissingIndicesFrame.this.lblFooterTableResult.setText(" " + i18n.INFO_FINISHED + " " + diffTime + " ms");
                if (error) {
                    JOptionPane.showMessageDialog(null, i18n.ERROR_RECORD_COUNT);
                }
            }
            catch (SQLException e) {
                log.error((Object)e);
                JOptionPane.showMessageDialog(null, i18n.ERROR_READ_CHECKING_DATA);
            }
        }

        private boolean checkIndices(ITableInfo tableInfo) throws SQLException {
            int uniqueIndexCount = 0;
            int recordCount = 0;
            List listIndexInfo = SmarttoolMissingIndicesFrame.this.session.getMetaData().getIndexInfo(tableInfo);
            for (int iIndexInfo = 0; iIndexInfo < listIndexInfo.size(); ++iIndexInfo) {
                if (((IndexInfo)listIndexInfo.get(iIndexInfo)).isNonUnique()) continue;
                ++uniqueIndexCount;
            }
            PrimaryKeyInfo[] arrayPrimaryKeyInfo = SmarttoolMissingIndicesFrame.this.session.getMetaData().getPrimaryKey(tableInfo);
            if (SmarttoolMissingIndicesFrame.this.rbDisplayTypeAll.isSelected() || SmarttoolMissingIndicesFrame.this.rbDisplayTypePK.isSelected() && arrayPrimaryKeyInfo.length == 0 || uniqueIndexCount == 0) {
                this.addTableEntry(tableInfo.getSimpleName(), recordCount, arrayPrimaryKeyInfo.length, uniqueIndexCount, listIndexInfo.size());
            }
            return recordCount > -1;
        }

        private void addTableEntry(String tableName, int recordCount, int primaryKey, int uniqueIndices, int indexSummary) {
            Vector<Object> vecRow = new Vector<Object>();
            vecRow.add(tableName);
            vecRow.add(recordCount);
            vecRow.add(primaryKey);
            vecRow.add(uniqueIndices);
            vecRow.add(indexSummary);
            DefaultTableModel tm = (DefaultTableModel)SmarttoolMissingIndicesFrame.this.tblResult.getModel();
            tm.addRow(vecRow);
            tm.fireTableDataChanged();
            SmarttoolMissingIndicesFrame.this.initTableColumnWidth();
        }
    }

    private static interface i18n {
        public static final String LBL_TITLE_USED_TABLES = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.title.tables");
        public static final String LBL_TABLENAME = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.table.name");
        public static final String LBL_DISPLAYTYPE = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.display.type");
        public static final String LBL_RB_DISPLAYTYPE_ALL = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.radiobutton.display.type.all");
        public static final String LBL_RB_DISPLAYTYPE_PK = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.radiobutton.display.type.primarykey");
        public static final String LBL_RB_DISPLAYTYPE_UI = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.radiobutton.display.type.uniqueindex");
        public static final String TABLECOLUMN_PRIMARY_KEY_COUNT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.tablecolumn.primarykey");
        public static final String TABLECOLUMN_UNIQUE_INDEX_COUNT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.tablecolumn.uniqueindices");
        public static final String TABLECOLUMN_INDEX_COUNT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.tablecolumn.indices");
        public static final String TABLECOLUMN_RECORD_COUNT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.tablecolumn.records");
        public static final String LBL_BTN_START = SmarttoolMissingIndicesFrame.access$000().getString("global.lbl.btn.start");
        public static final String LBL_BTN_STOP = SmarttoolMissingIndicesFrame.access$000().getString("global.lbl.btn.stop");
        public static final String LBL_BTN_PRINT = SmarttoolMissingIndicesFrame.access$000().getString("global.lbl.btn.print");
        public static final String LBL_BTN_DDL = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.btn.ddl");
        public static final String TOOLTIP_BTN_DDL = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.btn.ddl");
        public static final String LBL_BTN_RECORDS = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.lbl.btn.records");
        public static final String TOOLTIP_BTN_RECORDS = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.btn.records");
        public static final String TOOLTIP_WILDCARD = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.wildcard");
        public static final String TOOLTIP_RB_DISPLAYTYPE_ALL = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.radiobutton.display.type.all");
        public static final String TOOLTIP_RB_DISPLAYTYPE_PK = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.radiobutton.display.type.primarykey");
        public static final String TOOLTIP_RB_DISPLAYTYPE_UI = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.tooltip.radiobutton.display.type.uniqueindex");
        public static final String TOOLTIP_BTN_PRINT = SmarttoolMissingIndicesFrame.access$000().getString("global.tooltip.btn.print");
        public static final String GLOBAL_RECORDS = SmarttoolMissingIndicesFrame.access$000().getString("global.records");
        public static final String GLOBAL_TABLE = SmarttoolMissingIndicesFrame.access$000().getString("global.table");
        public static final String GLOBAL_COLUMN = SmarttoolMissingIndicesFrame.access$000().getString("global.column");
        public static final String GLOBAL_DATATYPE = SmarttoolMissingIndicesFrame.access$000().getString("global.datatype");
        public static final String GLOBAL_PAGE = SmarttoolMissingIndicesFrame.access$000().getString("global.page");
        public static final String GLOBAL_ALIAS = SmarttoolMissingIndicesFrame.access$000().getString("global.alias");
        public static final String QUESTION_CANCEL_WORK = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.question.cancel.work");
        public static final String QUESTION_CANCEL_WORK_TITLE = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.question.cancel.work.title");
        public static final String ERROR_READ_CHECKING_DATA = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.error.read.checking.data");
        public static final String ERROR_NO_ROW_SELECTED = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.error.no.row.selected");
        public static final String ERROR_RECORD_COUNT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.error.reading.recordcount");
        public static final String INFO_FINISHED = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.info.finished");
        public static final String INFO_REPORT = SmarttoolMissingIndicesFrame.access$000().getString("missingindices.info.report");
    }
}

