/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.graph.ColumnInfoModel;
import net.sourceforge.squirrel_sql.plugins.graph.IColumnTextArea;
import net.sourceforge.squirrel_sql.plugins.graph.TableToolTipProvider;
import net.sourceforge.squirrel_sql.plugins.graph.Zoomer;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndCallback;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndColumn;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndEvent;
import net.sourceforge.squirrel_sql.plugins.graph.nondbconst.DndHandler;

public class ZoomableColumnTextArea
extends JPanel
implements DndColumn,
IColumnTextArea {
    private TableToolTipProvider _toolTipProvider;
    private ColumnInfoModel _columnInfoModel;
    private Zoomer _zoomer;
    private DndHandler _dndHandler;

    public ZoomableColumnTextArea(TableToolTipProvider toolTipProvider, Zoomer zoomer, DndCallback dndCallback, ISession session) {
        this._toolTipProvider = toolTipProvider;
        this._zoomer = zoomer;
        this.setToolTipText("Just to make getToolTiptext() to be called");
        this._dndHandler = new DndHandler(dndCallback, this, session);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this._toolTipProvider.getToolTipText(event);
    }

    public void setColumnInfoModel(ColumnInfoModel columnInfoModel) {
        this._columnInfoModel = columnInfoModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform origTrans = g2d.getTransform();
        try {
            AffineTransform at = new AffineTransform(origTrans);
            at.scale(this._zoomer.getZoom(), this._zoomer.getZoom());
            g2d.setTransform(at);
            int textHeight = this.getTextHeight();
            int curBaseLine = textHeight - 3;
            for (int i = 0; i < this._columnInfoModel.getColCount(); ++i) {
                g2d.drawString(this._columnInfoModel.getOrderedColAt(i).toString(), 0, curBaseLine);
                curBaseLine += textHeight;
            }
        }
        finally {
            g2d.setTransform(origTrans);
        }
    }

    private int getTextHeight() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int textHeight = fm.getAscent() - fm.getLeading() - fm.getDescent() + 6;
        return textHeight;
    }

    private int getMaxTextWidht() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int maxTextWidht = fm.stringWidth(this._columnInfoModel.getColAt(0).toString());
        for (int i = 1; i < this._columnInfoModel.getColCount(); ++i) {
            maxTextWidht = Math.max(maxTextWidht, fm.stringWidth(this._columnInfoModel.getColAt(0).toString()));
        }
        return (int)((double)maxTextWidht * this._zoomer.getZoom() + 0.5);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ret = new Dimension();
        ret.width = this.getMaxTextWidht();
        ret.height = (int)(this._zoomer.getZoom() * (double)this._columnInfoModel.getColCount() * (double)this.getTextHeight() + 0.5);
        return ret;
    }

    @Override
    public DndEvent getDndEvent() {
        return this._dndHandler.getDndEvent();
    }

    @Override
    public void setDndEvent(DndEvent dndEvent) {
        this._dndHandler.setDndEvent(dndEvent);
    }

    @Override
    public Point getLocationInColumnTextArea() {
        return new Point(0, 0);
    }

    @Override
    public int getColumnHeight() {
        FontMetrics fm = this.getGraphics().getFontMetrics(this.getFont());
        return fm.getHeight();
    }

    @Override
    public int getMaxWidth() {
        int maxSize = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        for (int i = 0; i < this._columnInfoModel.getColCount(); ++i) {
            int buf = fm.stringWidth(this._columnInfoModel.getColAt(i).toString());
            if (maxSize >= buf) continue;
            maxSize = buf;
        }
        return maxSize;
    }
}

