/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tinylaf.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.plaf.ColorUIResource;
import net.sf.tinylaf.util.SBReference;

public class HSBReference
extends SBReference {
    protected int hue;
    protected boolean preserveGrey;

    public HSBReference(int hue, int sat, int bri, int ref) {
        this.hue = hue;
        this.sat = sat;
        this.bri = bri;
        this.ref = ref;
        this.preserveGrey = true;
    }

    public HSBReference(HSBReference other) {
        super(false);
        this.color = new ColorUIResource(other.color);
        this.hue = other.hue;
        this.sat = other.sat;
        this.bri = other.bri;
        this.ref = other.ref;
        this.preserveGrey = other.preserveGrey;
    }

    public void update(HSBReference other) {
        this.color = new ColorUIResource(other.color);
        this.hue = other.hue;
        this.sat = other.sat;
        this.bri = other.bri;
        this.ref = other.ref;
        this.preserveGrey = other.preserveGrey;
    }

    public void update(HSBReference other, Vector referenceColors) {
        this.color = new ColorUIResource(other.color);
        this.hue = other.hue;
        this.sat = other.sat;
        this.bri = other.bri;
        this.ref = other.ref;
        this.preserveGrey = other.preserveGrey;
    }

    public int getHue() {
        return this.hue;
    }

    public void setHue(int newHue) {
        this.hue = newHue;
    }

    public void load(DataInputStream in) throws IOException {
        try {
            this.hue = in.readInt();
            this.sat = in.readInt();
            this.bri = in.readInt();
            this.ref = in.readInt();
            this.preserveGrey = in.readBoolean();
        }
        catch (Exception ex) {
            throw new IOException("HSBReference.load() : " + ex.getMessage());
        }
    }

    public void save(DataOutputStream out) throws IOException {
        out.writeInt(this.hue);
        out.writeInt(this.sat);
        out.writeInt(this.bri);
        out.writeInt(this.ref);
        out.writeBoolean(this.preserveGrey);
    }

    public boolean isPreserveGrey() {
        return this.preserveGrey;
    }

    public void setPreserveGrey(boolean b) {
        this.preserveGrey = b;
    }

    public String toString() {
        return "HSBReference[bri=" + this.bri + ",sat=" + this.sat + ",hue=" + this.hue + ",ref=" + this.ref + ",c=(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")]";
    }
}

