/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.sessioninfo;

import java.awt.BorderLayout;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.oracle.OraclePlugin;
import net.sourceforge.squirrel_sql.plugins.oracle.common.AutoWidthResizeTable;

public class SessionInfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(SessionInfoPanel.class);
    private static final String SESSION_INFO_SQL = "SELECT sess.Sid,      sess.serial#,      NVL(sess.username, bgproc.name),      sess.schemaname,      sess.status,      sess.server,      sess.osuser,      sess.machine,      sess.terminal,      sess.program,      sess.process,      sess.type,      sess.module,      sess.action,      sess.client_Info,      sess_io.block_gets,      sess_io.consistent_gets,      sess_io.physical_reads,      sess_io.block_changes,      sess_io.consistent_changes,      sess_stat.value*10,      sess.last_call_et,      d.sql_text,      sess.sql_address || ':' || sql_hash_value,      sess.prev_sql_addr || ':' || prev_hash_value,      sess.logon_time FROM v$session sess,      v$bgprocess bgproc,     v$sess_io sess_io,      v$sesstat sess_stat,      v$sql d WHERE sess.sid = sess_io.sid ( + )   AND sess.sid = sess_stat.sid ( + )   AND sess.paddr = bgproc.paddr ( + )   AND ( sess_stat.statistic# = 12 OR sess_stat.statistic# IS NULL )   AND sess.sql_address = d.address ( + )   AND sess.sql_hash_value = d.hash_value ( + )   AND ( d.child_number = 0 OR d.child_number IS NULL ) ORDER BY sess.sid ";
    private transient ISession _session;
    private AutoWidthResizeTable _sessionInfo;
    private boolean hasResized = false;
    private transient Timer _refreshTimer = new Timer(true);
    private boolean _autoRefresh = false;
    private int _refreshPeriod = 10;

    public SessionInfoPanel(ISession session, int autoRefeshPeriod) {
        this._session = session;
        this._refreshPeriod = autoRefeshPeriod;
        this.createGUI();
    }

    public ISession getSession() {
        return this._session;
    }

    private void resetTimer() {
        if (this._refreshTimer != null) {
            this._refreshTimer.cancel();
            this._refreshTimer = null;
        }
        if (this._autoRefresh && this._refreshPeriod > 0) {
            this._refreshTimer = new Timer(true);
            this._refreshTimer.scheduleAtFixedRate((TimerTask)new RefreshTimerTask(), this._refreshPeriod * 1000, (long)(this._refreshPeriod * 1000));
        }
    }

    public void setAutoRefresh(boolean enable) {
        if (enable != this._autoRefresh) {
            this._autoRefresh = enable;
            this.resetTimer();
        }
    }

    public boolean getAutoRefesh() {
        return this._autoRefresh;
    }

    public void setAutoRefreshPeriod(int seconds) {
        if (this._refreshPeriod != seconds) {
            this._refreshPeriod = seconds;
            this.resetTimer();
        }
    }

    public int getAutoRefreshPeriod() {
        return this._refreshPeriod;
    }

    protected DefaultTableModel createTableModel() {
        DefaultTableModel tm = new DefaultTableModel();
        tm.addColumn("Sid");
        tm.addColumn("Serial #");
        tm.addColumn("Session Name");
        tm.addColumn("Schema");
        tm.addColumn("Status");
        tm.addColumn("Server");
        tm.addColumn("OS user");
        tm.addColumn("Machine");
        tm.addColumn("Terminal");
        tm.addColumn("Program");
        tm.addColumn("Process");
        tm.addColumn("Type");
        tm.addColumn("Module");
        tm.addColumn("Action");
        tm.addColumn("Client Info");
        tm.addColumn("Block Gets");
        tm.addColumn("Consistent Gets");
        tm.addColumn("Physical Reads");
        tm.addColumn("Block Changes");
        tm.addColumn("Consistent Changes");
        tm.addColumn("CPU time (ms)");
        tm.addColumn("Last SQL");
        tm.addColumn("Current SQL Statement");
        tm.addColumn("SQL Address");
        tm.addColumn("Prev SQL Address");
        tm.addColumn("Logon Time");
        return tm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateSessionInfo() {
        block8: {
            if (!OraclePlugin.checkObjectAccessible(this._session, SESSION_INFO_SQL)) {
                return;
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                Connection con = this._session.getSQLConnection().getConnection();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)"populateSessionInfo: running sql - SELECT sess.Sid,      sess.serial#,      NVL(sess.username, bgproc.name),      sess.schemaname,      sess.status,      sess.server,      sess.osuser,      sess.machine,      sess.terminal,      sess.program,      sess.process,      sess.type,      sess.module,      sess.action,      sess.client_Info,      sess_io.block_gets,      sess_io.consistent_gets,      sess_io.physical_reads,      sess_io.block_changes,      sess_io.consistent_changes,      sess_stat.value*10,      sess.last_call_et,      d.sql_text,      sess.sql_address || ':' || sql_hash_value,      sess.prev_sql_addr || ':' || prev_hash_value,      sess.logon_time FROM v$session sess,      v$bgprocess bgproc,     v$sess_io sess_io,      v$sesstat sess_stat,      v$sql d WHERE sess.sid = sess_io.sid ( + )   AND sess.sid = sess_stat.sid ( + )   AND sess.paddr = bgproc.paddr ( + )   AND ( sess_stat.statistic# = 12 OR sess_stat.statistic# IS NULL )   AND sess.sql_address = d.address ( + )   AND sess.sql_hash_value = d.hash_value ( + )   AND ( d.child_number = 0 OR d.child_number IS NULL ) ORDER BY sess.sid ");
                }
                pstmt = con.prepareStatement(SESSION_INFO_SQL);
                rs = pstmt.executeQuery();
                DefaultTableModel tm = this.createTableModel();
                while (rs.next()) {
                    String sid = rs.getString(1);
                    String serNum = rs.getString(2);
                    String sessionName = rs.getString(3);
                    String schema = rs.getString(4);
                    String status = rs.getString(5);
                    String server = rs.getString(6);
                    String OSusr = rs.getString(7);
                    String machine = rs.getString(8);
                    String terminal = rs.getString(9);
                    String program = rs.getString(10);
                    String process = rs.getString(11);
                    String type = rs.getString(12);
                    String module = rs.getString(13);
                    String action = rs.getString(14);
                    String clientInfo = rs.getString(15);
                    String blockGets = rs.getString(16);
                    String consistentGets = rs.getString(17);
                    String physReads = rs.getString(18);
                    String blockChanges = rs.getString(19);
                    String consistentChanges = rs.getString(20);
                    String CPUtime = rs.getString(21);
                    String lastSQL = rs.getString(22);
                    String currSQL = rs.getString(23);
                    String SQLaddr = rs.getString(24);
                    String prevSQLaddr = rs.getString(25);
                    String logonTime = rs.getString(26);
                    tm.addRow(new Object[]{sid, serNum, sessionName, schema, status, server, OSusr, machine, terminal, program, process, type, module, action, clientInfo, blockGets, consistentGets, physReads, blockChanges, consistentChanges, CPUtime, lastSQL, currSQL, SQLaddr, prevSQLaddr, logonTime});
                }
                this.updateTableModel(tm);
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
            catch (SQLException ex) {
                this._session.showErrorMessage((Throwable)ex);
                break block8;
            }
            finally {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement(pstmt);
            }
            SQLUtilities.closeStatement((Statement)pstmt);
        }
    }

    private void updateTableModel(final DefaultTableModel tm) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                SessionInfoPanel.this._sessionInfo.setModel(tm);
                if (!SessionInfoPanel.this.hasResized) {
                    SessionInfoPanel.this.hasResized = true;
                    SessionInfoPanel.this._sessionInfo.resizeColumnWidth(300);
                }
            }
        });
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this._sessionInfo = new AutoWidthResizeTable(new DefaultTableModel());
        this._sessionInfo.setAutoResizeMode(0);
        this.add(new JScrollPane(this._sessionInfo));
        this.populateSessionInfo();
    }

    public class RefreshTimerTask
    extends TimerTask {
        @Override
        public void run() {
            SessionInfoPanel.this.populateSessionInfo();
        }
    }
}

