/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.ExtractAttribute;
import unity.util.StringFunc;

public abstract class Expression
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Expression parent = null;
    protected ArrayList<Expression> children = new ArrayList(2);
    protected int returnType = -1;

    public abstract Object evaluate(Tuple var1) throws SQLException;

    public int getReturnType() {
        return this.returnType;
    }

    public void setReturnType(int n) {
        this.returnType = n;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setParent(Expression expression) {
        this.parent = expression;
    }

    public boolean hasChildren() {
        return this.getNumChildren() != 0;
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public Expression getChild(int n) {
        return n >= this.getNumChildren() || n < 0 ? null : this.children.get(n);
    }

    public Object computeType(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (StringFunc.isDelimited(string, '\'')) {
                string = StringFunc.removeQuotes(string);
            }
            this.returnType = 12;
            return string;
        }
        if (object instanceof Integer) {
            this.returnType = 4;
            return object;
        }
        if (object instanceof Double) {
            this.returnType = 8;
            return object;
        }
        if (object instanceof Date) {
            this.returnType = 91;
            return object;
        }
        this.returnType = 12;
        return object.toString();
    }

    public String toString(Relation relation) {
        return this.toString();
    }

    public String toString(Relation relation, Attribute attribute) {
        return this.toString();
    }

    public static ArrayList<Integer> getAttributeIndexReferences(Expression expression) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (expression instanceof ExtractAttribute) {
            arrayList.add(new Integer(((ExtractAttribute)expression).getAttributeLoc()));
        } else {
            for (int i = 0; i < expression.getNumChildren(); ++i) {
                Expression expression2 = expression.getChild(i);
                arrayList.addAll(Expression.getAttributeIndexReferences(expression2));
            }
        }
        return arrayList;
    }
}

