/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Aggregate_Function;
import unity.functions.Expression;

public class D_Count
extends Aggregate_Function {
    private static final long serialVersionUID = 1L;
    protected long counter;
    protected HashSet<Object> values;

    public D_Count(Expression expression) {
        this.children = new ArrayList(1);
        this.children.add(expression);
        this.computedExpr = expression;
        this.returnType = -5;
        this.values = new HashSet();
    }

    @Override
    public void reset() {
        this.counter = 0L;
        this.values = new HashSet();
    }

    @Override
    public void add(Tuple tuple) throws SQLException {
        Object object = this.computedExpr.evaluate(tuple);
        if (object != null && !this.values.contains(object)) {
            this.values.add(object);
            ++this.counter;
        }
    }

    @Override
    public Object compute() {
        return new Long(this.counter);
    }

    @Override
    public String toString(Relation relation, Attribute attribute) {
        return "COUNT(DISTINCT " + this.computedExpr.toString(relation) + ") AS " + attribute.getName();
    }
}

