/*
 * Decompiled with CFR 0.152.
 */
package unity.cache;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Timer;
import unity.cache.CacheEntry;
import unity.engine.Tuple;
import unity.query.GlobalQuery;

public class Cache {
    private int maxSize;
    private int size;
    private int cacheTimeoutMilliSeconds;
    private HashMap<String, CacheEntry> entries;
    private Timer timer;

    public Cache(int n, int n2) {
        this.maxSize = n;
        this.cacheTimeoutMilliSeconds = n2;
        this.entries = new HashMap(100);
        this.timer = new Timer(1000, new CacheCheck());
        this.timer.start();
    }

    public CacheEntry add(String string, GlobalQuery globalQuery, ArrayList<Tuple> arrayList) {
        long l = System.currentTimeMillis();
        CacheEntry cacheEntry = new CacheEntry(string, l + (long)this.cacheTimeoutMilliSeconds);
        cacheEntry.setQuery(globalQuery);
        cacheEntry.setTuples(arrayList);
        this.add(cacheEntry);
        return cacheEntry;
    }

    public int getExpiryTime() {
        return this.cacheTimeoutMilliSeconds;
    }

    public void setExpiryTime(int n) {
        this.cacheTimeoutMilliSeconds = n;
    }

    public int getCapacity() {
        return this.maxSize;
    }

    public void setCapacity(int n) {
        this.maxSize = n;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.entries.clear();
        this.size = 0;
    }

    public void clearEntry(String string) {
        this.entries.remove(string);
    }

    public void add(CacheEntry cacheEntry) {
        this.entries.put(cacheEntry.getKey(), cacheEntry);
    }

    public CacheEntry get(String string) {
        return this.entries.get(string);
    }

    private class CacheCheck
    implements ActionListener {
        private CacheCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Cache.this.entries.size() == 0) {
                return;
            }
            long l = System.currentTimeMillis();
            Iterator iterator = Cache.this.entries.entrySet().iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = (CacheEntry)iterator.next().getValue();
                if (cacheEntry.getExpiryTime() >= l) continue;
                iterator.remove();
            }
        }
    }
}

