/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.xml;

import de.schlichtherle.xml.GenericCertificateIntegrityException;
import de.schlichtherle.xml.GenericCertificateIsLockedException;
import de.schlichtherle.xml.GenericCertificateNotLockedException;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import de.schlichtherle.xml.XMLConstants;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.apache.commons.codec.binary.Base64;

public final class GenericCertificate
implements Serializable,
XMLConstants {
    private static final long serialVersionUID = 6247620498526484734L;
    private static final String BASE64_CHARSET = "US-ASCII";
    private static final String SIGNATURE_ENCODING = "US-ASCII/Base64";
    private volatile transient boolean locked;
    private String encoded;
    private String signature;
    private String signatureAlgorithm;
    private String signatureEncoding;
    private transient PropertyChangeSupport propertyChangeSupport;
    private transient VetoableChangeSupport vetoableChangeSupport;

    public GenericCertificate() {
    }

    public GenericCertificate(GenericCertificate genericCertificate) {
        try {
            this.setEncoded(genericCertificate.getEncoded());
            this.setSignature(genericCertificate.getSignature());
            this.setSignatureAlgorithm(genericCertificate.getSignatureAlgorithm());
            this.setSignatureEncoding(genericCertificate.getSignatureEncoding());
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new AssertionError((Object)propertyVetoException);
        }
    }

    public final synchronized void sign(Object object, PrivateKey privateKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, PersistenceServiceException, InvalidKeyException {
        if (null == privateKey || null == signature) {
            throw new NullPointerException();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = PersistenceService.store2ByteArray(object);
            signature.initSign(privateKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.encodeBase64(signature.sign());
            String string = new String(byArray2, 0, byArray2.length, BASE64_CHARSET);
            this.setEncoded(new String(byArray, "UTF-8"));
            this.setSignature(string);
            this.setSignatureAlgorithm(signature.getAlgorithm());
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        catch (SignatureException signatureException) {
            throw new AssertionError((Object)signatureException);
        }
        this.locked = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized void verify(PublicKey publicKey, Signature signature) throws NullPointerException, GenericCertificateIsLockedException, PropertyVetoException, InvalidKeyException, SignatureException, GenericCertificateIntegrityException {
        if (null == publicKey || null == signature) {
            throw new NullPointerException();
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "locked", this.isLocked(), Boolean.TRUE);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.fireVetoableChange(propertyChangeEvent);
        try {
            byte[] byArray = this.getEncoded().getBytes("UTF-8");
            signature.initVerify(publicKey);
            signature.update(byArray);
            byte[] byArray2 = Base64.decodeBase64(this.getSignature().getBytes(BASE64_CHARSET));
            if (!signature.verify(byArray2)) {
                throw new GenericCertificateIntegrityException();
            }
            this.setSignatureAlgorithm(signature.getAlgorithm());
            this.setSignatureEncoding(SIGNATURE_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        this.locked = true;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final boolean isLocked() {
        return this.locked;
    }

    public synchronized Object getContent() throws GenericCertificateNotLockedException, PersistenceServiceException {
        if (!this.isLocked()) {
            throw new GenericCertificateNotLockedException();
        }
        return PersistenceService.load(this.getEncoded());
    }

    public final synchronized String getEncoded() {
        return this.encoded;
    }

    public synchronized void setEncoded(String string) throws GenericCertificateIsLockedException {
        if (GenericCertificate.equals(string, this.encoded)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "encoded", this.getEncoded(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.encoded = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized String getSignature() {
        return this.signature;
    }

    public synchronized void setSignature(String string) throws GenericCertificateIsLockedException {
        if (GenericCertificate.equals(string, this.signature)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signature", this.getSignature(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.signature = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public synchronized void setSignatureAlgorithm(String string) throws GenericCertificateIsLockedException {
        if (GenericCertificate.equals(string, this.signatureAlgorithm)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureAlgorithm", this.getSignatureAlgorithm(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.signatureAlgorithm = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    public final synchronized String getSignatureEncoding() {
        return this.signatureEncoding;
    }

    public synchronized void setSignatureEncoding(String string) throws GenericCertificateIsLockedException {
        if (GenericCertificate.equals(string, this.signatureEncoding)) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "signatureEncoding", this.getSignatureEncoding(), string);
        if (this.isLocked()) {
            throw new GenericCertificateIsLockedException(propertyChangeEvent);
        }
        this.signatureEncoding = string;
        this.firePropertyChange(propertyChangeEvent);
    }

    private static boolean equals(Object object, Object object2) {
        return object == object2 || null != object && object.equals(object2);
    }

    public final synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public final synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    protected final synchronized void fireVetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(propertyChangeEvent);
    }

    public final synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public final synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected final synchronized void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.firePropertyChange(propertyChangeEvent);
    }
}

