/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrAnonymousInitializerSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrMessageLogger;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 %2\u00020\u0001:\u0003%&'B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0006H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0018H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0019H\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u001aH\u0002J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u001bH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u001cH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010\u000e\u001a\u00020\r*\u00020\u001c2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010H\u0002J\u0016\u0010\"\u001a\u00020#*\u00020$2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor;", "", "builtIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unlinkedClassifiers", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "messageLogger", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;", "(Lorg/jetbrains/kotlin/ir/IrBuiltIns;Ljava/util/Set;Lorg/jetbrains/kotlin/ir/util/IrMessageLogger;)V", "errorType", "Lorg/jetbrains/kotlin/ir/types/impl/IrErrorTypeImpl;", "addLinkageErrorIntoUnlinkedClasses", "", "reportWarning", "message", "", "location", "Lorg/jetbrains/kotlin/ir/util/IrMessageLogger$Location;", "signatureTransformer", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "usageTransformer", "isUnlinked", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "offset", "", "kind", "fqn", "throwLinkageError", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/ir/IrElement;", "Companion", "SignatureTransformer", "UsageTransformer", "ir.serialization.common"})
public final class UnlinkedDeclarationsProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns builtIns;
    @NotNull
    private final Set<IrClassifierSymbol> unlinkedClassifiers;
    @NotNull
    private final IrMessageLogger messageLogger;
    @NotNull
    private final IrErrorTypeImpl errorType;
    @NotNull
    private static final IrStatementOriginImpl errorOrigin = new IrStatementOriginImpl(){};

    public UnlinkedDeclarationsProcessor(@NotNull IrBuiltIns builtIns, @NotNull Set<? extends IrClassifierSymbol> unlinkedClassifiers, @NotNull IrMessageLogger messageLogger) {
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(unlinkedClassifiers, "unlinkedClassifiers");
        Intrinsics.checkNotNullParameter(messageLogger, "messageLogger");
        this.builtIns = builtIns;
        this.unlinkedClassifiers = unlinkedClassifiers;
        this.messageLogger = messageLogger;
        this.errorType = new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
    }

    /*
     * WARNING - void declaration
     */
    public final void addLinkageErrorIntoUnlinkedClasses() {
        for (IrClassifierSymbol u : this.unlinkedClassifiers) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            IrAnonymousInitializer irAnonymousInitializer;
            Object v0;
            IrDeclaration it;
            IrClass klass;
            block4: {
                if (!(u instanceof IrClassSymbol)) continue;
                klass = (IrClass)((IrClassSymbol)u).getOwner();
                Iterable $this$firstOrNull$iv = klass.getDeclarations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (IrDeclaration)element$iv;
                    boolean bl = false;
                    if (!(it instanceof IrAnonymousInitializer)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            if ((irAnonymousInitializer = (IrAnonymousInitializer)v0) == null) {
                Object element$iv;
                UnlinkedDeclarationsProcessor $this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u2d2 = this;
                boolean bl = false;
                element$iv = IrFactory.DefaultImpls.createAnonymousInitializer$default($this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u2d2.builtIns.getIrFactory(), klass.getStartOffset(), klass.getEndOffset(), IrDeclarationOrigin.DEFINED.INSTANCE, new IrAnonymousInitializerSymbolImpl(null, 1, null), false, 16, null);
                it = element$iv;
                boolean bl2 = false;
                ((IrAnonymousInitializer)it).setBody($this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u2d2.builtIns.getIrFactory().createBlockBody(klass.getStartOffset(), klass.getEndOffset()));
                it.setParent(klass);
                klass.getDeclarations().add(it);
                irAnonymousInitializer = element$iv;
            }
            IrAnonymousInitializer anonInitializer = irAnonymousInitializer;
            anonInitializer.getBody().getStatements().clear();
            IrDeclaration irDeclaration2 = klass;
            String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(klass).asString();
            Intrinsics.checkNotNullExpressionValue(string2, "klass.fqNameForIrSerialization.asString()");
            this.reportWarning(irDeclaration2, "Class", string2);
            IdSignature idSignature = klass.getSymbol().getSignature();
            anonInitializer.getBody().getStatements().add(this.throwLinkageError(klass, idSignature != null ? idSignature.render() : null));
            Iterable iterable = klass.getSuperTypes();
            IrClass irClass2 = klass;
            boolean $i$f$filter = false;
            void $this$addLinkageErrorIntoUnlinkedClasses_u24lambda_u2d2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrType it2 = (IrType)element$iv$iv;
                boolean bl = false;
                if (!(!this.isUnlinked(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irClass2.setSuperTypes((List)destination$iv$iv);
        }
    }

    private final IrMessageLogger.Location location(IrDeclaration $this$location) {
        IrFile irFile = IrUtilsKt.getFileOrNull($this$location);
        return irFile != null ? this.location(irFile, $this$location.getStartOffset()) : null;
    }

    private final IrMessageLogger.Location location(IrFile $this$location, int offset2) {
        Name module2 = $this$location.getModule().getName();
        IrFileEntry fileEntry = $this$location.getFileEntry();
        String fileName = fileEntry.getName();
        int lineNumber = fileEntry.getLineNumber(offset2) + 1;
        int columnNumber = fileEntry.getColumnNumber(offset2) + 1;
        return new IrMessageLogger.Location(module2 + " @ " + fileName, lineNumber, columnNumber);
    }

    private final void reportWarning(IrDeclaration $this$reportWarning, String kind, String fqn) {
        this.reportWarning(kind + " declaration " + fqn + " contains unlinked symbols", this.location($this$reportWarning));
    }

    private final void reportWarning(String message, IrMessageLogger.Location location) {
        this.messageLogger.report(IrMessageLogger.Severity.WARNING, message, location);
    }

    @NotNull
    public final IrElementTransformerVoid signatureTransformer() {
        return new SignatureTransformer();
    }

    private final boolean isUnlinked(IrSymbol $this$isUnlinked) {
        if (!$this$isUnlinked.isBound()) {
            return true;
        }
        IrSymbol irSymbol2 = $this$isUnlinked;
        if (irSymbol2 instanceof IrClassifierSymbol) {
            this.isUnlinked((IrClassifierSymbol)$this$isUnlinked);
        } else if (irSymbol2 instanceof IrPropertySymbol) {
            IrField irField;
            IrDeclarationBase it;
            IrSimpleFunction irSimpleFunction = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getGetter();
            if (irSimpleFunction != null) {
                it = irSimpleFunction;
                boolean bl = false;
                if (this.isUnlinked(((IrSimpleFunction)it).getSymbol())) {
                    return true;
                }
            }
            IrSimpleFunction irSimpleFunction2 = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getSetter();
            if (irSimpleFunction2 != null) {
                it = irSimpleFunction2;
                boolean bl = false;
                if (this.isUnlinked(((IrSimpleFunction)it).getSymbol())) {
                    return true;
                }
            }
            if ((irField = ((IrProperty)((IrPropertySymbol)$this$isUnlinked).getOwner()).getBackingField()) != null) {
                it = irField;
                boolean bl = false;
                return this.isUnlinked(((IrField)it).getSymbol());
            }
        } else if (irSymbol2 instanceof IrFunctionSymbol) {
            return this.isUnlinked((IrFunctionSymbol)$this$isUnlinked);
        }
        return false;
    }

    private final boolean isUnlinked(IrClassifierSymbol $this$isUnlinked) {
        return !$this$isUnlinked.isBound() || this.unlinkedClassifiers.contains($this$isUnlinked);
    }

    private final boolean isUnlinked(IrType $this$isUnlinked) {
        boolean bl;
        block5: {
            IrSimpleType irSimpleType = $this$isUnlinked instanceof IrSimpleType ? (IrSimpleType)$this$isUnlinked : null;
            if (irSimpleType == null) {
                return false;
            }
            IrSimpleType simpleType2 = irSimpleType;
            if (this.isUnlinked(simpleType2.getClassifier())) {
                return true;
            }
            Iterable $this$any$iv = simpleType2.getArguments();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof IrTypeProjection && this.isUnlinked(((IrTypeProjection)it).getType()))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isUnlinked(IrFieldSymbol $this$isUnlinked) {
        return ((IrField)$this$isUnlinked.getOwner()).getType() instanceof IrErrorType;
    }

    private final boolean isUnlinked(IrFunctionSymbol $this$isUnlinked) {
        boolean bl;
        block15: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            IrFunction function2;
            block13: {
                function2 = $this$isUnlinked.getOwner();
                if (function2.getReturnType() instanceof IrErrorType) {
                    return true;
                }
                IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
                if ((irValueParameter != null ? irValueParameter.getType() : null) instanceof IrErrorType) {
                    return true;
                }
                IrValueParameter irValueParameter2 = function2.getExtensionReceiverParameter();
                if ((irValueParameter2 != null ? irValueParameter2.getType() : null) instanceof IrErrorType) {
                    return true;
                }
                $this$any$iv = function2.getValueParameters();
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() instanceof IrErrorType)) continue;
                        bl2 = true;
                        break block13;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                return true;
            }
            $this$any$iv = function2.getTypeParameters();
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl4;
                    block14: {
                        IrTypeParameter tp = (IrTypeParameter)element$iv;
                        boolean bl5 = false;
                        Iterable $this$any$iv2 = tp.getSuperTypes();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                IrType st = (IrType)element$iv2;
                                boolean bl6 = false;
                                if (!(st instanceof IrErrorType)) continue;
                                bl4 = true;
                                break block14;
                            }
                            bl4 = false;
                        }
                    }
                    if (!bl4) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final IrCall throwLinkageError(IrElement $this$throwLinkageError, String message) {
        IrCallImpl irCallImpl;
        IrCallImpl call2 = irCallImpl = new IrCallImpl($this$throwLinkageError.getStartOffset(), $this$throwLinkageError.getEndOffset(), this.builtIns.getNothingType(), this.builtIns.getLinkageErrorSymbol(), 0, 1, errorOrigin, null, 128, null);
        boolean bl = false;
        StringBuilder stringBuilder2 = new StringBuilder().append("Linkage error of symbol: ");
        String string2 = message;
        if (string2 == null) {
            string2 = "";
        }
        String messageLiteral = stringBuilder2.append(string2).toString();
        call2.putValueArgument(0, IrConstImpl.Companion.string($this$throwLinkageError.getStartOffset(), $this$throwLinkageError.getEndOffset(), this.builtIns.getStringType(), messageLiteral));
        return irCallImpl;
    }

    @NotNull
    public final IrElementTransformerVoid usageTransformer() {
        return new UsageTransformer();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor$Companion;", "", "()V", "errorOrigin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "getErrorOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IrStatementOriginImpl getErrorOrigin() {
            return errorOrigin;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor$SignatureTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor;)V", "visitField", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "ir.serialization.common"})
    private final class SignatureTransformer
    extends IrElementTransformerVoid {
        @Override
        @NotNull
        public IrStatement visitFunction(@NotNull IrFunction declaration2) {
            block10: {
                Object object;
                block9: {
                    IrDeclarationBase it;
                    Iterable $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(declaration2, "declaration");
                    Ref.BooleanRef linked = new Ref.BooleanRef();
                    linked.element = true;
                    IrValueParameter irValueParameter = declaration2.getDispatchReceiverParameter();
                    if (irValueParameter != null) {
                        SignatureTransformer.visitFunction$fixType(irValueParameter, UnlinkedDeclarationsProcessor.this, linked);
                    }
                    IrValueParameter irValueParameter2 = declaration2.getExtensionReceiverParameter();
                    if (irValueParameter2 != null) {
                        SignatureTransformer.visitFunction$fixType(irValueParameter2, UnlinkedDeclarationsProcessor.this, linked);
                    }
                    Iterable iterable = declaration2.getValueParameters();
                    object = UnlinkedDeclarationsProcessor.this;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (IrValueParameter)element$iv;
                        boolean bl = false;
                        SignatureTransformer.visitFunction$fixType((IrValueParameter)it, (UnlinkedDeclarationsProcessor)object, linked);
                    }
                    if (UnlinkedDeclarationsProcessor.this.isUnlinked(declaration2.getReturnType())) {
                        linked.element = false;
                        declaration2.setReturnType(UnlinkedDeclarationsProcessor.this.errorType);
                    }
                    $this$forEach$iv = declaration2.getTypeParameters();
                    object = UnlinkedDeclarationsProcessor.this;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        boolean bl;
                        block8: {
                            it = (IrTypeParameter)element$iv;
                            boolean bl2 = false;
                            Iterable $this$any$iv = ((IrTypeParameter)it).getSuperTypes();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    IrType s = (IrType)element$iv2;
                                    boolean bl3 = false;
                                    if (!((UnlinkedDeclarationsProcessor)object).isUnlinked(s)) continue;
                                    bl = true;
                                    break block8;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        linked.element = false;
                        ((IrTypeParameter)it).setSuperTypes(CollectionsKt.listOf(((UnlinkedDeclarationsProcessor)object).errorType));
                    }
                    if (!linked.element) break block9;
                    this.transformChildrenVoid(declaration2);
                    break block10;
                }
                IrDeclaration irDeclaration2 = declaration2;
                String string2 = AdditionalIrUtilsKt.getFqNameForIrSerialization(declaration2).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "declaration.fqNameForIrSerialization.asString()");
                UnlinkedDeclarationsProcessor.this.reportWarning(irDeclaration2, "Function", string2);
                IrBody irBody = declaration2.getBody();
                if (irBody == null) break block10;
                object = irBody;
                UnlinkedDeclarationsProcessor unlinkedDeclarationsProcessor = UnlinkedDeclarationsProcessor.this;
                Object body2 = object;
                boolean bl = false;
                IrBlockBody bb = (IrBlockBody)body2;
                bb.getStatements().clear();
                bb.getStatements().add(unlinkedDeclarationsProcessor.throwLinkageError(declaration2, "Unlinked type in function signature"));
            }
            return declaration2;
        }

        @Override
        @NotNull
        public IrStatement visitField(@NotNull IrField declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(declaration2.getType())) {
                Object object = declaration2.getCorrespondingPropertySymbol();
                if (object == null || (object = (IrProperty)object.getOwner()) == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) == null) {
                    object = AdditionalIrUtilsKt.getFqNameForIrSerialization(declaration2);
                }
                Object fqn = object;
                String kind = declaration2.getCorrespondingPropertySymbol() != null ? "Property" : "Field";
                IrDeclaration irDeclaration2 = declaration2;
                String string2 = ((FqName)fqn).asString();
                Intrinsics.checkNotNullExpressionValue(string2, "fqn.asString()");
                UnlinkedDeclarationsProcessor.this.reportWarning(irDeclaration2, kind, string2);
                declaration2.setType(UnlinkedDeclarationsProcessor.this.errorType);
                declaration2.setInitializer(null);
            } else {
                this.transformChildrenVoid(declaration2);
            }
            return declaration2;
        }

        private static final void visitFunction$fixType(IrValueParameter $this$visitFunction_u24fixType, UnlinkedDeclarationsProcessor this$0, Ref.BooleanRef linked) {
            block2: {
                if (this$0.isUnlinked($this$visitFunction_u24fixType.getType())) {
                    linked.element = false;
                    $this$visitFunction_u24fixType.setType(this$0.errorType);
                    $this$visitFunction_u24fixType.setDefaultValue(null);
                }
                IrType irType = $this$visitFunction_u24fixType.getVarargElementType();
                if (irType == null) break block2;
                IrType it = irType;
                boolean bl = false;
                if (this$0.isUnlinked(it)) {
                    $this$visitFunction_u24fixType.setVarargElementType(this$0.errorType);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\u0014\u0010\u0011\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor$UsageTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/serialization/UnlinkedDeclarationsProcessor;)V", "currentFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitClass", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitClassReference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "visitExpression", "visitFieldAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "visitFile", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "ir.serialization.common"})
    private final class UsageTransformer
    extends IrElementTransformerVoid {
        @Nullable
        private IrFile currentFile;

        @Override
        @NotNull
        public IrFile visitFile(@NotNull IrFile declaration2) {
            IrFile irFile;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            this.currentFile = declaration2;
            IrFile it = irFile = super.visitFile(declaration2);
            boolean bl = false;
            this.currentFile = null;
            return irFile;
        }

        @Override
        @NotNull
        public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
            IrFile irFile;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.transformChildrenVoid(expression2);
            IrClassifierSymbol checkType2 = expression2.getTypeOperandClassifier();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(checkType2)) {
                return expression2;
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("TypeOperator contains unlinked symbol ");
            Object object = checkType2.getSignature();
            if (object == null || (object = ((IdSignature)object).render()) == null) {
                object = "";
            }
            UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder2.append((String)object).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression2.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), null, 8, null);
            composite.getStatements().add(expression2.getArgument());
            IdSignature idSignature = expression2.getTypeOperandClassifier().getSignature();
            composite.getStatements().add(UnlinkedDeclarationsProcessor.this.throwLinkageError(expression2, idSignature != null ? idSignature.render() : null));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitExpression(@NotNull IrExpression expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(expression2.getType()) || expression2.getType() instanceof IrErrorType) {
                IrFile irFile = this.currentFile;
                UnlinkedDeclarationsProcessor.this.reportWarning("Expression type contains unlinked symbol", irFile != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression2.getStartOffset()) : null);
                return UnlinkedDeclarationsProcessor.this.throwLinkageError(expression2, "Unlinked type of expression");
            }
            return super.visitExpression(expression2);
        }

        @Override
        @NotNull
        public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
            String string2;
            IrExpression it;
            IrFile irFile;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.transformChildrenVoid(expression2);
            Object symbol2 = expression2.getSymbol();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(symbol2) && !UnlinkedDeclarationsProcessor.this.isUnlinked(expression2.getType())) {
                return expression2;
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("Accessing declaration contains unlinked symbol ");
            Object object = symbol2.getSignature();
            if (object == null || (object = ((IdSignature)object).render()) == null) {
                object = "";
            }
            UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder2.append((String)object).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression2.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), expression2.getOrigin());
            IrExpression irExpression = expression2.getDispatchReceiver();
            if (irExpression != null) {
                it = irExpression;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            IrExpression irExpression2 = expression2.getExtensionReceiver();
            if (irExpression2 != null) {
                it = irExpression2;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            int n = expression2.getValueArgumentsCount();
            for (int i = 0; i < n; ++i) {
                IrExpression it2;
                IrExpression arg = expression2.getValueArgument(i);
                if (arg == null) continue;
                boolean bl = false;
                composite.getStatements().add(it2);
            }
            if (!symbol2.isBound()) {
                IdSignature idSignature = symbol2.getSignature();
                string2 = "Unlinked symbol: " + (idSignature != null ? idSignature.render() : null);
            } else {
                IdSignature idSignature = symbol2.getSignature();
                string2 = "Unlinked type in signature of " + (idSignature != null ? idSignature.render() : null);
            }
            String message = string2;
            composite.getStatements().add(UnlinkedDeclarationsProcessor.this.throwLinkageError(expression2, message));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
            String string2;
            IrFile irFile;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            this.transformChildrenVoid(expression2);
            IrFieldSymbol symbol2 = expression2.getSymbol();
            if (!UnlinkedDeclarationsProcessor.this.isUnlinked(symbol2)) {
                return expression2;
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("Accessing field contains unlinked symbol ");
            Object object = symbol2.getSignature();
            if (object == null || (object = ((IdSignature)object).render()) == null) {
                object = "";
            }
            UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder2.append((String)object).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression2.getStartOffset()) : null);
            IrCompositeImpl composite = new IrCompositeImpl(expression2.getStartOffset(), expression2.getEndOffset(), UnlinkedDeclarationsProcessor.this.builtIns.getNothingType(), expression2.getOrigin());
            IrExpression irExpression = expression2.getReceiver();
            if (irExpression != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                composite.getStatements().add(it);
            }
            if (expression2 instanceof IrSetField) {
                composite.getStatements().add(((IrSetField)expression2).getValue());
            }
            if (!symbol2.isBound()) {
                IdSignature idSignature = symbol2.getSignature();
                string2 = "Unlinked symbol: " + (idSignature != null ? idSignature.render() : null);
            } else {
                string2 = "Field type is unlinked";
            }
            String message = string2;
            composite.getStatements().add(UnlinkedDeclarationsProcessor.this.throwLinkageError(expression2, message));
            return composite;
        }

        @Override
        @NotNull
        public IrExpression visitClassReference(@NotNull IrClassReference expression2) {
            Intrinsics.checkNotNullParameter(expression2, "expression");
            if (UnlinkedDeclarationsProcessor.this.isUnlinked(expression2.getSymbol())) {
                IrFile irFile;
                IdSignature idSignature = expression2.getSymbol().getSignature();
                String signRender = idSignature != null ? idSignature.render() : null;
                StringBuilder stringBuilder2 = new StringBuilder().append("Accessing class contains unlinked symbol ");
                String string2 = signRender;
                if (string2 == null) {
                    string2 = "";
                }
                UnlinkedDeclarationsProcessor.this.reportWarning(stringBuilder2.append(string2).toString(), (irFile = this.currentFile) != null ? UnlinkedDeclarationsProcessor.this.location(irFile, expression2.getStartOffset()) : null);
                return UnlinkedDeclarationsProcessor.this.throwLinkageError(expression2, signRender);
            }
            return expression2;
        }

        @Override
        @NotNull
        public IrStatement visitClass(@NotNull IrClass declaration2) {
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            this.transformChildrenVoid(declaration2);
            for (IrDeclaration member2 : declaration2.getDeclarations()) {
                IrDeclaration irDeclaration2 = member2;
                if (irDeclaration2 instanceof IrSimpleFunction) {
                    UsageTransformer.visitClass$filterOverriddens((IrOverridableDeclaration)member2);
                    continue;
                }
                if (!(irDeclaration2 instanceof IrProperty)) continue;
                UsageTransformer.visitClass$filterOverriddens((IrOverridableDeclaration)member2);
                IrSimpleFunction irSimpleFunction = ((IrProperty)member2).getGetter();
                if (irSimpleFunction != null) {
                    UsageTransformer.visitClass$filterOverriddens(irSimpleFunction);
                }
                IrSimpleFunction irSimpleFunction2 = ((IrProperty)member2).getSetter();
                if (irSimpleFunction2 == null) continue;
                UsageTransformer.visitClass$filterOverriddens(irSimpleFunction2);
            }
            return declaration2;
        }

        /*
         * WARNING - void declaration
         */
        private static final <S extends IrSymbol> void visitClass$filterOverriddens(IrOverridableDeclaration<S> $this$visitClass_u24filterOverriddens) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = $this$visitClass_u24filterOverriddens.getOverriddenSymbols();
            IrOverridableDeclaration<S> irOverridableDeclaration = $this$visitClass_u24filterOverriddens;
            boolean $i$f$filter = false;
            void var3_4 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrSymbol it = (IrSymbol)element$iv$iv;
                boolean bl = false;
                if (!it.isBound()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            irOverridableDeclaration.setOverriddenSymbols((List)destination$iv$iv);
        }
    }
}

