/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Test;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.testCases.unity.TestCasesBaseApply;
import org.snpeff.util.Gpr;

public class TestCasesApplyMixed
extends TestCasesBaseApply {
    @Test
    public void test_apply_variant_01_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "TTTATC", "ACG");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 297, 396);
    }

    @Test
    public void test_apply_variant_01_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "TTT", "GCATTA");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 303, 402);
    }

    @Test
    public void test_apply_variant_02_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 294, "TCGTC", "CG");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 297, 396);
    }

    @Test
    public void test_apply_variant_02_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 294, "TCG", "AGGACG");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 303, 402);
    }

    @Test
    public void test_apply_variant_03_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 298, "CCTGTT", "ACG");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "Gtgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_03_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 298, "CCT", "ACGCAA");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "GCAAgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 402);
    }

    @Test
    public void test_apply_variant_04_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGTTTG", "ACG");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "ACGggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_04_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGT", "ACGAAC");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "ACGAACttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 402);
    }

    @Test
    public void test_apply_variant_05_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 310, "TTCACG", "ACT");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaaACTggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_05_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 310, "TTC", "ACTACG");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaaACTACGacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 402);
    }

    @Test
    public void test_apply_variant_06_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 394, "TCAACG", "GAC");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatccGAC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 396);
    }

    @Test
    public void test_apply_variant_06_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 397, "ACG", "GACAGT");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaGAC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_07_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 397, "ACGAAA", "TGC");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaTGC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_07_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 397, "ACG", "TGCATG");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaTGC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMixed(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_08_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 400, "AAAGGG", "CAT");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_08_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 400, "AAA", "CATTGC");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_09_shorter() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 410, "AGCGCT", "TCG");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_09_longer() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 410, "AGC", "TCGACT");
        this.checkApplyMixed(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }
}

