/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationMnp {
    static boolean debug;
    static boolean verbose;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-noHgvs", "-ud", "0", "testHg3766Chr1", "./tests/test.mnp.01.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff snpeff = (SnpEffCmdEff)cmd.cmd();
        snpeff.setVerbose(verbose);
        snpeff.setSupressOutput(!verbose);
        snpeff.setDebug(debug);
        List<VcfEntry> results = snpeff.run(true);
        Assert.assertEquals(1L, results.size());
        VcfEntry result2 = results.get(0);
        for (VcfEffect eff : result2.getVcfEffects()) {
            String aa = eff.getAa();
            String aaNumStr = aa.substring(1, aa.length() - 1);
            int aanum = Gpr.parseIntSafe(aaNumStr);
            if (verbose) {
                System.out.println("AA: '" + eff.getAa() + "'\tAA Num Str: '" + aaNumStr + "'\teff: " + eff);
            }
            if (aanum > 0) continue;
            throw new RuntimeException("Missing AA number!");
        }
    }

    static {
        verbose = debug = false;
    }
}

