/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationCodingTag {
    boolean verbose = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        String[] args = new String[]{"-classic", "-ud", "0", "-noOut", "testHg19Chr1", "./tests/missing_coding_tr_tag.vcf"};
        SnpEff cmd = new SnpEff(args);
        SnpEffCmdEff cmdEff = (SnpEffCmdEff)cmd.cmd();
        cmdEff.setVerbose(this.verbose);
        cmdEff.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = cmdEff.run(true);
        Assert.assertTrue("Errors while executing SnpEff", cmdEff.getTotalErrs() <= 0);
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve.getChromosomeName() + "\t" + ve.getStart() + "\t" + ve.getInfoStr());
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (veff.getImpact() != VariantEffect.EffectImpact.MODERATE) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                }
                Assert.assertFalse(veff.getBioType() == null || veff.getBioType() == null);
            }
        }
    }
}

