/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.ArrayList;
import java.util.List;
import org.snpeff.nextProt.NextProtParser;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.w3c.dom.Node;

public class NextProtParserV2
extends NextProtParser {
    protected String NODE_NAME_ANNOTATION_CATEGORY;
    protected String ATTR_NAME_POSITION;

    public NextProtParserV2(Config config) {
        super(config);
    }

    @Override
    protected void defineNextProtXmlTerms() {
        super.defineNextProtXmlTerms();
        this.NODE_NAME_PROTEIN = "entry";
        this.NODE_NAME_GENE = "genomic-mapping";
        this.NODE_NAME_TRANSCRIPT = "transcript-mapping";
        this.NODE_NAME_ANNOTATION_LIST = "annotation-list";
        this.NODE_NAME_ANNOTATION_CATEGORY = "annotation-category";
        this.NODE_NAME_POSITION = "location";
        this.NODE_NAME_CVNAME = "cv-term";
        this.NODE_NAME_SEQUENCE = "isoform-sequence";
        this.ATTR_NAME_UNIQUE_NAME = "accession";
        this.ATTR_NAME_DATABASE = "database";
        this.ATTR_NAME_ACCESSION = "accession";
        this.ATTR_NAME_FIRST = "begin";
        this.ATTR_NAME_LAST = "end";
        this.ATTR_NAME_POSITION = "position";
        this.ATTR_NAME_ISOFORM_REF = "accession";
        this.ATTR_VALUE_ENSEMBL = "Ensembl";
    }

    @Override
    protected int getAaEnd(Node posNode) {
        Node endNode = this.findOneNode(posNode, this.ATTR_NAME_LAST, null, null, null);
        String last2 = this.getAttribute(endNode, this.ATTR_NAME_POSITION);
        int aaEnd = Gpr.parseIntSafe(last2) - 1;
        return aaEnd;
    }

    @Override
    protected int getAaStart(Node posNode) {
        Node beginNode = this.findOneNode(posNode, this.ATTR_NAME_FIRST, null, null, null);
        String first = this.getAttribute(beginNode, this.ATTR_NAME_POSITION);
        int aaStart = Gpr.parseIntSafe(first) - 1;
        return aaStart;
    }

    @Override
    List<Node> getAnnotationCategories(Node node) {
        ArrayList<Node> annListNodes = this.findNodes(node, this.NODE_NAME_ANNOTATION_CATEGORY, null, null, null);
        return annListNodes;
    }

    @Override
    protected String getIsoformRefFromPos(Node posNode) {
        Node isoAnn = posNode.getParentNode();
        String isoformRef = this.getAttribute(isoAnn, this.ATTR_NAME_ISOFORM_REF);
        return isoformRef;
    }

    @Override
    String getUniqueNameSequence(Node seqNode) {
        String seqUniqName = this.getAttribute(seqNode, this.ATTR_NAME_UNIQUE_NAME);
        return seqUniqName;
    }

    @Override
    String getUniqueNameTranscript(Node trNode) {
        Node isoMap = trNode.getParentNode().getParentNode();
        String trUniqName = this.getAttribute(isoMap, this.ATTR_NAME_UNIQUE_NAME);
        return trUniqName;
    }
}

