/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.GeneSequence;
import org.biojava3.core.sequence.ProteinSequence;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.io.FastaGeneWriter;
import org.biojava3.core.sequence.io.FastaWriter;
import org.biojava3.core.sequence.io.GenericFastaHeaderFormat;
import org.biojava3.core.sequence.io.template.FastaHeaderFormatInterface;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.Sequence;

public class FastaWriterHelper {
    public static void writeProteinSequence(File file, Collection<ProteinSequence> proteinSequences) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        FastaWriterHelper.writeProteinSequence(bo, proteinSequences);
        bo.close();
        outputStream.close();
    }

    public static void writeProteinSequence(OutputStream outputStream, Collection<ProteinSequence> proteinSequences) throws Exception {
        FastaWriter fastaWriter = new FastaWriter(outputStream, proteinSequences, new GenericFastaHeaderFormat());
        fastaWriter.process();
    }

    public static void writeGeneSequence(File file, Collection<GeneSequence> geneSequences, boolean showExonUppercase) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        FastaWriterHelper.writeGeneSequence(bo, geneSequences, showExonUppercase);
        bo.close();
        outputStream.close();
    }

    public static void writeGeneSequence(OutputStream outputStream, Collection<GeneSequence> geneSequences, boolean showExonUppercase) throws Exception {
        FastaGeneWriter fastaWriter = new FastaGeneWriter(outputStream, geneSequences, new GenericFastaHeaderFormat<GeneSequence, NucleotideCompound>(), showExonUppercase);
        fastaWriter.process();
    }

    public static void writeNucleotideSequence(File file, Collection<DNASequence> dnaSequences) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        FastaWriterHelper.writeNucleotideSequence(bo, dnaSequences);
        bo.close();
        outputStream.close();
    }

    public static void writeNucleotideSequence(OutputStream outputStream, Collection<DNASequence> dnaSequences) throws Exception {
        FastaWriter fastaWriter = new FastaWriter(outputStream, dnaSequences, new GenericFastaHeaderFormat());
        fastaWriter.process();
    }

    public static void writeSequence(File file, Sequence<?> sequence2) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(file);
        BufferedOutputStream bo = new BufferedOutputStream(outputStream);
        FastaWriterHelper.writeSequences(bo, FastaWriterHelper.singleSeqToCollection(sequence2));
        bo.close();
        outputStream.close();
    }

    public static void writeSequence(OutputStream outputStream, Sequence<?> sequence2) throws Exception {
        FastaWriterHelper.writeSequences(outputStream, FastaWriterHelper.singleSeqToCollection(sequence2));
    }

    private static Collection<Sequence<?>> singleSeqToCollection(Sequence<?> sequence2) {
        ArrayList sequences = new ArrayList();
        sequences.add(sequence2);
        return sequences;
    }

    public static void writeSequences(OutputStream outputStream, Collection<Sequence<?>> sequences) throws Exception {
        FastaHeaderFormatInterface fhfi = new FastaHeaderFormatInterface<Sequence<?>, Compound>(){

            @Override
            public String getHeader(Sequence<?> sequence2) {
                return sequence2.getAccession().toString();
            }
        };
        FastaWriter fastaWriter = new FastaWriter(outputStream, sequences, fhfi);
        fastaWriter.process();
    }
}

