/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.optim.univariate;

import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.optim.ConvergenceChecker;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.univariate.UnivariateOptimizer;
import org.apache.commons.math3.optim.univariate.UnivariatePointValuePair;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrentOptimizer
extends UnivariateOptimizer {
    private static final double GOLDEN_SECTION = 0.5 * (3.0 - FastMath.sqrt(5.0));
    private static final double MIN_RELATIVE_TOLERANCE = 2.0 * FastMath.ulp(1.0);
    private final double relativeThreshold;
    private final double absoluteThreshold;

    public BrentOptimizer(double rel, double abs, ConvergenceChecker<UnivariatePointValuePair> checker) {
        super(checker);
        if (rel < MIN_RELATIVE_TOLERANCE) {
            throw new NumberIsTooSmallException(rel, (Number)MIN_RELATIVE_TOLERANCE, true);
        }
        if (abs <= 0.0) {
            throw new NotStrictlyPositiveException(abs);
        }
        this.relativeThreshold = rel;
        this.absoluteThreshold = abs;
    }

    public BrentOptimizer(double rel, double abs) {
        this(rel, abs, null);
    }

    @Override
    protected UnivariatePointValuePair doOptimize() {
        UnivariatePointValuePair current;
        double x2;
        double b;
        double a;
        boolean isMinim = this.getGoalType() == GoalType.MINIMIZE;
        double lo = this.getMin();
        double mid = this.getStartValue();
        double hi = this.getMax();
        ConvergenceChecker<UnivariatePointValuePair> checker = this.getConvergenceChecker();
        if (lo < hi) {
            a = lo;
            b = hi;
        } else {
            a = hi;
            b = lo;
        }
        double v = x2 = mid;
        double w = x2;
        double d = 0.0;
        double e = 0.0;
        double fx = this.computeObjectiveValue(x2);
        if (!isMinim) {
            fx = -fx;
        }
        double fv = fx;
        double fw = fx;
        UnivariatePointValuePair previous = null;
        UnivariatePointValuePair best = current = new UnivariatePointValuePair(x2, isMinim ? fx : -fx);
        int iter2 = 0;
        while (true) {
            boolean stop2;
            double m = 0.5 * (a + b);
            double tol1 = this.relativeThreshold * FastMath.abs(x2) + this.absoluteThreshold;
            double tol2 = 2.0 * tol1;
            boolean bl = stop2 = FastMath.abs(x2 - m) <= tol2 - 0.5 * (b - a);
            if (!stop2) {
                double p = 0.0;
                double q = 0.0;
                double r = 0.0;
                double u = 0.0;
                if (FastMath.abs(e) > tol1) {
                    r = (x2 - w) * (fx - fv);
                    q = (x2 - v) * (fx - fw);
                    p = (x2 - v) * q - (x2 - w) * r;
                    if ((q = 2.0 * (q - r)) > 0.0) {
                        p = -p;
                    } else {
                        q = -q;
                    }
                    r = e;
                    e = d;
                    if (p > q * (a - x2) && p < q * (b - x2) && FastMath.abs(p) < FastMath.abs(0.5 * q * r)) {
                        d = p / q;
                        u = x2 + d;
                        if (u - a < tol2 || b - u < tol2) {
                            d = x2 <= m ? tol1 : -tol1;
                        }
                    } else {
                        e = x2 < m ? b - x2 : a - x2;
                        d = GOLDEN_SECTION * e;
                    }
                } else {
                    e = x2 < m ? b - x2 : a - x2;
                    d = GOLDEN_SECTION * e;
                }
                u = FastMath.abs(d) < tol1 ? (d >= 0.0 ? x2 + tol1 : x2 - tol1) : x2 + d;
                double fu = this.computeObjectiveValue(u);
                if (!isMinim) {
                    fu = -fu;
                }
                previous = current;
                current = new UnivariatePointValuePair(u, isMinim ? fu : -fu);
                best = this.best(best, this.best(previous, current, isMinim), isMinim);
                if (checker != null && checker.converged(iter2, previous, current)) {
                    return best;
                }
                if (fu <= fx) {
                    if (u < x2) {
                        b = x2;
                    } else {
                        a = x2;
                    }
                    v = w;
                    fv = fw;
                    w = x2;
                    fw = fx;
                    x2 = u;
                    fx = fu;
                } else {
                    if (u < x2) {
                        a = u;
                    } else {
                        b = u;
                    }
                    if (fu <= fw || Precision.equals(w, x2)) {
                        v = w;
                        fv = fw;
                        w = u;
                        fw = fu;
                    } else if (fu <= fv || Precision.equals(v, x2) || Precision.equals(v, w)) {
                        v = u;
                        fv = fu;
                    }
                }
            } else {
                return this.best(best, this.best(previous, current, isMinim), isMinim);
            }
            ++iter2;
        }
    }

    private UnivariatePointValuePair best(UnivariatePointValuePair a, UnivariatePointValuePair b, boolean isMinim) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (isMinim) {
            return a.getValue() <= b.getValue() ? a : b;
        }
        return a.getValue() >= b.getValue() ? a : b;
    }
}

