/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.charts4j;

import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.collect.Preconditions;

public class Slice {
    private final int percent;
    private final String label;
    private final String legend;
    private final Color color;

    Slice(int percent2, Color color, String sliceLabel, String sliceLegend) {
        this.percent = percent2;
        this.color = color;
        this.label = sliceLabel;
        this.legend = sliceLegend;
    }

    public final int getPercentage() {
        return this.percent;
    }

    public final Color getColor() {
        return this.color;
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getLegend() {
        return this.legend;
    }

    public static Slice newSlice(int percent2, Color color, String sliceLabel) {
        return Slice.newSlice(percent2, color, sliceLabel, null);
    }

    public static Slice newSlice(int percent2, Color color, String sliceLabel, String sliceLegend) {
        Preconditions.checkArgument(percent2 >= 0, "value must be between >= 0: %s", percent2);
        return new Slice(percent2, color, sliceLabel, sliceLegend);
    }

    @Deprecated
    public static Slice newSlice(int percent2, Color color) {
        return Slice.newSlice(percent2, color, null, null);
    }

    public static Slice newSlice(int percent2, String sliceLabel) {
        return Slice.newSlice(percent2, null, sliceLabel, null);
    }
}

