/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.fileIterator;

import java.util.HashMap;
import java.util.Map;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.fileIterator.DbNsfp;

public class DbNsfpEntry
extends Variant {
    private static final long serialVersionUID = -3275792763917755927L;
    DbNsfp dbNsfp;
    Map<String, String> values;

    public static String[] splitValuesField(String value2) {
        if (value2.indexOf(",") >= 0) {
            return value2.split(",");
        }
        return value2.split(";");
    }

    public DbNsfpEntry(DbNsfp dbNsfp, String line) {
        this.dbNsfp = dbNsfp;
        this.parse(line);
    }

    public void add(String columnName, String valuesToAdd) {
        if (valuesToAdd.isEmpty()) {
            valuesToAdd = ".";
        } else if (valuesToAdd.indexOf(59) >= 0) {
            valuesToAdd = valuesToAdd.replace(';', '\t');
        } else if (valuesToAdd.indexOf(44) >= 0) {
            valuesToAdd = valuesToAdd.replace(',', '\t');
        }
        this.values.put(columnName, valuesToAdd);
    }

    @Override
    public DbNsfpEntry cloneShallow() {
        DbNsfpEntry clone2 = (DbNsfpEntry)super.cloneShallow();
        return clone2;
    }

    public String getVcfInfo(String key) {
        String val = this.values.get(key);
        if (val == null) {
            return null;
        }
        if (val.indexOf(9) < 0) {
            return VcfEntry.vcfInfoValueSafe(val);
        }
        String[] vals = val.split("\t");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(VcfEntry.vcfInfoValueSafe(vals[i]));
        }
        return sb.toString();
    }

    public boolean hasValues(String allele) {
        return this.values.containsKey(allele);
    }

    protected void parse(String line) {
        String[] vals = line.split("\t", -1);
        String chromosome = vals[this.dbNsfp.getChromosomeIdx()];
        this.parent = this.dbNsfp.getChromosome(chromosome);
        this.end = this.start = this.parsePosition(vals[this.dbNsfp.getStartIdx()]);
        this.variantType = Variant.VariantType.SNP;
        this.ref = vals[this.dbNsfp.getRefIdx()];
        this.genotype = this.alt = vals[this.dbNsfp.getAltIdx()];
        this.values = new HashMap<String, String>();
        for (int i = 0; i < this.dbNsfp.getFieldCount(); ++i) {
            this.add(this.dbNsfp.getFieldName(i), vals[i]);
        }
    }

    public int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStr() + "\t");
        sb.append('\n');
        for (String key : this.values.keySet()) {
            sb.append("\t" + key + ": '" + this.values.get(key) + "'\n");
        }
        return sb.toString();
    }
}

