/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.annotate;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.tabix.TabixIterator;
import net.sf.samtools.tabix.TabixReader;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VariantVcfEntry;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.annotate.DbVcf;

public class DbVcfTabix
extends DbVcf {
    protected TabixReader tabixReader;
    protected VcfFileIterator vcf;

    public DbVcfTabix(String dbFileName) {
        super(dbFileName);
    }

    @Override
    public void close() {
        if (this.tabixReader != null) {
            this.tabixReader.close();
        }
        this.tabixReader = null;
        if (this.vcf != null) {
            this.vcf.close();
        }
        this.vcf = null;
        this.vcfHeader = null;
    }

    protected boolean initTabix(String fileName) {
        try {
            String indexFile = fileName + ".tbi";
            if (!Gpr.exists(indexFile)) {
                throw new RuntimeException("Cannot find tabix index file '" + indexFile + "'");
            }
            this.tabixReader = new TabixReader(fileName);
            this.tabixReader.setShowHeader(false);
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening tabix file '" + fileName + "'", e);
        }
        return true;
    }

    @Override
    public void open() {
        this.vcf = new VcfFileIterator(this.dbFileName);
        this.vcfHeader = this.vcf.readHeader();
        this.initTabix(this.dbFileName);
    }

    @Override
    public List<VariantVcfEntry> query(Variant variant) {
        LinkedList<VariantVcfEntry> results = new LinkedList<VariantVcfEntry>();
        TabixIterator ti = this.tabixReader.query(variant);
        if (ti != null) {
            for (String line : ti) {
                line = Gpr.removeBackslashR(line);
                VcfEntry ve = this.vcf.parseVcfLine(line);
                results.addAll(VariantVcfEntry.factory(ve));
            }
        }
        return results;
    }
}

