/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.svg;

import org.snpeff.interval.Intron;
import org.snpeff.svg.Svg;
import scala.collection.mutable.StringBuilder;

public class SvgIntron
extends Svg {
    public static final int SIGN_WIDTH = 5;
    Intron intron;

    public SvgIntron(Intron intron, Svg svg) {
        super(intron, svg);
        this.intron = intron;
        this.baseY = (int)((double)svg.baseY + 5.0);
        this.rectHeight = 10;
    }

    String strand() {
        StringBuilder sb = new StringBuilder();
        int start = (int)this.start() + 5;
        int end = (int)this.end() - 5;
        for (int i = start; i < end; i += 10) {
            sb.append(this.strand(i));
        }
        return sb.toString();
    }

    String strand(int pos) {
        double h = this.rectHeight;
        double y1 = this.baseY;
        double y2 = (double)this.baseY + h / 2.0;
        double y3 = (double)this.baseY + h;
        if (this.intron.getParent().isStrandPlus()) {
            return this.line(pos, y1, pos + 5, y2) + this.line(pos + 5, y2, pos, y3);
        }
        return this.line(pos + 5, y1, pos, y2) + this.line(pos, y2, pos + 5, y3);
    }

    @Override
    public String toString() {
        return this.strand();
    }
}

