/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.stats.plot;

import com.googlecode.charts4j.AxisLabelsFactory;
import com.googlecode.charts4j.BarChart;
import com.googlecode.charts4j.BarChartPlot;
import com.googlecode.charts4j.Color;
import com.googlecode.charts4j.Data;
import com.googlecode.charts4j.GCharts;
import com.googlecode.charts4j.Plots;
import java.util.ArrayList;

public class GoogleGenePercentBar {
    static final int len = 11;
    int plotSizeY = 300;
    int plotSizeX = 800;
    ArrayList<String> labelList;
    String title = "";
    String xAxisLabel = "";
    String yAxisLabel = "";
    Data dinter;
    Data dup;
    Data dutr5;
    Data dexon;
    Data dssDonor;
    Data dintron;
    Data dssAcceptor;
    Data dutr3;
    Data ddown;
    double maxY = Double.MIN_VALUE;

    public GoogleGenePercentBar(String title, String xAxisLabel, String yAxisLabel, double intergenic, double upstream, double utr5, double exon, double spliceSiteDonor, double intron, double spliceSiteAcceptor, double utr3, double downstream) {
        this.title = title;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.maxY = Math.max(intergenic, Math.max(upstream, Math.max(utr5, Math.max(exon, Math.max(intron, Math.max(utr3, Math.max(downstream, Math.max(spliceSiteAcceptor, spliceSiteDonor))))))));
        this.dinter = this.data(intergenic, 0, 10, 11);
        this.dup = this.data(upstream, 1, -1, 11);
        this.dutr5 = this.data(utr5, 2, -1, 11);
        this.dexon = this.data(exon, 3, 7, 11);
        this.dssDonor = this.data(spliceSiteDonor, 4, -1, 11);
        this.dintron = this.data(intron, 5, -1, 11);
        this.dssAcceptor = this.data(spliceSiteAcceptor, 6, -1, 11);
        this.dutr3 = this.data(utr3, 8, -1, 11);
        this.ddown = this.data(downstream, 9, -1, 11);
        this.labelList = new ArrayList();
        this.labelList.add("Intergenic");
        this.labelList.add("Up");
        this.labelList.add("5'UTR");
        this.labelList.add("Exon");
        this.labelList.add("Donor");
        this.labelList.add("Intron");
        this.labelList.add("Acceptor");
        this.labelList.add("Exon");
        this.labelList.add("3'UTR");
        this.labelList.add("Down");
        this.labelList.add("Intergenic");
    }

    Data data(double value2, int position, int position2, int len) {
        double scaledVal = 100.0 * value2 / this.maxY;
        ArrayList<Double> data2 = new ArrayList<Double>();
        for (int i = 0; i < len; ++i) {
            if (i == position || i == position2) {
                data2.add(scaledVal);
                continue;
            }
            data2.add(0.0);
        }
        return Data.newData(data2);
    }

    void decorate(BarChart chart) {
        chart.setTitle(this.title);
        chart.setSize(this.plotSizeX, this.plotSizeY);
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels(this.labelList));
        chart.addYAxisLabels(AxisLabelsFactory.newNumericRangeAxisLabels(0.0, this.maxY));
        chart.addXAxisLabels(AxisLabelsFactory.newAxisLabels(this.xAxisLabel, 50.0));
        chart.addYAxisLabels(AxisLabelsFactory.newAxisLabels(this.yAxisLabel, 50.0));
        chart.setDataStacked(true);
        chart.setBarWidth(50);
    }

    public String toURLString() {
        BarChartPlot plotInter = Plots.newBarChartPlot(this.dinter, Color.GRAY, "Intergenic");
        BarChartPlot plottUp = Plots.newBarChartPlot(this.dup, Color.AQUA, "Upstream");
        BarChartPlot plotUtr5 = Plots.newBarChartPlot(this.dutr5, Color.SALMON, "5'UTR");
        BarChartPlot plotExon = Plots.newBarChartPlot(this.dexon, Color.RED, "Exon");
        BarChartPlot plotSsDonor = Plots.newBarChartPlot(this.dssDonor, Color.BROWN, "Splice Donor");
        BarChartPlot plotIntron = Plots.newBarChartPlot(this.dintron, Color.ORANGE, "Intron");
        BarChartPlot plotSsAcceptor = Plots.newBarChartPlot(this.dssAcceptor, Color.BURLYWOOD, "Splice Acceptor");
        BarChartPlot plotUtr3 = Plots.newBarChartPlot(this.dutr3, Color.DARKSALMON, "3'UTR");
        BarChartPlot plotDown = Plots.newBarChartPlot(this.ddown, Color.AQUAMARINE, "Downstream");
        BarChart barChart = GCharts.newBarChart(plottUp, plotUtr5, plotExon, plotSsDonor, plotIntron, plotSsAcceptor, plotUtr3, plotDown, plotInter);
        this.decorate(barChart);
        return barChart.toURLString();
    }
}

