/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import org.junit.Test;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.testCases.unity.TestCasesBaseApply;
import org.snpeff.util.Gpr;

public class TestCasesApplyMnp
extends TestCasesBaseApply {
    @Test
    public void test_apply_variant_01() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "TTT", "AAA");
        this.checkApplyMnp(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_02() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 297, "TCC", "ACG");
        this.checkApplyMnp(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_03() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 299, "CTG", "GAC");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "ACtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_04() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGT", "ACA");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "ACAttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_05() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 310, "TTC", "AAG");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaaAAGacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_06() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 397, "ACG", "TGC");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaTGC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_07() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 398, "CGA", "GCT");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaaGC".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_08() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 400, "AAA", "TTT");
        this.checkApplyMnp(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_09() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 410, "AGC", "TCG");
        this.checkApplyMnp(variant, this.transcript.cds(), this.transcript.protein(), 1, 300, 399);
    }

    @Test
    public void test_apply_variant_10() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 290, "tttatcgtcctgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacgaaagggagct", "ATTGGCTCGACGCTCATTCACTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "CGCTCATTCACTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAG".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_11() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "TGTTTGGGAATTCACGGGCACGGTTCTGCAGCAAGCTGAATTGGCAGCTCGGCATAAATCCCGACCCCATCGTCACGCACGGATCAATTCATCCTCAACGAAAGGGAGCTAGCGCTGTAC", "ATTGGCTCGACGCTCATTCACTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT");
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "ATTGGCTCGACGCTCATTCACTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATG".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_12() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 280, "aaccgctaactttatcgtcctgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toUpperCase(), "attggctcgacgctcattcaCTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT".toUpperCase());
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "CTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }

    @Test
    public void test_apply_variant_13() {
        Gpr.debug("Test");
        Variant variant = new Variant(this.transcript.getParent(), 300, "tgtttgggaattcacgggcacggttctgcagcaagctgaattggcagctcggcataaatcccgaccccatcgtcacgcacggatcaattcatcctcaacg".toUpperCase(), "CTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT".toUpperCase());
        String expectedCds = "atgtccgcaggtgaaggcatacacgctgcgcgtatactgatgttacctcgatggattttgtcagaaatatggtgcccaggacgcgaagggcatattatgg" + "CTCCAACAGCCCGGGACCCCCGCTCAATTATTTCACTCACCGGGAAAATTGTACCGATTGTCCGTGCCTTACTTCAAATGACATCCGCAGGTGAAGGCAT".toLowerCase() + "ggtagaggaaaagcacctaacccccattgagcaggatctctttcgtaatactctgtatcgattaccgatttatttgattccccacatttatttcatcggg";
        this.checkApplyMnp(variant, expectedCds, null, 1, 300, 399);
    }
}

