/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.SnpEff;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.commandLine.SnpEffCmdEff;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationVcfs {
    boolean verbose = false;
    boolean debug = false;
    boolean createOutputFile = false;

    public static void create1kgFile() throws IOException {
        String vcfFile = Gpr.HOME + "/snpEff/1kg.indels.vcf";
        String vcfOutFile = Gpr.HOME + "/workspace/SnpEff/tests/1kg.indels.vcf";
        StringBuilder outvcf = new StringBuilder();
        VcfFileIterator vcf = new VcfFileIterator(vcfFile);
        for (VcfEntry ve : vcf) {
            StringBuilder sb = new StringBuilder();
            for (Variant sc : ve.variants()) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(sc.getReference() + "/" + sc.getAlt());
            }
            ve.addInfo("variant", sb.toString());
            outvcf.append(ve + "\n");
        }
        Gpr.toFile(vcfOutFile, outvcf);
    }

    @Test
    public void test_01_vcf_bed_filter() {
        Gpr.debug("Test");
        String vcfFile = "tests/test_vcf_filter.vcf";
        String bedFile = "tests/test_vcf_filter.bed";
        String[] args = new String[]{"-classic", "-filterinterval", bedFile, "testHg3771Chr1", vcfFile};
        SnpEff snpeff = new SnpEff(args);
        SnpEffCmdEff effcmd = (SnpEffCmdEff)snpeff.cmd();
        effcmd.setVerbose(this.verbose);
        effcmd.setSupressOutput(!this.verbose);
        List<VcfEntry> vcfEntries = effcmd.run(true);
        Gpr.debug("Vcf entries: " + vcfEntries.size());
        Assert.assertEquals(0, vcfEntries.size());
        for (VcfEntry ve : vcfEntries) {
            System.out.println(ve);
        }
    }

    @Test
    public void test_02_Annotating_LOF_Spaces() {
        String vcfFileName = "tests/vcf_genes_spaces.vcf";
        String genomeName = "test_ENSG00000158062_spaces";
        String[] args = new String[]{"-noLog", genomeName, vcfFileName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setVerbose(this.verbose);
        snpEff.setDebug(this.debug);
        boolean ok = snpEff.run();
        Assert.assertTrue("SnpEff run failed!", ok);
    }

    @Test
    public void test_03_do_not_annotate_non_variants() {
        String vcfFileName = "tests/test_non_variants.vcf";
        String genomeName = "testHg3775Chr1";
        String[] args = new String[]{"-noLog", genomeName, vcfFileName};
        SnpEff snpEff = new SnpEff(args);
        snpEff.setSupressOutput(!this.verbose);
        snpEff.setVerbose(this.verbose);
        snpEff.setDebug(this.debug);
        SnpEffCmdEff seff = (SnpEffCmdEff)snpEff.cmd();
        List<VcfEntry> vcfEntries = seff.run(true);
        Assert.assertFalse("SnpEff run failed, returned an empty list", vcfEntries.isEmpty());
        for (VcfEntry ve : vcfEntries) {
            if (this.verbose) {
                System.out.println(ve);
            }
            if (!ve.hasInfo("ANN") && !ve.hasInfo("EFF")) continue;
            throw new RuntimeException("Effect field should not be annotated on non-variant entries!\n" + ve);
        }
    }
}

