/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.integration;

import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.snpEffect.testCases.integration.TestCasesIntegrationBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationHgvsUpDownStream
extends TestCasesIntegrationBase {
    public TestCasesIntegrationHgvsUpDownStream() {
        this.testsDir = "tests/integration/hgvs_up_down_stream/";
    }

    @Test
    public void test_01_hgvs_upstream() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr2", this.testsDir + "hgvs_upstream.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!veff.getTranscriptId().equals("NM_000463.2")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_02_hgvs_downstream() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr2", this.testsDir + "hgvs_downstream.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!veff.getTranscriptId().equals("NM_000463.2")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_03_hgvs_upstream_del() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg3765Chr22", this.testsDir + "hgvs_upstream_del.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!veff.getTranscriptId().equals("ENST00000404751")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_04_hgvs_upstream_negative_strand() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr17", this.testsDir + "hgvs_upstream_negative_strand.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!veff.getTranscriptId().equals("NM_000199.3")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }

    @Test
    public void test_05_hgvs_downstream_negative_strand() {
        Gpr.debug("Test");
        List<VcfEntry> list2 = this.snpEffect("testHg19Chr17", this.testsDir + "hgvs_downstream_negative_strand.vcf", null);
        for (VcfEntry ve : list2) {
            if (this.verbose) {
                System.out.println(ve);
            }
            for (VcfEffect veff : ve.getVcfEffects()) {
                if (!veff.getTranscriptId().equals("NM_000199.3")) continue;
                if (this.verbose) {
                    System.out.println("\t" + veff);
                    System.out.println("\t\tHGVS.c: " + veff.getHgvsC());
                }
                String expectedHgvsC = ve.getInfo("HGVSC");
                String actualHgvsC = veff.getHgvsC();
                Assert.assertEquals(expectedHgvsC, actualHgvsC);
            }
        }
    }
}

