/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.reactome;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.gtex.Gtex;
import org.snpeff.gtex.GtexExperiment;
import org.snpeff.reactome.Compartment;
import org.snpeff.reactome.Entity;
import org.snpeff.reactome.GeneIds;
import org.snpeff.reactome.Monitor;
import org.snpeff.reactome.events.BlackBoxEvent;
import org.snpeff.reactome.events.CatalystActivity;
import org.snpeff.reactome.events.Complex;
import org.snpeff.reactome.events.Depolymerisation;
import org.snpeff.reactome.events.Event;
import org.snpeff.reactome.events.Pathway;
import org.snpeff.reactome.events.Polymerisation;
import org.snpeff.reactome.events.Reaction;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class Reactome
implements Iterable<Entity> {
    public static final int SHOW_EVERY = 10000;
    public static final double EPSILON = 1.0E-6;
    public static final double MAX_CONVERGENCE_DIFFERENCE = 0.001;
    public static final int MAX_ITERATIONS = 1000;
    boolean verbose = false;
    String dirName;
    HashMap<String, Entity> entityById;
    HashMap<String, String> objectType;
    HashMap<String, String> objectName;
    AutoHashMap<String, ArrayList<Entity>> entitiesByGeneId;
    HashSet<String> entitiesGeneId = new HashSet();
    Monitor monitor;
    Monitor monitorTrace;

    static String findRegexp(Pattern pattern, String str) {
        Matcher m = pattern.matcher(str);
        if (!m.find()) {
            return null;
        }
        return m.group();
    }

    static boolean hasRegexp(Pattern pattern, String str) {
        Matcher m = pattern.matcher(str);
        return m.find();
    }

    public static void main(String[] args) {
        String reactomeDir = Gpr.HOME + "/snpEff/db/reactome/txt/";
        String geneIdsFile = Gpr.HOME + "/snpEff/db/reactome/gene_ids/biomart_query_uniq.txt";
        String gtexDir = Gpr.HOME + "/snpEff/db/GTEx";
        String gtexSamples = gtexDir + "/GTEx_Analysis_Annotations_Sample_DS__Pilot_2013_01_31.txt";
        String gtexData = gtexDir + "/gtex_norm.10.txt";
        Timer.showStdErr("Loading reactome data");
        Reactome reactome = new Reactome();
        reactome.setVerbose(true);
        reactome.load(reactomeDir, geneIdsFile);
        Timer.showStdErr("Loading GTEx data");
        Gtex gtex = new Gtex();
        gtex.setVerbose(true);
        gtex.load(gtexSamples, gtexData);
        reactome.simplifyEntities();
        Timer.showStdErr("Running");
        reactome.run(gtex, null);
        String file = Gpr.HOME + "/circuit.txt";
        Timer.showStdErr("Saving results to '" + file + "'");
        if (reactome.monitor != null) {
            reactome.monitor.save(file);
        }
        if (reactome.monitorTrace != null) {
            reactome.monitorTrace.save(file);
        }
    }

    public Reactome() {
        this.entityById = new HashMap();
        this.entitiesByGeneId = new AutoHashMap(new ArrayList());
    }

    public void add(Entity entity, String geneId) {
        String key = geneId + "\t" + entity.getId();
        if (this.entitiesGeneId.contains(key)) {
            return;
        }
        entity.addGeneId(geneId);
        this.entitiesByGeneId.getOrCreate(geneId).add(entity);
        this.entitiesGeneId.add(key);
    }

    boolean calc(GtexExperiment gtexExperiment) {
        int iteration;
        boolean changed = true;
        if (this.verbose) {
            System.err.print(gtexExperiment.getTissueTypeDetail() + "\t");
        }
        for (iteration = 0; changed && iteration < 1000; ++iteration) {
            changed = false;
            HashSet<Entity> done = new HashSet<Entity>();
            for (Entity e : this) {
                double out;
                double outPrev = e.getOutput();
                if (!(Math.abs(outPrev - (out = e.calc(done))) > 0.001)) continue;
                changed = true;
            }
            if (!this.verbose) continue;
            System.err.print(".");
        }
        if (this.verbose) {
            System.err.println(" " + iteration);
        }
        return changed;
    }

    Monitor createMonitor() {
        Monitor monitor = new Monitor();
        for (Entity e : this) {
            if (e.isFixed() || !e.isReaction()) continue;
            monitor.add(e);
        }
        monitor.sort();
        return monitor;
    }

    Monitor createMonitor(String targetNodeId) {
        this.reset();
        Entity target = this.entityById.get(targetNodeId);
        HashSet<Entity> done = new HashSet<Entity>();
        target.calc(done);
        Monitor monitor = new Monitor();
        for (Entity e : done) {
            monitor.add(e);
        }
        monitor.sort();
        return monitor;
    }

    Entity getEntity(int id) {
        return this.entityById.get(Integer.toString(id));
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public Monitor getMonitorTrace() {
        return this.monitorTrace;
    }

    Entity getOrCreateEntity(String id) {
        Entity e = this.entityById.get(id);
        if (e != null) {
            return e;
        }
        String type = this.objectType.get(id);
        if (type == null) {
            throw new RuntimeException("Cannot find entity type for ID '" + id + "'");
        }
        String name = this.objectName.get(id);
        int idNum = Gpr.parseIntSafe(id);
        e = type.equals("Complex") ? new Complex(idNum, name) : (type.equals("EntityCompartment") || type.equals("Compartment") || type.equals("GO_CellularComponent") ? new Compartment(idNum, name) : (type.equals("Reaction") ? new Reaction(idNum, name) : (type.equals("BlackBoxEvent") ? new BlackBoxEvent(idNum, name) : (type.equals("Pathway") ? new Pathway(idNum, name) : (type.equals("Depolymerisation") ? new Depolymerisation(idNum, name) : (type.equals("Polymerisation") ? new Polymerisation(idNum, name) : (type.equals("CatalystActivity") ? new CatalystActivity(idNum, name) : new Entity(idNum, name))))))));
        this.entityById.put(id, e);
        return e;
    }

    @Override
    public Iterator<Entity> iterator() {
        return this.entityById.values().iterator();
    }

    public void load(String dirName, String geneIdsFile) {
        this.dirName = dirName;
        if (this.verbose) {
            Timer.showStdErr("Loading Reactome data from directory '" + dirName + "'");
        }
        this.loadDatabaseObjects();
        this.loadComplex2HasComponent();
        this.loadPhysicalEntity2Compartment();
        this.loadPathway2HasEvent();
        this.loadReactionlikeEvent2Input();
        this.loadReactionlikeEvent2Output();
        this.loadReactionlikeEvent2CatalystActivity();
        this.loadRegulation();
        this.loadCatalystActivity();
        this.objectType = null;
        this.objectName = null;
        this.loadGeneIds(geneIdsFile);
        if (this.verbose) {
            Timer.showStdErr("Loading finished");
        }
    }

    protected void loadCatalystActivity() {
        String name = "CatalystActivity";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            CatalystActivity reaction;
            String[] rec = line.split("\t");
            String id = rec[0];
            String entityId = rec[1];
            if (id.equals("DB_ID") || (reaction = (CatalystActivity)this.entityById.get(id)) == null) continue;
            Entity e = this.getOrCreateEntity(entityId);
            reaction.addInput(e);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total catalyst entities assigned: " + (i - 1));
        }
    }

    protected void loadComplex2HasComponent() {
        String fileName = this.dirName + "Complex_2_hasComponent.txt";
        if (this.verbose) {
            Timer.showStdErr("Loading Complex_2_hasComponent from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            String[] rec = line.split("\t");
            String id = rec[0];
            int idNum = Gpr.parseIntSafe(id);
            String componentId = rec[1];
            if (idNum == 0) continue;
            Complex c = (Complex)this.getOrCreateEntity(id);
            c.add(this.getOrCreateEntity(componentId));
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total entities added: " + this.entityById.size());
        }
    }

    protected void loadDatabaseObjects() {
        String fileName = this.dirName + "DatabaseObject.txt";
        if (this.verbose) {
            Timer.showStdErr("Loading objects from '" + fileName + "'");
        }
        int numObjects = Gpr.countLines(fileName);
        if (this.verbose) {
            Timer.showStdErr("Counting lines from '" + fileName + "'. Total lines: " + numObjects);
        }
        this.objectType = new HashMap(numObjects);
        this.objectName = new HashMap(numObjects);
        int i = 1;
        LineFileIterator lfi = new LineFileIterator(fileName);
        for (String line : lfi) {
            String[] recs = line.split("\t");
            if (recs.length < 3) continue;
            String id = recs[0];
            String objType = recs[1];
            String objName = recs[2];
            this.objectType.put(id, objType);
            this.objectName.put(id, objName);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total objects loaded: " + this.objectName.size());
        }
    }

    public void loadGeneIds(String geneIdsFile) {
        if (this.verbose) {
            Timer.showStdErr("Loading Gene IDs from " + geneIdsFile);
        }
        GeneIds geneIds = new GeneIds(geneIdsFile);
        Pattern patternEnsg = Pattern.compile("ENSG[0-9]*");
        Pattern patternEnst = Pattern.compile("ENST[0-9]*");
        Pattern patternRefSeqNm = Pattern.compile("NM_[0-9]*");
        Pattern patternRefSeqNp = Pattern.compile("NP_[0-9]*");
        int countMatched = 0;
        int countUnMatched = 0;
        for (Entity e : this) {
            String name = e.getName();
            List<String> gids = null;
            String gname = null;
            if (Reactome.hasRegexp(patternEnst, name)) {
                gname = Reactome.findRegexp(patternEnst, name);
                gids = geneIds.getId2tr().getIds(gname);
            } else if (Reactome.hasRegexp(patternEnsg, name)) {
                gname = Reactome.findRegexp(patternEnsg, name);
                gids = new LinkedList<String>();
                gids.add(gname);
            } else if (Reactome.hasRegexp(patternRefSeqNm, name)) {
                gname = Reactome.findRegexp(patternRefSeqNm, name);
                gids = geneIds.getId2refseqId().getIds(gname);
            } else if (Reactome.hasRegexp(patternRefSeqNp, name)) {
                gname = Reactome.findRegexp(patternRefSeqNp, name);
                gids = geneIds.getId2refseqProtId().getIds(gname);
            } else {
                gname = name.split(" ")[0];
                gids = geneIds.getId2geneName().getIds(gname);
            }
            if (gids != null) {
                ++countMatched;
                for (String gid : gids) {
                    this.add(e, gid);
                }
                continue;
            }
            ++countUnMatched;
        }
        if (this.verbose) {
            Timer.showStdErr("Done. Entities matched to geneIDs:" + countMatched + " / " + countUnMatched);
        }
    }

    protected void loadMap(String name, String fileName, HashMap<String, String> map2) {
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            String[] rec = line.split("\t");
            String id = rec[0];
            String componentId = rec[1];
            map2.put(id, componentId);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total objects loaded: " + map2.size());
        }
    }

    protected void loadPathway2HasEvent() {
        String name = "Pathway_2_hasEvent";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            String[] rec = line.split("\t");
            String id = rec[0];
            String eventId = rec[1];
            if (id.equals("DB_ID")) continue;
            Pathway pathway = (Pathway)this.getOrCreateEntity(id);
            Event event = (Event)this.getOrCreateEntity(eventId);
            pathway.add(event);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total events assigned: " + (i - 1));
        }
    }

    protected void loadPhysicalEntity2Compartment() {
        String name = "PhysicalEntity_2_compartment";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            String[] rec = line.split("\t");
            String id = rec[0];
            String compartmentId = rec[1];
            if (id.equals("DB_ID")) continue;
            Entity e = this.getOrCreateEntity(id);
            Compartment compartment = (Compartment)this.getOrCreateEntity(compartmentId);
            if (e.getCompartment() != null) {
                throw new RuntimeException("Compartment already assigned for entity: " + e);
            }
            e.setCompartment(compartment);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total compartments assigned: " + (i - 1));
        }
    }

    protected void loadReactionlikeEvent2CatalystActivity() {
        String name = "ReactionlikeEvent_2_catalystActivity";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            Reaction reaction;
            String[] rec = line.split("\t");
            String id = rec[0];
            String catalystId = rec[1];
            if (id.equals("DB_ID") || (reaction = (Reaction)this.entityById.get(id)) == null) continue;
            Entity e = this.getOrCreateEntity(catalystId);
            reaction.addCatalyst(e);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total outputs assigned: " + (i - 1));
        }
    }

    protected void loadReactionlikeEvent2Input() {
        String name = "ReactionlikeEvent_2_input";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            Reaction reaction;
            String[] rec = line.split("\t");
            String id = rec[0];
            String inputId = rec[1];
            if (id.equals("DB_ID") || (reaction = (Reaction)this.entityById.get(id)) == null) continue;
            Entity e = this.getOrCreateEntity(inputId);
            reaction.addInput(e);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total inputs assigned: " + (i - 1));
        }
    }

    protected void loadReactionlikeEvent2Output() {
        String name = "ReactionlikeEvent_2_output";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            Reaction reaction;
            String[] rec = line.split("\t");
            String id = rec[0];
            String outputId = rec[1];
            if (id.equals("DB_ID") || (reaction = (Reaction)this.entityById.get(id)) == null) continue;
            Entity e = this.getOrCreateEntity(outputId);
            reaction.addOutput(e);
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total outputs assigned: " + (i - 1));
        }
    }

    protected void loadRegulation() {
        String name = "Regulation";
        String fileName = this.dirName + name + ".txt";
        if (this.verbose) {
            Timer.showStdErr("Loading " + name + " from '" + fileName + "'");
        }
        int i = 1;
        for (String line : Gpr.readFile(fileName).split("\n")) {
            Reaction reaction;
            String[] rec = line.split("\t");
            String id = rec[0];
            String regulatedEntityId = rec[1];
            String regulatorId = rec[2];
            if (id.equals("DB_ID") || (reaction = (Reaction)this.entityById.get(regulatedEntityId)) == null) continue;
            Entity e = this.getOrCreateEntity(regulatorId);
            reaction.addRegulator(e, this.objectType.get(id));
            if (!this.verbose) continue;
            Gpr.showMark(i++, 10000);
        }
        if (this.verbose) {
            System.err.println("");
        }
        if (this.verbose) {
            Timer.showStdErr("Total regulations assigned: " + (i - 1));
        }
    }

    public void reset() {
        for (Entity e : this) {
            e.reset();
        }
    }

    public boolean run(Gtex gtex, String nameMatch) {
        boolean ok = true;
        for (GtexExperiment gtexExperiment : gtex) {
            if (gtexExperiment.size() <= 0 || nameMatch != null && gtexExperiment.getTissueTypeDetail().toLowerCase().indexOf(nameMatch.toLowerCase()) < 0) continue;
            this.run(gtexExperiment);
        }
        return ok;
    }

    public boolean run(GtexExperiment gtexExperiment) {
        if (this.monitor == null) {
            this.monitor = this.createMonitor();
        }
        this.reset();
        this.setInputs(gtexExperiment);
        this.scaleWeights();
        this.calc(gtexExperiment);
        String experimentLabel = gtexExperiment.getTissueTypeDetail();
        if (this.monitor != null) {
            this.monitor.addResults(experimentLabel);
        }
        if (this.monitorTrace != null) {
            this.monitorTrace.addResults(experimentLabel);
        }
        return true;
    }

    void scaleWeights() {
        for (Entity e : this) {
            if (!e.isReaction()) continue;
            ((Reaction)e).scaleWeights();
        }
    }

    void setInputs(GtexExperiment gtexExperiment) {
        Gtex gtex = gtexExperiment.getGtex();
        for (String gid : gtex.getGeneIds()) {
            double value2;
            List entities = (List)this.entitiesByGeneId.get(gid);
            if (entities == null || Double.isNaN(value2 = gtexExperiment.getValue(gid))) continue;
            for (Entity e : entities) {
                e.setFixedOutput(value2);
            }
        }
    }

    public void setMonitorTrace(Monitor monitorTrace) {
        this.monitorTrace = monitorTrace;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - void declaration
     */
    void simplifyEntities() {
        void var4_9;
        if (this.verbose) {
            Timer.showStdErr("Simplify: Removing unnecesary nodes.");
        }
        HashSet<Entity> keep = new HashSet<Entity>();
        HashSet genes = new HashSet();
        for (List list2 : this.entitiesByGeneId.values()) {
            genes.addAll(list2);
        }
        for (Entity entity : this.entityById.values()) {
            HashSet<Entity> done = new HashSet<Entity>();
            entity.calc(done);
            boolean ok = genes.contains(entity);
            for (Entity ee : done) {
                ok |= genes.contains(ee);
            }
            if (!ok) continue;
            keep.addAll(done);
        }
        HashSet<Entity> toDelete = new HashSet<Entity>();
        for (Entity e : this.entityById.values()) {
            if (keep.contains(e)) continue;
            toDelete.add(e);
        }
        boolean bl = false;
        for (Entity e : toDelete) {
            String id = "" + e.getId();
            if (this.entityById.remove(id) == null) continue;
            ++var4_9;
        }
        if (this.verbose) {
            Timer.showStdErr("Simplify: done.\n\tGenes              : " + genes.size() + "\n\tEntities deleted   : " + (int)var4_9 + "\n\tEntities remaining : " + this.entityById.size());
        }
    }

    public String toString() {
        CountByType countByType = new CountByType();
        for (Entity e : this.entityById.values()) {
            countByType.inc(e.getClass().getSimpleName());
        }
        return countByType.toString();
    }

    public String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        for (Entity e : this.entityById.values()) {
            sb.append(e + "\n");
        }
        return sb.toString();
    }
}

