/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.transcription;

import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.views.ComplementSequenceView;
import org.biojava3.core.sequence.views.ReversedSequenceView;

public enum Frame {
    ONE(1, false),
    TWO(2, false),
    THREE(3, false),
    REVERSED_ONE(1, true),
    REVERSED_TWO(2, true),
    REVERSED_THREE(3, true);

    private final boolean reverse;
    private final int start;

    private Frame(int start, boolean reverse2) {
        this.start = start;
        this.reverse = reverse2;
    }

    public static Frame getDefaultFrame() {
        return ONE;
    }

    public static Frame[] getForwardFrames() {
        return new Frame[]{ONE, TWO, THREE};
    }

    public static Frame[] getReverseFrames() {
        return new Frame[]{REVERSED_ONE, REVERSED_TWO, REVERSED_THREE};
    }

    public static Frame[] getAllFrames() {
        return Frame.values();
    }

    public <C extends NucleotideCompound> Sequence<C> wrap(Sequence<C> incoming) {
        Sequence<C> reversed2 = this.reverse ? new ComplementSequenceView<C>(new ReversedSequenceView<C>(incoming)) : incoming;
        Sequence<C> finalSeq = this.start == 1 ? reversed2 : reversed2.getSubSequence(this.start, reversed2.getLength());
        return finalSeq;
    }
}

