/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.storage.BitSequenceReader;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;

public class TwoBitSequenceReader<C extends NucleotideCompound>
extends BitSequenceReader<C> {
    public TwoBitSequenceReader(Sequence<C> sequence2) {
        super(new TwoBitArrayWorker<C>(sequence2), sequence2.getAccession());
    }

    public TwoBitSequenceReader(String sequence2, CompoundSet<C> compoundSet) {
        this(sequence2, compoundSet, new AccessionID("Unknown"));
    }

    public TwoBitSequenceReader(String sequence2, CompoundSet<C> compoundSet, AccessionID accession) {
        super(new TwoBitArrayWorker<C>(sequence2, compoundSet), accession);
    }

    public TwoBitSequenceReader(TwoBitArrayWorker<C> worker) {
        super(worker, new AccessionID("unknown"));
    }

    public TwoBitSequenceReader(TwoBitArrayWorker<C> worker, AccessionID accession) {
        super(worker, accession);
    }

    public static class TwoBitArrayWorker<C extends NucleotideCompound>
    extends BitSequenceReader.BitArrayWorker<C> {
        private static final byte MASK = (byte)((int)Math.pow(2.0, 0.0) | (int)Math.pow(2.0, 1.0));

        public TwoBitArrayWorker(CompoundSet<C> compoundSet, int length) {
            super(compoundSet, length);
        }

        public TwoBitArrayWorker(CompoundSet<C> compoundSet, int[] sequence2) {
            super(compoundSet, sequence2);
        }

        public TwoBitArrayWorker(Sequence<C> sequence2) {
            super(sequence2);
        }

        public TwoBitArrayWorker(String sequence2, CompoundSet<C> compoundSet) {
            super(sequence2, compoundSet);
        }

        @Override
        protected byte bitMask() {
            return MASK;
        }

        @Override
        protected int compoundsPerDatatype() {
            return 16;
        }

        @Override
        protected Map<C, Integer> generateCompoundsToIndex() {
            final CompoundSet cs = this.getCompoundSet();
            return new HashMap<C, Integer>(){
                {
                    this.put(cs.getCompoundForString("T"), 0);
                    this.put(cs.getCompoundForString("C"), 1);
                    this.put(cs.getCompoundForString("A"), 2);
                    this.put(cs.getCompoundForString("G"), 3);
                    this.put(cs.getCompoundForString("t"), 0);
                    this.put(cs.getCompoundForString("c"), 1);
                    this.put(cs.getCompoundForString("a"), 2);
                    this.put(cs.getCompoundForString("g"), 3);
                }
            };
        }

        @Override
        protected List<C> generateIndexToCompounds() {
            CompoundSet cs = this.getCompoundSet();
            ArrayList result2 = new ArrayList();
            result2.add(cs.getCompoundForString("T"));
            result2.add(cs.getCompoundForString("C"));
            result2.add(cs.getCompoundForString("A"));
            result2.add(cs.getCompoundForString("G"));
            return result2;
        }
    }
}

