/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.biojava.bio.structure.domain.pdp.Domain;
import org.biojava.bio.structure.scop.ScopDescription;
import org.biojava.bio.structure.scop.ScopDomain;
import org.biojava.bio.structure.scop.ScopNode;
import org.biojava.bio.structure.scop.server.ScopDescriptions;
import org.biojava.bio.structure.scop.server.ScopDomains;
import org.biojava.bio.structure.scop.server.ScopNodes;
import org.biojava.bio.structure.scop.server.TreeSetStringWrapper;

public class XMLUtil {
    static JAXBContext jaxbContextScopDescription;
    static JAXBContext jaxbContextScopDomain;
    static JAXBContext jaxbContextScopNode;
    static JAXBContext jaxbContextDomains;
    static JAXBContext jaxbContextStringSortedSet;

    public static String getScopDescriptionXML(ScopDescription desc) {
        return XMLUtil.converScopDescription(desc);
    }

    public static ScopDescription getScopDescriptionFromXML(String xml) {
        ScopDescription job = null;
        try {
            Unmarshaller un = jaxbContextScopDescription.createUnmarshaller();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            job = (ScopDescription)un.unmarshal((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return job;
    }

    private static String converScopDescription(ScopDescription desc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextScopDescription.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)desc, (OutputStream)ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static String getScopDescriptionsXML(List<ScopDescription> descriptions) {
        ScopDescriptions container = new ScopDescriptions();
        container.setScopDescription(descriptions);
        return container.toXML();
    }

    public static String getScopNodeXML(ScopNode scopNode) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextScopNode.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)scopNode, (OutputStream)ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static ScopNode getScopNodeFromXML(String xml) {
        ScopNode job = null;
        try {
            Unmarshaller un = jaxbContextScopDescription.createUnmarshaller();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            job = (ScopNode)un.unmarshal((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return job;
    }

    public static String getScopNodesXML(List<ScopNode> nodes) {
        ScopNodes container = new ScopNodes();
        container.setScopNode(nodes);
        return container.toXML();
    }

    public static String getScopDomainXML(ScopDomain domain) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextScopDomain.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)domain, (OutputStream)ps);
        }
        catch (Exception e) {
            System.err.println("Could not serialize  ScopDomain to XML :" + domain);
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static ScopDomain getScopDomainFromXML(String xml) {
        ScopDomain job = null;
        try {
            Unmarshaller un = jaxbContextScopDomain.createUnmarshaller();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            job = (ScopDomain)un.unmarshal((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return job;
    }

    public static String getScopDomainsXML(List<ScopDomain> domains) {
        ScopDomains container = new ScopDomains();
        container.setScopDomain(domains);
        return container.toXML();
    }

    public static String getDomainsXML(SortedSet<Domain> domains) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextDomains.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(domains, (OutputStream)ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static SortedSet<Domain> getDomainsFromXML(String xml) {
        SortedSet domains = null;
        try {
            Unmarshaller un = jaxbContextDomains.createUnmarshaller();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            domains = (SortedSet)un.unmarshal((InputStream)bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    public static String getDomainRangesXML(SortedSet<String> domainRanges) {
        if (!(domainRanges instanceof TreeSet)) {
            throw new IllegalArgumentException("SortedSet needs to be a TreeSet!");
        }
        TreeSet data2 = (TreeSet)domainRanges;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            Marshaller m = jaxbContextStringSortedSet.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            TreeSetStringWrapper wrapper = new TreeSetStringWrapper();
            wrapper.setData(data2);
            m.marshal((Object)wrapper, (OutputStream)ps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static SortedSet<String> getDomainRangesFromXML(String xml) {
        TreeSet<String> domains = null;
        try {
            Unmarshaller un = jaxbContextStringSortedSet.createUnmarshaller();
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            TreeSetStringWrapper wrapper = (TreeSetStringWrapper)un.unmarshal((InputStream)bais);
            domains = wrapper.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    static {
        try {
            jaxbContextScopDescription = JAXBContext.newInstance((Class[])new Class[]{ScopDescription.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jaxbContextScopDomain = JAXBContext.newInstance((Class[])new Class[]{ScopDomain.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jaxbContextScopNode = JAXBContext.newInstance((Class[])new Class[]{ScopNode.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jaxbContextDomains = JAXBContext.newInstance((Class[])new Class[]{TreeSet.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            jaxbContextStringSortedSet = JAXBContext.newInstance((Class[])new Class[]{TreeSetStringWrapper.class});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

