/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.scop;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.biojava.bio.structure.scop.ScopDatabase;
import org.biojava.bio.structure.scop.ScopInstallation;

public class BerkeleyScopInstallation
extends ScopInstallation
implements ScopDatabase {
    String defaultBerkeleyDownloadURL = "http://scop.berkeley.edu/downloads/parse/";
    String defaultBerkeleyScopVersion = "1.75A";
    public static final String claFileName = "dir.cla.scop.";
    public static final String desFileName = "dir.des.scop.";
    public static final String hieFileName = "dir.hie.scop.";
    public static final String comFileName = "dir.com.scop.";

    public BerkeleyScopInstallation() {
        this.setScopVersion(this.defaultBerkeleyScopVersion);
        this.setScopDownloadURL(this.defaultBerkeleyDownloadURL);
    }

    @Override
    protected void downloadClaFile() throws FileNotFoundException, IOException {
        String remoteFilename = claFileName + this.scopVersion + ".txt";
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getClaFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    @Override
    protected void downloadDesFile() throws FileNotFoundException, IOException {
        String remoteFilename = desFileName + this.scopVersion + ".txt";
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getDesFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    @Override
    protected void downloadHieFile() throws FileNotFoundException, IOException {
        String remoteFilename = hieFileName + this.scopVersion + ".txt";
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getHieFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }

    @Override
    protected void downloadComFile() throws FileNotFoundException, IOException {
        String remoteFilename = comFileName + this.scopVersion + ".txt";
        URL url = new URL(this.scopDownloadURL + remoteFilename);
        String localFileName = this.getComFilename();
        File localFile = new File(localFileName);
        this.downloadFileFromRemote(url, localFile);
    }
}

