/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.biojava.bio.structure.jama.Matrix;
import org.biojava3.core.util.PrettyXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ModelTransformationMatrix
implements Cloneable {
    public String id = null;
    public String ndbChainId = null;
    public String symmetryShorthand = null;
    public String code = null;
    public float[] values;
    public static final Pattern spaces = Pattern.compile("\\s+");
    public static final Pattern commaSpaces = Pattern.compile("\\s*,\\s*");
    public static final Pattern slash = Pattern.compile("/");

    public ModelTransformationMatrix() {
        this.init();
    }

    public ModelTransformationMatrix(ModelTransformationMatrix src) {
        this.init();
        for (int ix = 0; ix < 16; ++ix) {
            this.values[ix] = src.values[ix];
        }
        this.id = src.id;
        this.ndbChainId = src.ndbChainId;
        this.symmetryShorthand = src.symmetryShorthand;
        this.code = src.code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformationMatrix(Matrix matrix, double[] vector) {
        this.init();
        float[] fArray = this.values;
        synchronized (this.values) {
            this.values[0] = (float)matrix.get(0, 0);
            this.values[1] = (float)matrix.get(0, 1);
            this.values[2] = (float)matrix.get(0, 2);
            this.values[3] = 0.0f;
            this.values[4] = (float)matrix.get(1, 0);
            this.values[5] = (float)matrix.get(1, 1);
            this.values[6] = (float)matrix.get(1, 2);
            this.values[7] = 0.0f;
            this.values[8] = (float)matrix.get(2, 0);
            this.values[9] = (float)matrix.get(2, 1);
            this.values[10] = (float)matrix.get(2, 2);
            this.values[11] = 0.0f;
            this.values[12] = (float)vector[0];
            this.values[13] = (float)vector[1];
            this.values[14] = (float)vector[2];
            this.values[15] = 1.0f;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void transformPoint(double[] point, double[] result2) {
        result2[0] = (double)this.values[0] * point[0] + (double)this.values[4] * point[1] + (double)this.values[8] * point[2] + (double)this.values[12];
        result2[1] = (double)this.values[1] * point[0] + (double)this.values[5] * point[1] + (double)this.values[9] * point[2] + (double)this.values[13];
        result2[2] = (double)this.values[2] * point[0] + (double)this.values[6] * point[1] + (double)this.values[10] * point[2] + (double)this.values[14];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransformationMatrix(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22, float v0, float v1, float v2) {
        this.init();
        float[] fArray = this.values;
        synchronized (this.values) {
            this.values[0] = m00;
            this.values[1] = m01;
            this.values[2] = m02;
            this.values[3] = 0.0f;
            this.values[4] = m10;
            this.values[5] = m11;
            this.values[6] = m12;
            this.values[7] = 0.0f;
            this.values[8] = m20;
            this.values[9] = m21;
            this.values[10] = m22;
            this.values[11] = 0.0f;
            this.values[12] = v0;
            this.values[13] = v1;
            this.values[14] = v2;
            this.values[15] = 1.0f;
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    public void setIdentity() {
        this.values[0] = 1.0f;
        this.values[1] = 0.0f;
        this.values[2] = 0.0f;
        this.values[3] = 0.0f;
        this.values[4] = 0.0f;
        this.values[5] = 1.0f;
        this.values[6] = 0.0f;
        this.values[7] = 0.0f;
        this.values[8] = 0.0f;
        this.values[9] = 0.0f;
        this.values[10] = 1.0f;
        this.values[11] = 0.0f;
        this.values[12] = 0.0f;
        this.values[13] = 0.0f;
        this.values[14] = 0.0f;
        this.values[15] = 1.0f;
    }

    private boolean luDecomposition(double[] matrix0, int[] row_perm) {
        double[] row_scale = new double[4];
        int ptr = 0;
        int rs = 0;
        int i = 4;
        while (i-- != 0) {
            double big = 0.0;
            int j = 4;
            while (j-- != 0) {
                double temp = matrix0[ptr++];
                if (!((temp = Math.abs(temp)) > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                return false;
            }
            row_scale[rs++] = 1.0 / big;
        }
        int mtx = 0;
        for (int j = 0; j < 4; ++j) {
            double temp;
            int p1;
            int k;
            int p2;
            double sum2;
            int target;
            int i2;
            for (i2 = 0; i2 < j; ++i2) {
                target = mtx + 4 * i2 + j;
                sum2 = matrix0[target];
                int k2 = i2;
                int p12 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k2-- != 0) {
                    sum2 -= matrix0[p12] * matrix0[p2];
                    ++p12;
                    p2 += 4;
                }
                matrix0[target] = sum2;
            }
            double big = 0.0;
            int imax = -1;
            for (i2 = j; i2 < 4; ++i2) {
                double d;
                target = mtx + 4 * i2 + j;
                sum2 = matrix0[target];
                k = j;
                p1 = mtx + 4 * i2;
                p2 = mtx + j;
                while (k-- != 0) {
                    sum2 -= matrix0[p1] * matrix0[p2];
                    ++p1;
                    p2 += 4;
                }
                matrix0[target] = sum2;
                temp = row_scale[i2] * Math.abs(sum2);
                if (!(d >= big)) continue;
                big = temp;
                imax = i2;
            }
            if (imax < 0) {
                new Exception().printStackTrace();
            }
            if (j != imax) {
                k = 4;
                p1 = mtx + 4 * imax;
                p2 = mtx + 4 * j;
                while (k-- != 0) {
                    temp = matrix0[p1];
                    matrix0[p1++] = matrix0[p2];
                    matrix0[p2++] = temp;
                }
                row_scale[imax] = row_scale[j];
            }
            row_perm[j] = imax;
            if (matrix0[mtx + 4 * j + j] == 0.0) {
                return false;
            }
            if (j == 3) continue;
            temp = 1.0 / matrix0[mtx + 4 * j + j];
            target = mtx + 4 * (j + 1) + j;
            i2 = 3 - j;
            while (i2-- != 0) {
                int n = target;
                matrix0[n] = matrix0[n] * temp;
                target += 4;
            }
        }
        return true;
    }

    private void luBacksubstitution(double[] matrix1, int[] row_perm, double[] matrix2) {
        int rp = 0;
        for (int k = 0; k < 4; ++k) {
            int rv;
            int cv = k;
            int ii = -1;
            for (int i = 0; i < 4; ++i) {
                int ip = row_perm[rp + i];
                double sum2 = matrix2[cv + 4 * ip];
                matrix2[cv + 4 * ip] = matrix2[cv + 4 * i];
                if (ii >= 0) {
                    rv = i * 4;
                    for (int j = ii; j <= i - 1; ++j) {
                        sum2 -= matrix1[rv + j] * matrix2[cv + 4 * j];
                    }
                } else if (sum2 != 0.0) {
                    ii = i;
                }
                matrix2[cv + 4 * i] = sum2;
            }
            rv = 12;
            int n = cv + 12;
            matrix2[n] = matrix2[n] / matrix1[rv + 3];
            matrix2[cv + 8] = (matrix2[cv + 8] - matrix1[(rv -= 4) + 3] * matrix2[cv + 12]) / matrix1[rv + 2];
            matrix2[cv + 4] = (matrix2[cv + 4] - matrix1[(rv -= 4) + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 1];
            matrix2[cv + 0] = (matrix2[cv + 0] - matrix1[(rv -= 4) + 1] * matrix2[cv + 4] - matrix1[rv + 2] * matrix2[cv + 8] - matrix1[rv + 3] * matrix2[cv + 12]) / matrix1[rv + 0];
        }
    }

    public ModelTransformationMatrix inverse3() {
        ModelTransformationMatrix returned = new ModelTransformationMatrix();
        returned.init();
        double[] temp = new double[16];
        double[] result2 = new double[16];
        int[] row_perm = new int[4];
        temp[0] = this.values[0];
        temp[1] = this.values[4];
        temp[2] = this.values[8];
        temp[3] = this.values[12];
        temp[4] = this.values[1];
        temp[5] = this.values[5];
        temp[6] = this.values[9];
        temp[7] = this.values[13];
        temp[8] = this.values[2];
        temp[9] = this.values[6];
        temp[10] = this.values[10];
        temp[11] = this.values[14];
        temp[12] = this.values[3];
        temp[13] = this.values[7];
        temp[14] = this.values[11];
        temp[15] = this.values[15];
        if (!this.luDecomposition(temp, row_perm)) {
            new Exception("Error: matrix has no inverse.").printStackTrace();
        }
        for (int i = 0; i < 16; ++i) {
            result2[i] = 0.0;
        }
        result2[0] = 1.0;
        result2[5] = 1.0;
        result2[10] = 1.0;
        result2[15] = 1.0;
        this.luBacksubstitution(temp, row_perm, result2);
        returned.values[0] = (float)result2[0];
        returned.values[4] = (float)result2[1];
        returned.values[8] = (float)result2[2];
        returned.values[12] = (float)result2[3];
        returned.values[1] = (float)result2[4];
        returned.values[5] = (float)result2[5];
        returned.values[9] = (float)result2[6];
        returned.values[13] = (float)result2[7];
        returned.values[2] = (float)result2[8];
        returned.values[6] = (float)result2[9];
        returned.values[10] = (float)result2[10];
        returned.values[14] = (float)result2[11];
        returned.values[3] = (float)result2[12];
        returned.values[7] = (float)result2[13];
        returned.values[11] = (float)result2[14];
        returned.values[15] = (float)result2[15];
        return returned;
    }

    public void updateFullSymmetryDataWithInverseFractionalTransform(ModelTransformationMatrix fractional, ModelTransformationMatrix fractionalInverse) {
        ModelTransformationMatrix result2 = ModelTransformationMatrix.multiply4square_x_4square2(fractionalInverse, this);
        result2.printMatrix("**fractional * symmetry**");
        result2 = ModelTransformationMatrix.multiply4square_x_4square2(result2, fractional);
        this.values = result2.values;
        for (int i = 0; i < 16; ++i) {
            float val = this.values[i];
            if (val == 0.0f || !((double)val < 1.0E-7) || !((double)val > -1.0E-7)) continue;
            this.values[i] = 0.0f;
        }
        this.printMatrix("**symmetry * inverse fractional**");
    }

    public static ModelTransformationMatrix multiply4square_x_4square2(ModelTransformationMatrix leftMat, ModelTransformationMatrix rightMat) {
        ModelTransformationMatrix result2 = new ModelTransformationMatrix();
        result2.init();
        float m00 = leftMat.values[0] * rightMat.values[0] + leftMat.values[4] * rightMat.values[1] + leftMat.values[8] * rightMat.values[2] + leftMat.values[12] * rightMat.values[3];
        float m01 = leftMat.values[0] * rightMat.values[4] + leftMat.values[4] * rightMat.values[5] + leftMat.values[8] * rightMat.values[6] + leftMat.values[12] * rightMat.values[7];
        float m02 = leftMat.values[0] * rightMat.values[8] + leftMat.values[4] * rightMat.values[9] + leftMat.values[8] * rightMat.values[10] + leftMat.values[12] * rightMat.values[11];
        float m03 = leftMat.values[0] * rightMat.values[12] + leftMat.values[4] * rightMat.values[13] + leftMat.values[8] * rightMat.values[14] + leftMat.values[12] * rightMat.values[15];
        float m10 = leftMat.values[1] * rightMat.values[0] + leftMat.values[5] * rightMat.values[1] + leftMat.values[9] * rightMat.values[2] + leftMat.values[13] * rightMat.values[3];
        float m11 = leftMat.values[1] * rightMat.values[4] + leftMat.values[5] * rightMat.values[5] + leftMat.values[9] * rightMat.values[6] + leftMat.values[13] * rightMat.values[7];
        float m12 = leftMat.values[1] * rightMat.values[8] + leftMat.values[5] * rightMat.values[9] + leftMat.values[9] * rightMat.values[10] + leftMat.values[13] * rightMat.values[11];
        float m13 = leftMat.values[1] * rightMat.values[12] + leftMat.values[5] * rightMat.values[13] + leftMat.values[9] * rightMat.values[14] + leftMat.values[13] * rightMat.values[15];
        float m20 = leftMat.values[2] * rightMat.values[0] + leftMat.values[6] * rightMat.values[1] + leftMat.values[10] * rightMat.values[2] + leftMat.values[14] * rightMat.values[3];
        float m21 = leftMat.values[2] * rightMat.values[4] + leftMat.values[6] * rightMat.values[5] + leftMat.values[10] * rightMat.values[6] + leftMat.values[14] * rightMat.values[7];
        float m22 = leftMat.values[2] * rightMat.values[8] + leftMat.values[6] * rightMat.values[9] + leftMat.values[10] * rightMat.values[10] + leftMat.values[14] * rightMat.values[11];
        float m23 = leftMat.values[2] * rightMat.values[12] + leftMat.values[6] * rightMat.values[13] + leftMat.values[10] * rightMat.values[14] + leftMat.values[14] * rightMat.values[15];
        float m30 = leftMat.values[3] * rightMat.values[0] + leftMat.values[7] * rightMat.values[1] + leftMat.values[11] * rightMat.values[2] + leftMat.values[15] * rightMat.values[3];
        float m31 = leftMat.values[3] * rightMat.values[4] + leftMat.values[7] * rightMat.values[5] + leftMat.values[11] * rightMat.values[6] + leftMat.values[15] * rightMat.values[7];
        float m32 = leftMat.values[3] * rightMat.values[8] + leftMat.values[7] * rightMat.values[9] + leftMat.values[11] * rightMat.values[10] + leftMat.values[15] * rightMat.values[11];
        float m33 = leftMat.values[3] * rightMat.values[12] + leftMat.values[7] * rightMat.values[13] + leftMat.values[11] * rightMat.values[14] + leftMat.values[15] * rightMat.values[15];
        result2.values[0] = m00;
        result2.values[4] = m01;
        result2.values[8] = m02;
        result2.values[12] = m03;
        result2.values[1] = m10;
        result2.values[5] = m11;
        result2.values[9] = m12;
        result2.values[13] = m13;
        result2.values[2] = m20;
        result2.values[6] = m21;
        result2.values[10] = m22;
        result2.values[14] = m23;
        result2.values[3] = m30;
        result2.values[7] = m31;
        result2.values[11] = m32;
        result2.values[15] = m33;
        return result2;
    }

    public void setFullSymmetryOperation(String fullSymmetryOperation_) {
        if (fullSymmetryOperation_ == null) {
            return;
        }
        String fullSymmetryOperation = spaces.matcher(fullSymmetryOperation_).replaceAll("");
        String[] xyzRawArray = commaSpaces.split(fullSymmetryOperation);
        if (xyzRawArray == null || xyzRawArray.length != 3) {
            return;
        }
        this.init();
        for (int i = 0; i < xyzRawArray.length; ++i) {
            String fractionSt;
            String[] fractionParts;
            int coordIndexZ;
            int coordIndexY;
            String xyzRaw = xyzRawArray[i];
            this.values[i] = 0.0f;
            this.values[i + 4] = 0.0f;
            this.values[i + 8] = 0.0f;
            int coordIndexX = xyzRaw.indexOf(120);
            if (coordIndexX >= 0) {
                this.values[i] = coordIndexX != 0 && xyzRaw.charAt(coordIndexX - 1) == '-' ? -1.0f : 1.0f;
            }
            if ((coordIndexY = xyzRaw.indexOf(121)) >= 0) {
                this.values[i + 4] = coordIndexY != 0 && xyzRaw.charAt(coordIndexY - 1) == '-' ? -1.0f : 1.0f;
            }
            if ((coordIndexZ = xyzRaw.indexOf(122)) >= 0) {
                this.values[i + 8] = coordIndexZ != 0 && xyzRaw.charAt(coordIndexZ - 1) == '-' ? -1.0f : 1.0f;
            }
            int coordIndex = -1;
            if (coordIndexX >= 0) {
                coordIndex = coordIndexX;
            }
            if (coordIndex >= 0) {
                if (coordIndexY >= 0) {
                    coordIndex = Math.min(coordIndex, coordIndexY);
                }
            } else {
                coordIndex = coordIndexY;
            }
            if (coordIndex >= 0) {
                if (coordIndexZ >= 0) {
                    coordIndex = Math.min(coordIndex, coordIndexZ);
                }
            } else {
                coordIndex = coordIndexZ;
            }
            if (coordIndex < 0) {
                this.values = null;
                return;
            }
            int translationIndex = 12 + i;
            this.values[translationIndex] = 0.0f;
            if (coordIndex == 0) continue;
            char tmp = xyzRaw.charAt(coordIndex - 1);
            if (tmp == '-' || tmp == '+') {
                --coordIndex;
            }
            if (coordIndex == 0) continue;
            int fractionStartIndex = 0;
            boolean isNegated = false;
            if (xyzRaw.charAt(0) == '-') {
                isNegated = true;
                fractionStartIndex = 1;
            }
            if ((fractionParts = slash.split(fractionSt = xyzRaw.substring(fractionStartIndex, coordIndex))) == null || fractionParts.length == 0 || fractionParts.length > 2) {
                return;
            }
            float fraction = Float.parseFloat(fractionParts[0]);
            if (fractionParts.length == 2) {
                fraction /= Float.parseFloat(fractionParts[1]);
            }
            if (isNegated) {
                fraction = -fraction;
            }
            this.values[translationIndex] = fraction;
        }
        this.values[3] = 0.0f;
        this.values[7] = 0.0f;
        this.values[11] = 0.0f;
        this.values[15] = 1.0f;
        this.printMatrix(fullSymmetryOperation);
    }

    public void printMatrix(String fullSymmetryOperation) {
    }

    public void init() {
        if (this.values == null) {
            this.values = new float[16];
        }
        this.setIdentity();
    }

    public Matrix getMatrix() {
        Matrix m = new Matrix(3, 3);
        m.set(0, 0, this.values[0]);
        m.set(1, 0, this.values[1]);
        m.set(2, 0, this.values[2]);
        m.set(0, 1, this.values[4]);
        m.set(1, 1, this.values[5]);
        m.set(2, 1, this.values[6]);
        m.set(0, 2, this.values[8]);
        m.set(1, 2, this.values[9]);
        m.set(2, 2, this.values[10]);
        return m;
    }

    public void setMatrix(Matrix m) {
        this.values[0] = (float)m.get(0, 0);
        this.values[1] = (float)m.get(0, 1);
        this.values[2] = (float)m.get(0, 2);
        this.values[4] = (float)m.get(1, 0);
        this.values[5] = (float)m.get(1, 1);
        this.values[6] = (float)m.get(1, 2);
        this.values[8] = (float)m.get(2, 0);
        this.values[9] = (float)m.get(2, 1);
        this.values[10] = (float)m.get(2, 2);
    }

    public double[] getVector() {
        double[] v = new double[]{this.values[12], this.values[13], this.values[14]};
        return v;
    }

    public void setVector(double[] v) {
        this.values[12] = (float)v[0];
        this.values[13] = (float)v[1];
        this.values[14] = (float)v[2];
    }

    public String toString() {
        Matrix m = this.getMatrix();
        double[] v = this.getVector();
        return "ModelTransformationMatrix [id=" + this.id + ", ndbChainId=" + this.ndbChainId + ", symmetryShorthand=" + this.symmetryShorthand + ", code=" + this.code + ", values=" + m.toString() + " " + Arrays.toString(v) + "]";
    }

    public String toXML() throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter writer = new PrintWriter(sw);
        PrettyXMLWriter xml = new PrettyXMLWriter(new PrintWriter(writer));
        this.toXML(xml);
        xml.close();
        writer.close();
        sw.close();
        return sw.toString();
    }

    public void toXML(PrettyXMLWriter xml) throws IOException {
        xml.openTag("transformation");
        xml.attribute("index", this.id);
        String shorthand = this.symmetryShorthand;
        if (shorthand != null) {
            xml.attribute("symmetryShorthand", shorthand);
        }
        if (this.code != null) {
            xml.attribute("code", this.code);
        }
        xml.openTag("matrix");
        Matrix m = this.getMatrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                xml.attribute("m" + (i + 1) + (j + 1), String.format("%.8f", m.get(i, j)));
            }
        }
        xml.closeTag("matrix");
        double[] shift = this.getVector();
        xml.openTag("shift");
        for (int i = 0; i < 3; ++i) {
            xml.attribute("v" + (i + 1), String.format("%.8f", shift[i]));
        }
        xml.closeTag("shift");
        xml.closeTag("transformation");
    }

    public static ModelTransformationMatrix fromXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        List<ModelTransformationMatrix> transformations = ModelTransformationMatrix.fromMultiXML(xml);
        if (transformations.size() > 0) {
            return transformations.get(0);
        }
        return null;
    }

    public static List<ModelTransformationMatrix> fromMultiXML(String xml) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<ModelTransformationMatrix> transformations = new ArrayList<ModelTransformationMatrix>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = factory.newDocumentBuilder();
        InputSource inStream = new InputSource();
        inStream.setCharacterStream(new StringReader(xml));
        Document doc = db.parse(inStream);
        doc.getDocumentElement().normalize();
        NodeList listOfTransforms = doc.getElementsByTagName("transformation");
        for (int pos = 0; pos < listOfTransforms.getLength(); ++pos) {
            Node rootElement = listOfTransforms.item(pos);
            ModelTransformationMatrix max2 = new ModelTransformationMatrix();
            max2.id = ModelTransformationMatrix.getAttribute(rootElement, "index");
            max2.ndbChainId = ModelTransformationMatrix.getAttribute(rootElement, "chainId");
            max2.code = ModelTransformationMatrix.getAttribute(rootElement, "code");
            max2.symmetryShorthand = ModelTransformationMatrix.getAttribute(rootElement, "symmetryShorthand");
            NodeList listOfChildren = rootElement.getChildNodes();
            for (int i = 0; i < listOfChildren.getLength(); ++i) {
                Node block = listOfChildren.item(i);
                if (block.getNodeName().equals("matrix")) {
                    max2.setMatrix(ModelTransformationMatrix.getMatrixFromXML(block));
                }
                if (!block.getNodeName().equals("shift")) continue;
                max2.setVector(ModelTransformationMatrix.getVectorFromXML(block));
            }
            transformations.add(max2);
        }
        return transformations;
    }

    private static double[] getVectorFromXML(Node block) {
        double[] d = new double[3];
        for (int i = 0; i < 3; ++i) {
            d[i] = Float.parseFloat(ModelTransformationMatrix.getAttribute(block, "v" + (i + 1)));
        }
        return d;
    }

    private static Matrix getMatrixFromXML(Node block) {
        Matrix m = new Matrix(3, 3);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                String val = ModelTransformationMatrix.getAttribute(block, "m" + (j + 1) + (i + 1));
                m.set(j, i, Float.parseFloat(val));
            }
        }
        return m;
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value2 = att.getTextContent();
        return value2;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNdbChainId() {
        return this.ndbChainId;
    }

    public void setNdbChainId(String ndbChainId) {
        this.ndbChainId = ndbChainId;
    }

    public String getSymmetryShorthand() {
        return this.symmetryShorthand;
    }

    public void setSymmetryShorthand(String symmetryShorthand) {
        this.symmetryShorthand = symmetryShorthand;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public ModelTransformationMatrix clone() {
        ModelTransformationMatrix m = new ModelTransformationMatrix();
        m.setMatrix(this.getMatrix());
        m.setVector(this.getVector());
        m.setId(this.getId());
        m.setNdbChainId(this.getNdbChainId());
        m.setSymmetryShorthand(this.getSymmetryShorthand());
        m.setCode(this.getCode());
        return m;
    }
}

