/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.quaternary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.ChainImpl;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureImpl;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.jama.Matrix;
import org.biojava.bio.structure.quaternary.CartesianProduct;
import org.biojava.bio.structure.quaternary.ModelTransformationMatrix;
import org.biojava.bio.structure.quaternary.OrderedPair;

public class BioAssemblyTools {
    public static boolean isUnaryExpression(String expression) {
        int first = expression.indexOf("(");
        int last2 = expression.lastIndexOf("(");
        if (first < 0 || last2 < 0) {
            return true;
        }
        return first != 0 || last2 <= first;
    }

    public static List<String> parseUnaryOperatorExpression(String operatorExpression) throws IllegalArgumentException {
        return BioAssemblyTools.parseSubExpression(operatorExpression);
    }

    private static List<String> parseSubExpression(String expression) throws IllegalArgumentException {
        String tmp = expression.replace("(", "");
        tmp = tmp.replace(")", "");
        List<String> components = null;
        try {
            components = Arrays.asList(tmp.split(","));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        ArrayList<String> operators = new ArrayList<String>();
        for (String component : components) {
            if (component.contains("-")) {
                operators.addAll(BioAssemblyTools.expandRange(component));
                continue;
            }
            operators.add(component);
        }
        return operators;
    }

    private static List<String> expandRange(String expression) throws IllegalArgumentException {
        int first = 0;
        int last2 = 0;
        try {
            String[] range2 = expression.split("-");
            first = Integer.parseInt(range2[0]);
            last2 = Integer.parseInt(range2[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid range specification in oper_expression: " + expression);
        }
        ArrayList<String> expandedExpression = new ArrayList<String>(last2 - first + 1);
        for (int i = first; i <= last2; ++i) {
            expandedExpression.add(String.valueOf(i));
        }
        return expandedExpression;
    }

    public static List<OrderedPair<String>> parseBinaryOperatorExpression(String expression) throws IllegalArgumentException {
        String[] subExpressions = null;
        try {
            subExpressions = expression.split("\\)\\(");
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        if (subExpressions.length != 2) {
            throw new IllegalArgumentException("Invalid oper_expression: " + expression);
        }
        List<String> leftSide = BioAssemblyTools.parseSubExpression(subExpressions[0]);
        List<String> rightSide = BioAssemblyTools.parseSubExpression(subExpressions[1]);
        CartesianProduct<String> product2 = new CartesianProduct<String>(leftSide, rightSide);
        return product2.getOrderedPairs();
    }

    public static double[][] getBiologicalMoleculeBounds(Structure asymStructure, List<ModelTransformationMatrix> transformations) {
        Atom[] atoms;
        double[][] coordinateBounds = new double[2][3];
        coordinateBounds[0][0] = Double.MAX_VALUE;
        coordinateBounds[0][1] = Double.MAX_VALUE;
        coordinateBounds[0][2] = Double.MAX_VALUE;
        coordinateBounds[1][0] = Double.MIN_VALUE;
        coordinateBounds[1][1] = Double.MIN_VALUE;
        coordinateBounds[1][2] = Double.MIN_VALUE;
        for (Atom a : atoms = StructureTools.getAllAtomArray(asymStructure)) {
            Chain c = a.getGroup().getChain();
            String intChainID = c.getInternalChainID();
            if (intChainID == null) {
                intChainID = c.getChainID();
            }
            for (ModelTransformationMatrix m : transformations) {
                if (!m.ndbChainId.equals(intChainID)) continue;
                Atom na = (Atom)a.clone();
                Matrix max2 = m.getMatrix();
                AtomImpl vector = new AtomImpl();
                vector.setCoords(m.getVector());
                Calc.rotate(na, max2);
                Calc.shift(na, (Atom)vector);
                double[] transformedCoordinate = new double[3];
                transformedCoordinate = na.getCoords();
                if (transformedCoordinate[0] < coordinateBounds[0][0]) {
                    coordinateBounds[0][0] = transformedCoordinate[0];
                }
                if (transformedCoordinate[1] < coordinateBounds[0][1]) {
                    coordinateBounds[0][1] = transformedCoordinate[1];
                }
                if (transformedCoordinate[2] < coordinateBounds[0][2]) {
                    coordinateBounds[0][2] = transformedCoordinate[2];
                }
                if (transformedCoordinate[0] > coordinateBounds[1][0]) {
                    coordinateBounds[1][0] = transformedCoordinate[0];
                }
                if (transformedCoordinate[1] > coordinateBounds[1][1]) {
                    coordinateBounds[1][1] = transformedCoordinate[1];
                }
                if (!(transformedCoordinate[2] > coordinateBounds[1][2])) continue;
                coordinateBounds[1][2] = transformedCoordinate[2];
            }
        }
        return coordinateBounds;
    }

    public static double[][] getAtomCoordinateBounds(Structure s) {
        Atom[] atoms = StructureTools.getAllAtomArray(s);
        int atomCount = atoms.length;
        double[][] coordinateBounds = new double[2][3];
        if (atomCount <= 0) {
            return coordinateBounds;
        }
        Atom a = atoms[0];
        coordinateBounds[0][0] = a.getX();
        coordinateBounds[0][1] = a.getY();
        coordinateBounds[0][2] = a.getZ();
        coordinateBounds[1][0] = a.getX();
        coordinateBounds[1][1] = a.getY();
        coordinateBounds[1][2] = a.getZ();
        for (int i = 1; i < atomCount; ++i) {
            a = atoms[i];
            if (a.getX() < coordinateBounds[0][0]) {
                coordinateBounds[0][0] = a.getX();
            }
            if (a.getY() < coordinateBounds[0][1]) {
                coordinateBounds[0][1] = a.getY();
            }
            if (a.getZ() < coordinateBounds[0][2]) {
                coordinateBounds[0][2] = a.getZ();
            }
            if (a.getX() > coordinateBounds[1][0]) {
                coordinateBounds[1][0] = a.getX();
            }
            if (a.getY() > coordinateBounds[1][1]) {
                coordinateBounds[1][1] = a.getY();
            }
            if (!(a.getZ() > coordinateBounds[1][2])) continue;
            coordinateBounds[1][2] = a.getZ();
        }
        return coordinateBounds;
    }

    public static double getMaximumExtend(Structure structure) {
        double[][] bounds = BioAssemblyTools.getAtomCoordinateBounds(structure);
        double xMax = Math.abs(bounds[0][0] - bounds[1][0]);
        double yMax = Math.abs(bounds[0][1] - bounds[1][1]);
        double zMax = Math.abs(bounds[0][2] - bounds[1][2]);
        return Math.max(xMax, Math.max(yMax, zMax));
    }

    public static double getBiologicalMoleculeMaximumExtend(Structure structure, List<ModelTransformationMatrix> transformations) {
        double[][] bounds = BioAssemblyTools.getBiologicalMoleculeBounds(structure, transformations);
        double xMax = Math.abs(bounds[0][0] - bounds[1][0]);
        double yMax = Math.abs(bounds[0][1] - bounds[1][1]);
        double zMax = Math.abs(bounds[0][2] - bounds[1][2]);
        return Math.max(xMax, Math.max(yMax, zMax));
    }

    public static double[] getBiologicalMoleculeCentroid(Structure asymUnit, List<ModelTransformationMatrix> transformations) throws IllegalArgumentException {
        if (asymUnit == null) {
            throw new IllegalArgumentException("null structure");
        }
        Atom[] atoms = StructureTools.getAllAtomArray(asymUnit);
        int atomCount = atoms.length;
        double[] centroid = new double[3];
        if (atomCount <= 0) {
            return centroid;
        }
        if (transformations.size() == 0) {
            return Calc.getCentroid(atoms).getCoords();
        }
        int count2 = 0;
        double[] transformedCoordinate = new double[3];
        for (int i = 0; i < atomCount; ++i) {
            Atom atom = atoms[i];
            Chain chain2 = atom.getGroup().getChain();
            String intChainID = chain2.getInternalChainID();
            if (intChainID == null) {
                intChainID = chain2.getChainID();
            }
            for (ModelTransformationMatrix m : transformations) {
                if (!m.ndbChainId.equals(intChainID)) continue;
                m.transformPoint(atom.getCoords(), transformedCoordinate);
                centroid[0] = centroid[0] + transformedCoordinate[0];
                centroid[1] = centroid[1] + transformedCoordinate[1];
                centroid[2] = centroid[2] + transformedCoordinate[2];
                ++count2;
            }
        }
        centroid[0] = centroid[0] / (double)count2;
        centroid[1] = centroid[1] / (double)count2;
        centroid[2] = centroid[2] / (double)count2;
        return centroid;
    }

    public static Structure getReducedCAStructure(Structure orig) {
        StructureImpl s = new StructureImpl();
        s.setHeader(orig.getHeader());
        s.setPDBHeader(orig.getPDBHeader());
        for (Chain c : orig.getChains()) {
            ChainImpl c1 = new ChainImpl();
            c1.setChainID(c.getChainID());
            s.addChain(c1);
            for (Group g : c.getAtomGroups()) {
                try {
                    Atom a = g.getAtom(" CA ");
                    if (a == null) continue;
                    Group g1 = (Group)g.clone();
                    g1.clearAtoms();
                    g1.addAtom(a);
                    c1.addGroup(g1);
                }
                catch (Exception e) {}
            }
        }
        return s;
    }
}

