/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.AtomImpl;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.ResidueNumber;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.model.AFP;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.bio.structure.align.xml.AFPChainFlipper;
import org.biojava.bio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.bio.structure.jama.Matrix;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class AFPChainXMLParser {
    public static AFPChain fromXML(String xml, String name1, String name2, Atom[] ca1, Atom[] ca2) throws StructureException {
        AFPChain[] afps = AFPChainXMLParser.parseMultiXML(xml);
        if (afps.length > 0) {
            AFPChain afpChain = afps[0];
            String n1 = afpChain.getName1();
            String n2 = afpChain.getName2();
            if (n1 == null) {
                n1 = "";
            }
            if (n2 == null) {
                n2 = "";
            }
            if (n1.equals(name2) && n2.equals(name1)) {
                afpChain = AFPChainFlipper.flipChain(afpChain);
            }
            AFPChainXMLParser.rebuildAFPChain(afpChain, ca1, ca2);
            return afpChain;
        }
        return null;
    }

    public static AFPChain fromXML(String xml, Atom[] ca1, Atom[] ca2) {
        AFPChain[] afps = AFPChainXMLParser.parseMultiXML(xml);
        if (afps.length > 0) {
            AFPChain afpChain = afps[0];
            AFPChainXMLParser.rebuildAFPChain(afpChain, ca1, ca2);
            return afpChain;
        }
        return null;
    }

    public static boolean isErrorXML(String xml) {
        return xml.contains("error=\"");
    }

    public static String flipAlignment(String xml) throws IOException, StructureException {
        AFPChain[] afps = AFPChainXMLParser.parseMultiXML(xml);
        if (afps.length < 1) {
            return null;
        }
        if (afps.length == 1) {
            AFPChain newChain = AFPChainFlipper.flipChain(afps[0]);
            if (newChain.getAlgorithmName() == null) {
                newChain.setAlgorithmName("jFatCat_rigid");
            }
            return AFPChainXMLConverter.toXML(newChain);
        }
        throw new StructureException("not Implemented yet!");
    }

    public static void rebuildAFPChain(AFPChain afpChain, Atom[] ca1, Atom[] ca2) {
        if (afpChain.getAlgorithmName() == null) {
            afpChain.setAlgorithmName("jFatCat_rigid");
        }
        if (afpChain.getVersion() == null) {
            afpChain.setVersion("1.0");
        }
        int blockNum = afpChain.getBlockNum();
        int ca1Length = afpChain.getCa1Length();
        int ca2Length = afpChain.getCa2Length();
        int minLength = Math.min(ca1Length, ca2Length);
        int[][][] optAln = new int[blockNum][2][minLength];
        int[][][] blockResList = afpChain.getBlockResList();
        if (blockResList == null) {
            blockResList = new int[blockNum][2][minLength];
        }
        int[] optLen = afpChain.getOptLen();
        String[][][] pdbAln = afpChain.getPdbAln();
        int[] verifiedOptLen = null;
        if (optLen != null) {
            verifiedOptLen = (int[])afpChain.getOptLen().clone();
        } else {
            System.err.println("did not find optimal alignment, building up empty alignment.");
            optLen = new int[]{0};
        }
        for (int blockNr = 0; blockNr < blockNum; ++blockNr) {
            int verifiedEQR = -1;
            for (int eqrNr = 0; eqrNr < optLen[blockNr]; ++eqrNr) {
                String pdbResnum1 = pdbAln[blockNr][0][eqrNr];
                String pdbResnum2 = pdbAln[blockNr][1][eqrNr];
                String[] spl1 = pdbResnum1.split(":");
                String[] spl2 = pdbResnum2.split(":");
                String chain1 = spl1[0];
                String pdbres1 = spl1[1];
                String chain2 = spl2[0];
                String pdbres2 = spl2[1];
                int pos1 = AFPChainXMLParser.getPositionForPDBresunm(pdbres1, chain1, ca1);
                int pos2 = AFPChainXMLParser.getPositionForPDBresunm(pdbres2, chain2, ca2);
                if (pos1 == -1 || pos2 == -1) {
                    System.err.println("AFPChainXMLParser: warning: pos1: " + pos1 + " " + pdbResnum1 + " pos2: " + pos2 + " " + pdbResnum2 + " should never be -1. Probably parsing an.");
                    int n = blockNr;
                    verifiedOptLen[n] = verifiedOptLen[n] - 1;
                    continue;
                }
                optAln[blockNr][0][++verifiedEQR] = pos1;
                optAln[blockNr][1][verifiedEQR] = pos2;
                blockResList[blockNr][0][verifiedEQR] = pos1;
                blockResList[blockNr][1][verifiedEQR] = pos2;
            }
        }
        afpChain.setOptLen(verifiedOptLen);
        afpChain.setOptAln(optAln);
        afpChain.setBlockResList(blockResList);
        AFPAlignmentDisplay.getAlign(afpChain, ca1, ca2);
    }

    public static AFPChain[] parseMultiXML(String xml) {
        ArrayList<AFPChain> afpChains = new ArrayList<AFPChain>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(inStream);
            doc.getDocumentElement().normalize();
            NodeList listOfAFPChains = doc.getElementsByTagName("AFPChain");
            for (int afpPos = 0; afpPos < listOfAFPChains.getLength(); ++afpPos) {
                String version;
                AFPChain a = new AFPChain();
                a.setAlgorithmName("jFatCat_rigid");
                a.setVersion("1.0");
                Node rootElement = listOfAFPChains.item(afpPos);
                a.setName1(AFPChainXMLParser.getAttribute(rootElement, "name1"));
                a.setName2(AFPChainXMLParser.getAttribute(rootElement, "name2"));
                String algoname = AFPChainXMLParser.getAttribute(rootElement, "method");
                if (algoname != null) {
                    a.setAlgorithmName(algoname);
                }
                if ((version = AFPChainXMLParser.getAttribute(rootElement, "version")) != null) {
                    a.setVersion(version);
                }
                a.setAlnLength(new Integer(AFPChainXMLParser.getAttribute(rootElement, "alnLength")));
                a.setBlockNum(new Integer(AFPChainXMLParser.getAttribute(rootElement, "blockNum")));
                a.setGapLen(new Integer(AFPChainXMLParser.getAttribute(rootElement, "gapLen")));
                a.setOptLength(new Integer(AFPChainXMLParser.getAttribute(rootElement, "optLength")));
                a.setTotalLenIni(new Integer(AFPChainXMLParser.getAttribute(rootElement, "totalLenIni")));
                a.setBlockNum(new Integer(AFPChainXMLParser.getAttribute(rootElement, "blockNum")));
                if (a.getAlgorithmName().equals("jCE Circular Permutation")) {
                    a.setSequentialAlignment(a.getBlockNum() == 1);
                }
                a.setAlignScore(new Double(AFPChainXMLParser.getAttribute(rootElement, "alignScore")));
                a.setChainRmsd(new Double(AFPChainXMLParser.getAttribute(rootElement, "chainRmsd")));
                Double identity = (double)new Double(AFPChainXMLParser.getAttribute(rootElement, "identity"));
                a.setIdentity(identity);
                a.setNormAlignScore(new Double(AFPChainXMLParser.getAttribute(rootElement, "normAlignScore")));
                a.setProbability(new Double(AFPChainXMLParser.getAttribute(rootElement, "probability")));
                a.setSimilarity(new Double(AFPChainXMLParser.getAttribute(rootElement, "similarity")));
                a.setTotalRmsdIni(new Double(AFPChainXMLParser.getAttribute(rootElement, "totalRmsdIni")));
                a.setTotalRmsdOpt(new Double(AFPChainXMLParser.getAttribute(rootElement, "totalRmsdOpt")));
                a.setAlignScoreUpdate(new Double(AFPChainXMLParser.getAttribute(rootElement, "alignScoreUpdate")));
                int ca1Length = new Integer(AFPChainXMLParser.getAttribute(rootElement, "ca1Length"));
                a.setCa1Length(ca1Length);
                int ca2Length = new Integer(AFPChainXMLParser.getAttribute(rootElement, "ca2Length"));
                a.setCa2Length(ca2Length);
                String tmScoreS = AFPChainXMLParser.getAttribute(rootElement, "tmScore");
                if (tmScoreS != null) {
                    Double tmScore = null;
                    try {
                        tmScore = Double.parseDouble(tmScoreS);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    a.setTMScore(tmScore);
                }
                String calcTimeS = AFPChainXMLParser.getAttribute(rootElement, "time");
                Long calcTime = -1L;
                if (calcTimeS != null) {
                    try {
                        calcTime = Long.parseLong(calcTimeS);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                a.setCalculationTime(calcTime);
                Matrix[] ms = new Matrix[a.getBlockNum()];
                a.setBlockRotationMatrix(ms);
                Atom[] blockShiftVector = new Atom[a.getBlockNum()];
                a.setBlockShiftVector(blockShiftVector);
                int afpNum = new Integer(AFPChainXMLParser.getAttribute(rootElement, "afpNum"));
                ArrayList<AFP> afpSet = new ArrayList<AFP>();
                for (int afp = 0; afp < afpNum; ++afp) {
                    afpSet.add(new AFP());
                }
                a.setAfpSet(afpSet);
                int minLength = Math.min(ca1Length, ca2Length);
                a.setFocusRes1(new int[minLength]);
                a.setFocusRes2(new int[minLength]);
                NodeList listOfBlocks = rootElement.getChildNodes();
                for (int i = 0; i < listOfBlocks.getLength(); ++i) {
                    Node block = listOfBlocks.item(i);
                    if (!block.getNodeName().equals("block")) continue;
                    AFPChainXMLParser.processBlock(block, a, minLength);
                }
                afpChains.add(a);
            }
        }
        catch (SAXParseException err2) {
            System.out.println("** Parsing error, line " + err2.getLineNumber() + ", uri " + err2.getSystemId());
            System.out.println(" " + err2.getMessage());
        }
        catch (SAXException e) {
            Exception x2 = e.getException();
            (x2 == null ? e : x2).printStackTrace();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
        }
        return afpChains.toArray(new AFPChain[afpChains.size()]);
    }

    private static void processBlock(Node block, AFPChain a, int minLength) {
        double thisBlockRmsd;
        double thisBlockScore;
        int thisBlockSize;
        int thisBlockGap;
        double[] blockRmsd;
        double[] blockScore;
        int[] blockSize;
        int[] blockGap;
        String[][][] pdbAln;
        NodeList valList = block.getChildNodes();
        int numChildren = valList.getLength();
        NamedNodeMap map2 = block.getAttributes();
        int blockNum = a.getBlockNum();
        int[] optLen = a.getOptLen();
        if (optLen == null) {
            optLen = new int[blockNum];
        }
        if ((pdbAln = a.getPdbAln()) == null) {
            pdbAln = new String[blockNum][2][minLength];
        }
        if ((blockGap = a.getBlockGap()) == null) {
            blockGap = new int[blockNum];
        }
        if ((blockSize = a.getBlockSize()) == null) {
            blockSize = new int[blockNum];
        }
        if ((blockScore = a.getBlockScore()) == null) {
            blockScore = new double[blockNum];
        }
        if ((blockRmsd = a.getBlockRmsd()) == null) {
            blockRmsd = new double[blockNum];
        }
        Matrix[] ms = a.getBlockRotationMatrix();
        Atom[] shifts = a.getBlockShiftVector();
        int blockNr = new Integer(map2.getNamedItem("blockNr").getTextContent());
        blockGap[blockNr] = thisBlockGap = new Integer(map2.getNamedItem("blockGap").getTextContent()).intValue();
        blockSize[blockNr] = thisBlockSize = new Integer(map2.getNamedItem("blockSize").getTextContent()).intValue();
        blockScore[blockNr] = thisBlockScore = new Double(map2.getNamedItem("blockScore").getTextContent()).doubleValue();
        blockRmsd[blockNr] = thisBlockRmsd = new Double(map2.getNamedItem("blockRmsd").getTextContent()).doubleValue();
        int nrEqr = 0;
        for (int e = 0; e < numChildren; ++e) {
            Node eqr = valList.item(e);
            if (!eqr.hasAttributes()) continue;
            if (eqr.getNodeName().equals("eqr")) {
                ++nrEqr;
                NamedNodeMap atts = eqr.getAttributes();
                int eqrNr = new Integer(atts.getNamedItem("eqrNr").getTextContent());
                String pdbres1 = atts.getNamedItem("pdbres1").getTextContent();
                String chain1 = atts.getNamedItem("chain1").getTextContent();
                String pdbres2 = atts.getNamedItem("pdbres2").getTextContent();
                String chain2 = atts.getNamedItem("chain2").getTextContent();
                pdbAln[blockNr][0][eqrNr] = chain1 + ":" + pdbres1;
                pdbAln[blockNr][1][eqrNr] = chain2 + ":" + pdbres2;
                continue;
            }
            if (eqr.getNodeName().equals("matrix")) {
                Matrix m = new Matrix(3, 3);
                for (int i = 1; i <= 3; ++i) {
                    for (int j = 1; j <= 3; ++j) {
                        String att = AFPChainXMLParser.getAttribute(eqr, "mat" + i + j);
                        double val = Double.parseDouble(att);
                        m.set(i - 1, j - 1, val);
                    }
                }
                ms[blockNr] = m;
                continue;
            }
            if (!eqr.getNodeName().equals("shift")) continue;
            AtomImpl shift = new AtomImpl();
            double x2 = Double.parseDouble(AFPChainXMLParser.getAttribute(eqr, "x"));
            double y = Double.parseDouble(AFPChainXMLParser.getAttribute(eqr, "y"));
            double z = Double.parseDouble(AFPChainXMLParser.getAttribute(eqr, "z"));
            shift.setX(x2);
            shift.setY(y);
            shift.setZ(z);
            shifts[blockNr] = shift;
        }
        optLen[blockNr] = nrEqr;
        a.setOptLen(optLen);
        a.setPdbAln(pdbAln);
        a.setBlockGap(blockGap);
        a.setBlockSize(blockSize);
        a.setBlockScore(blockScore);
        a.setBlockRmsd(blockRmsd);
    }

    private static String getAttribute(Node node, String attr) {
        if (!node.hasAttributes()) {
            return null;
        }
        NamedNodeMap atts = node.getAttributes();
        if (atts == null) {
            return null;
        }
        Node att = atts.getNamedItem(attr);
        if (att == null) {
            return null;
        }
        String value2 = att.getTextContent();
        return value2;
    }

    private static int getPositionForPDBresunm(String pdbresnum, String chainId, Atom[] atoms) {
        ResidueNumber residueNumber = ResidueNumber.fromString(pdbresnum);
        residueNumber.setChainId(chainId);
        for (int i = 0; i < atoms.length; ++i) {
            Chain c;
            Group g = atoms[i].getGroup();
            if (!g.getResidueNumber().equals(residueNumber) || !(c = g.getChain()).getChainID().equals(chainId)) continue;
            return i;
        }
        return -1;
    }
}

