/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.util;

import java.lang.reflect.Array;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Calc;
import org.biojava.bio.structure.SVDSuperimposer;
import org.biojava.bio.structure.StructureException;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.jama.Matrix;

public class AFPChainScorer {
    public static double getTMScore(AFPChain align, Atom[] ca1, Atom[] ca2) throws StructureException {
        if (align.getNrEQR() == 0) {
            return -1.0;
        }
        Atom[] ca1aligned = new Atom[align.getOptLength()];
        Atom[] ca2aligned = new Atom[align.getOptLength()];
        int pos = 0;
        int[] blockLens = align.getOptLen();
        int[][][] optAln = align.getOptAln();
        assert (align.getBlockNum() <= optAln.length);
        for (int block = 0; block < align.getBlockNum(); ++block) {
            if (blockLens[block] > optAln[block][0].length) {
                System.err.println("AFPChainScorer getTMScore: errors reconstructing alignment block [" + block + "]. Length is " + blockLens[block] + " but should be <=" + optAln[block][0].length);
            }
            for (int i = 0; i < blockLens[block]; ++i) {
                int pos1 = optAln[block][0][i];
                int pos2 = optAln[block][1][i];
                Atom a1 = ca1[pos1];
                Atom a2 = (Atom)ca2[pos2].clone();
                ca1aligned[pos] = a1;
                ca2aligned[pos] = a2;
                ++pos;
            }
        }
        if (pos != align.getOptLength()) {
            System.err.println("AFPChainScorer getTMScore: Problems reconstructing alignment! nr of loaded atoms is " + pos + " but should be " + align.getOptLength());
            ca1aligned = (Atom[])AFPChainScorer.resizeArray(ca1aligned, pos);
            ca2aligned = (Atom[])AFPChainScorer.resizeArray(ca2aligned, pos);
        }
        SVDSuperimposer svd = new SVDSuperimposer(ca1aligned, ca2aligned);
        Matrix matrix = svd.getRotation();
        Atom shift = svd.getTranslation();
        for (Atom a : ca2aligned) {
            Calc.rotate(a, matrix);
            Calc.shift(a, shift);
        }
        return SVDSuperimposer.getTMScore(ca1aligned, ca2aligned, ca1.length, ca2.length);
    }

    private static Object resizeArray(Object oldArray, int newSize) {
        int oldSize = Array.getLength(oldArray);
        Class<?> elementType = oldArray.getClass().getComponentType();
        Object newArray = Array.newInstance(elementType, newSize);
        int preserveLength = Math.min(oldSize, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }
}

