/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure.align.ce;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.StructureTools;
import org.biojava.bio.structure.align.MultiThreadedDBSearch;
import org.biojava.bio.structure.align.StructureAlignment;
import org.biojava.bio.structure.align.ce.GuiWrapper;
import org.biojava.bio.structure.align.ce.StartupParameters;
import org.biojava.bio.structure.align.ce.UserArgumentProcessor;
import org.biojava.bio.structure.align.model.AFPChain;
import org.biojava.bio.structure.align.util.AFPAlignmentDisplay;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.align.util.CliTools;
import org.biojava.bio.structure.align.util.ConfigurationException;
import org.biojava.bio.structure.align.util.ResourceManager;
import org.biojava.bio.structure.align.util.UserConfiguration;
import org.biojava.bio.structure.align.xml.AFPChainXMLConverter;
import org.biojava.bio.structure.io.PDBFileReader;

public abstract class AbstractUserArgumentProcessor
implements UserArgumentProcessor {
    public static String newline = System.getProperty("line.separator");
    protected StartupParameters params = new StartupParameters();
    public static final List<String> mandatoryArgs = new ArrayList<String>();
    public static final String PDB_DIR = "PDB_DIR";
    public static final String CACHE_DIR = "PDB_CACHE_DIR";

    protected AbstractUserArgumentProcessor() {
    }

    public abstract StructureAlignment getAlgorithm();

    public abstract Object getParameters();

    public abstract String getDbSearchLegend();

    @Override
    public void process(String[] argv) {
        AbstractUserArgumentProcessor.printAboutMe();
        List<String> mandatoryArgs = this.getMandatoryArgs();
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            String value2 = null;
            if (i < argv.length - 1) {
                value2 = argv[i + 1];
            }
            if (value2 != null && value2.startsWith("-")) {
                value2 = null;
            } else {
                ++i;
            }
            String[] tmp = new String[]{arg, value2};
            try {
                CliTools.configureBean(this.params, tmp);
                continue;
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                if (!mandatoryArgs.contains(arg)) continue;
                return;
            }
        }
        if (this.params.getPdbFilePath() != null) {
            System.setProperty(PDB_DIR, this.params.getPdbFilePath());
        }
        if (this.params.getCacheFilePath() != null) {
            System.setProperty(CACHE_DIR, this.params.getCacheFilePath());
        }
        if (this.params.isShowMenu()) {
            System.err.println("showing menu...");
            try {
                GuiWrapper.showAlignmentGUI();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        if (this.params.getShowDBresult() != null) {
            System.err.println("showing DB results...");
            try {
                GuiWrapper.showDBResults(this.params);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
        String pdb1 = this.params.getPdb1();
        String file1 = this.params.getFile1();
        if (pdb1 != null || file1 != null) {
            this.runPairwise();
        }
        if (this.params.getAlignPairs() != null) {
            this.runDBSearch();
        }
        if (this.params.getSearchFile() != null) {
            this.runDBSearch();
        }
    }

    public static void printAboutMe() {
        try {
            ResourceManager about = ResourceManager.getResourceManager("about");
            String version = about.getString("project_version");
            String build = about.getString("build");
            System.out.println("Protein Comparison Tool " + version + " " + build);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runDBSearch() {
        String cacheFilePath;
        String pdbFilePath = this.params.getPdbFilePath();
        if (pdbFilePath == null || pdbFilePath.equals("")) {
            System.err.println("You did not specify the -pdbFilePath. Can not find PDB files in file system and will assume a temporary location.");
            UserConfiguration c = new UserConfiguration();
            pdbFilePath = c.getPdbFilePath();
        }
        if ((cacheFilePath = this.params.getCacheFilePath()) == null || cacheFilePath.equals("")) {
            cacheFilePath = pdbFilePath;
        }
        AtomCache cache = new AtomCache(pdbFilePath, this.params.isPdbDirSplit());
        String alignPairs = this.params.getAlignPairs();
        String searchFile = this.params.getSearchFile();
        if ((alignPairs == null || alignPairs.equals("")) && (searchFile == null || searchFile.equals(""))) {
            System.err.println("Please specify -alignPairs or -searchFile !");
            return;
        }
        String outputFile = this.params.getOutFile();
        if (outputFile == null || outputFile.equals("")) {
            System.err.println("Please specify the mandatory argument -outFile!");
            return;
        }
        System.out.println("running DB search with parameters: " + this.params);
        if (alignPairs != null && !alignPairs.equals("")) {
            this.runAlignPairs(cache, alignPairs, outputFile);
        } else {
            int useNrCPUs = this.params.getNrCPU();
            this.runDbSearch(cache, searchFile, outputFile, useNrCPUs, this.params);
        }
    }

    private void runDbSearch(AtomCache cache, String searchFile, String outputFile, int useNrCPUs, StartupParameters params) {
        System.out.println("will use " + useNrCPUs + " CPUs.");
        PDBFileReader reader = new PDBFileReader();
        Structure structure1 = null;
        try {
            structure1 = reader.getStructure(searchFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("could not parse as PDB file: " + searchFile);
            return;
        }
        File searchF = new File(searchFile);
        String name1 = "CUSTOM";
        StructureAlignment algorithm = this.getAlgorithm();
        MultiThreadedDBSearch dbSearch = new MultiThreadedDBSearch(name1, structure1, outputFile, algorithm, useNrCPUs, params.isDomainSplit());
        dbSearch.setCustomFile1(searchF.getAbsolutePath());
        dbSearch.run();
    }

    private void runAlignPairs(AtomCache cache, String alignPairs, String outputFile) {
        try {
            File f2 = new File(alignPairs);
            BufferedReader is = new BufferedReader(new InputStreamReader(new FileInputStream(f2)));
            BufferedWriter out = new BufferedWriter(new FileWriter(outputFile, true));
            StructureAlignment algorithm = this.getAlgorithm();
            String header = "# algorithm:" + algorithm.getAlgorithmName();
            out.write(header);
            out.write(newline);
            out.write("#Legend: " + newline);
            String legend = this.getDbSearchLegend();
            out.write(legend + newline);
            System.out.println(legend);
            String line = null;
            while ((line = is.readLine()) != null) {
                if (line.startsWith("#")) continue;
                String[] spl = line.split(" ");
                if (spl.length != 2) {
                    System.err.println("wrongly formattted line. Expected format: 4hhb.A 4hhb.B but found " + line);
                    continue;
                }
                String pdb1 = spl[0];
                String pdb2 = spl[1];
                Structure structure1 = cache.getStructure(pdb1);
                Structure structure2 = cache.getStructure(pdb2);
                Atom[] ca1 = StructureTools.getAtomCAArray(structure1);
                Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
                Object jparams = this.getParameters();
                AFPChain afpChain = algorithm.align(ca1, ca2, jparams);
                afpChain.setName1(pdb1);
                afpChain.setName2(pdb2);
                String result2 = this.getDbSearchResult(afpChain);
                out.write(result2);
                System.out.print(result2);
                this.checkWriteFile(afpChain, ca1, ca2, true);
            }
            out.close();
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void runPairwise() {
        String name1 = this.params.getPdb1();
        String file1 = this.params.getFile1();
        if (name1 == null && file1 == null) {
            throw new RuntimeException("You did not specify the -pdb1 or -file1 parameter. Can not find query PDB id for alignment.");
        }
        if (file1 == null && name1.length() < 4) {
            throw new RuntimeException("-pdb1 does not look like a PDB ID. Please specify PDB code or PDB.chainId.");
        }
        String name2 = this.params.getPdb2();
        String file2 = this.params.getFile2();
        if (name2 == null && file2 == null) {
            throw new RuntimeException("You did not specify the -pdb2 or -file2 parameter. Can not find target PDB id for alignment.");
        }
        if (file2 == null && name2.length() < 4) {
            throw new RuntimeException("-pdb2 does not look like a PDB ID. Please specify PDB code or PDB.chainId.");
        }
        Structure structure1 = null;
        Structure structure2 = null;
        String path = this.params.getPdbFilePath();
        if (file1 == null || file2 == null) {
            if (path == null) {
                System.err.println("You did not specify the -pdbFilePath parameter. Can not find the PDB files in your file system and assuming a temporary location.");
                UserConfiguration c = new UserConfiguration();
                path = c.getPdbFilePath();
            }
            AtomCache cache = new AtomCache(path, this.params.isPdbDirSplit());
            cache.setAutoFetch(this.params.isAutoFetch());
            structure1 = this.getStructure(cache, name1, file1);
            structure2 = this.getStructure(cache, name2, file2);
        } else {
            structure1 = this.getStructure(null, name1, file1);
            structure2 = this.getStructure(null, name2, file2);
        }
        if (structure1 == null) {
            System.err.println("structure 1 is null, can't run alignment.");
            return;
        }
        if (structure2 == null) {
            System.err.println("structure 2 is null, can't run alignment.");
            return;
        }
        if (name1 == null) {
            name1 = structure1.getName();
        }
        if (name2 == null) {
            name2 = structure2.getName();
        }
        try {
            Atom[] ca1 = StructureTools.getAtomCAArray(structure1);
            Atom[] ca2 = StructureTools.getAtomCAArray(structure2);
            StructureAlignment algorithm = this.getAlgorithm();
            Object jparams = this.getParameters();
            AFPChain afpChain = algorithm.align(ca1, ca2, jparams);
            afpChain.setName1(name1);
            afpChain.setName2(name2);
            if (this.params.isShow3d()) {
                if (!GuiWrapper.isGuiModuleInstalled()) {
                    System.err.println("The biojava-structure-gui module is not installed. Please install!");
                } else {
                    try {
                        Object jmol = GuiWrapper.display(afpChain, ca1, ca2);
                        GuiWrapper.showAlignmentImage(afpChain, ca1, ca2, jmol);
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
            this.checkWriteFile(afpChain, ca1, ca2, false);
            if (this.params.isPrintXML()) {
                String fatcatXML = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
                System.out.println(fatcatXML);
            }
            if (this.params.isPrintFatCat()) {
                System.out.println(afpChain.toFatcat(ca1, ca2));
            }
            if (this.params.isPrintCE()) {
                System.out.println(afpChain.toCE(ca1, ca2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkWriteFile(AFPChain afpChain, Atom[] ca1, Atom[] ca2, boolean dbsearch) throws Exception {
        String output2 = null;
        if (this.params.isOutputPDB()) {
            if (!GuiWrapper.isGuiModuleInstalled()) {
                System.err.println("The biojava-structure-gui module is not installed. Please install!");
                output2 = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
            } else {
                Structure tmp = AFPAlignmentDisplay.createArtificalStructure(afpChain, ca1, ca2);
                output2 = "TITLE  " + afpChain.getAlgorithmName() + " " + afpChain.getVersion() + " ";
                output2 = output2 + afpChain.getName1() + " vs. " + afpChain.getName2();
                output2 = output2 + newline;
                output2 = output2 + tmp.toPDB();
            }
        } else if (this.params.getOutFile() != null) {
            output2 = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
        } else if (this.params.getSaveOutputDir() != null) {
            output2 = AFPChainXMLConverter.toXML(afpChain, ca1, ca2);
        }
        if (output2 == null) {
            return;
        }
        String fileName = null;
        if (dbsearch) {
            if (this.params.getSaveOutputDir() == null) return;
            if (afpChain.getName1().startsWith("file:") || afpChain.getName2().startsWith("file:")) {
                return;
            }
            fileName = this.params.getSaveOutputDir();
            fileName = fileName + this.getAutoFileName(afpChain);
        } else if (this.params.getOutFile() != null) {
            fileName = this.params.getOutFile();
        }
        if (fileName == null) {
            System.err.println("Can't write outputfile. Either provide a filename using -outFile or set -autoOutputFile to true .");
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(fileName);
            PrintStream p = new PrintStream(out);
            p.println(output2);
            p.close();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Error writing to file " + fileName);
        }
    }

    private String getAutoFileName(AFPChain afpChain) {
        String fileName = afpChain.getName1() + "_" + afpChain.getName2() + "_" + afpChain.getAlgorithmName();
        fileName = this.params.isOutputPDB() ? fileName + ".pdb" : fileName + ".xml";
        return fileName;
    }

    private Structure getStructure(AtomCache cache, String name1, String file) {
        PDBFileReader reader = new PDBFileReader();
        if (file != null) {
            try {
                URL url = new URL(file);
                System.out.println(url);
                Structure s = reader.getStructure(url);
                return this.fixStructureName(s, file);
            }
            catch (Exception e) {
                try {
                    System.err.println(e.getMessage());
                    File f2 = new File(file);
                    System.out.println("file from local " + f2.getAbsolutePath());
                    Structure s = reader.getStructure(f2);
                    return this.fixStructureName(s, file);
                }
                catch (Exception e2) {
                    System.err.println("general exception:" + e2.getMessage());
                    System.err.println("unable to load structure from " + file);
                    return null;
                }
            }
        }
        try {
            Structure s = cache.getStructure(name1);
            return s;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("unable to load structure from dir: " + cache.getPath() + "/" + name1);
            return null;
        }
    }

    private Structure fixStructureName(Structure s, String file) {
        if (s.getName() != null && !s.getName().equals("")) {
            return s;
        }
        s.setName(s.getPDBCode());
        if (s.getName() == null || s.getName().equals("")) {
            File f2 = new File(file);
            s.setName(f2.getName());
        }
        return s;
    }

    public List<String> getMandatoryArgs() {
        return mandatoryArgs;
    }

    public String getDbSearchResult(AFPChain afpChain) {
        return afpChain.toDBSearchResult();
    }
}

