/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.structure;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.structure.Atom;
import org.biojava.bio.structure.Bond;
import org.biojava.bio.structure.Element;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.PDBRecord;
import org.biojava.bio.structure.io.FileConvert;

public class AtomImpl
implements Atom,
Serializable,
PDBRecord {
    private static final long serialVersionUID = -2258364127420562883L;
    String name = null;
    String fullName = null;
    Element element = Element.R;
    double[] coords = new double[3];
    String pdbline = "";
    int pdbserial;
    double occupancy = 0.0;
    double tempfactor = 0.0;
    Character altLoc = new Character(' ');
    Group parent = null;
    long id;
    private List<Bond> bonds = new ArrayList<Bond>(0);

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setFullName(String s) {
        this.fullName = s;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setPDBserial(int i) {
        this.pdbserial = i;
    }

    @Override
    public int getPDBserial() {
        return this.pdbserial;
    }

    @Override
    public void setCoords(double[] c) {
        this.coords = c;
    }

    @Override
    public double[] getCoords() {
        return this.coords;
    }

    @Override
    public void setX(double x2) {
        this.coords[0] = x2;
    }

    @Override
    public void setY(double y) {
        this.coords[1] = y;
    }

    @Override
    public void setZ(double z) {
        this.coords[2] = z;
    }

    @Override
    public double getX() {
        return this.coords[0];
    }

    @Override
    public double getY() {
        return this.coords[1];
    }

    @Override
    public double getZ() {
        return this.coords[2];
    }

    @Override
    public void setAltLoc(Character c) {
        this.altLoc = c;
    }

    @Override
    public Character getAltLoc() {
        return this.altLoc;
    }

    @Override
    public void setPDBline(String s) {
        this.pdbline = s;
    }

    @Override
    public String getPDBline() {
        return this.pdbline;
    }

    public String toString() {
        String str = this.fullName + " (" + this.name + ") " + this.element + " " + this.pdbserial + " " + this.coords[0] + " " + this.coords[1] + " " + this.coords[2];
        return str;
    }

    @Override
    public void setOccupancy(double occu) {
        this.occupancy = occu;
    }

    @Override
    public double getOccupancy() {
        return this.occupancy;
    }

    @Override
    public void setTempFactor(double temp) {
        this.tempfactor = temp;
    }

    @Override
    public double getTempFactor() {
        return this.tempfactor;
    }

    @Override
    public Object clone() {
        AtomImpl n = new AtomImpl();
        n.setOccupancy(this.getOccupancy());
        n.setTempFactor(this.getTempFactor());
        n.setAltLoc(this.getAltLoc());
        double[] coords = this.getCoords();
        n.setX(coords[0]);
        n.setY(coords[1]);
        n.setZ(coords[2]);
        n.setPDBserial(this.getPDBserial());
        n.setFullName(this.getFullName());
        n.setName(this.getName());
        n.setElement(this.getElement());
        return n;
    }

    @Override
    public void setParent(Group parent) {
        this.setGroup(parent);
    }

    @Override
    public Group getParent() {
        return this.getGroup();
    }

    @Override
    public void setGroup(Group parent) {
        this.parent = parent;
    }

    @Override
    public Group getGroup() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element e) {
        this.element = e;
    }

    @Override
    public String toPDB() {
        return FileConvert.toPDB(this);
    }

    @Override
    public void toPDB(StringBuffer buf) {
        FileConvert.toPDB(this, buf);
    }

    @Override
    public List<Bond> getBonds() {
        return this.bonds;
    }
}

