/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools.tabix;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import net.sf.samtools.tabix.TPair64;
import net.sf.samtools.tabix.TabixIndex;
import net.sf.samtools.tabix.TabixIterator;
import net.sf.samtools.util.BlockCompressedInputStream;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Variant;
import org.snpeff.util.Gpr;

public class TabixReader
implements Iterable<String> {
    private static int MAX_BIN = 37450;
    boolean debug = false;
    private String fileName;
    private BlockCompressedInputStream fileInputStream;
    private int mPreset;
    private int mSc;
    private int mBc;
    private int mEc;
    private int mMeta;
    private int mSkip;
    private String[] sequenceNames;
    private HashMap<String, Integer> sequenceName2tid;
    private TabixIndex[] tabixIndexes;
    private TabixIterator tabixIterator;
    protected boolean showHeader;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java -cp .:sam.jar TabixReader <in.gz> [region]");
            System.exit(1);
        }
        try {
            TabixReader tr = new TabixReader(args[0]);
            if (args.length == 1) {
                String s;
                while ((s = tr.readLine()) != null) {
                    System.out.println(s);
                }
            } else {
                String s;
                TabixIterator iter2 = tr.query(args[1]);
                while (iter2 != null && (s = iter2.next()) != null) {
                    System.out.println(s);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int readInt(InputStream is) throws IOException {
        byte[] buf = new byte[4];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long readLong(InputStream is) throws IOException {
        byte[] buf = new byte[8];
        is.read(buf);
        return ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private static int reg2bins(int beg, int _end, int[] list2) {
        int i = 0;
        int end = _end;
        if (beg >= end) {
            return 0;
        }
        if (end >= 0x20000000) {
            end = 0x20000000;
        }
        --end;
        list2[i++] = 0;
        int k = 1 + (beg >> 26);
        while (k <= 1 + (end >> 26)) {
            list2[i++] = k++;
        }
        k = 9 + (beg >> 23);
        while (k <= 9 + (end >> 23)) {
            list2[i++] = k++;
        }
        k = 73 + (beg >> 20);
        while (k <= 73 + (end >> 20)) {
            list2[i++] = k++;
        }
        k = 585 + (beg >> 17);
        while (k <= 585 + (end >> 17)) {
            list2[i++] = k++;
        }
        k = 4681 + (beg >> 14);
        while (k <= 4681 + (end >> 14)) {
            list2[i++] = k++;
        }
        return i;
    }

    public TabixReader(String fileName) throws IOException {
        this(fileName, false);
    }

    public TabixReader(String fileName, boolean debug) throws IOException {
        this.fileName = fileName;
        this.debug = debug;
        this.fileInputStream = new BlockCompressedInputStream(new File(fileName));
        this.readIndex();
    }

    protected int chr2tid(String chr) {
        if (this.sequenceName2tid.containsKey(chr)) {
            return this.sequenceName2tid.get(chr);
        }
        if (this.sequenceName2tid.containsKey(chr = Chromosome.simpleName(chr))) {
            return this.sequenceName2tid.get(chr);
        }
        return -1;
    }

    public void close() {
        if (this.fileInputStream != null) {
            try {
                this.fileInputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.fileInputStream = null;
        }
    }

    public long getFilePointer() {
        return this.fileInputStream.getFilePointer();
    }

    public int getmBc() {
        return this.mBc;
    }

    public int getmEc() {
        return this.mEc;
    }

    public int getmMeta() {
        return this.mMeta;
    }

    public int getmPreset() {
        return this.mPreset;
    }

    public int getmSc() {
        return this.mSc;
    }

    public TabixIterator iterator() {
        if (this.tabixIterator != null) {
            return this.tabixIterator;
        }
        TPair64[] off = new TPair64[]{new TPair64(0L, Long.MAX_VALUE)};
        this.tabixIterator = new TabixIterator(this, -1, 0, Integer.MAX_VALUE, off);
        this.tabixIterator.setShowHeader(this.showHeader);
        return this.tabixIterator;
    }

    public int[] parseReg(String reg) {
        String chr;
        int[] ret = new int[3];
        int colon2 = reg.indexOf(58);
        int hyphen = reg.indexOf(45);
        String string2 = chr = colon2 >= 0 ? reg.substring(0, colon2) : reg;
        ret[1] = colon2 >= 0 ? Integer.parseInt(reg.substring(colon2 + 1, hyphen >= 0 ? hyphen : reg.length())) - 1 : 0;
        ret[2] = hyphen >= 0 ? Integer.parseInt(reg.substring(hyphen + 1)) : Integer.MAX_VALUE;
        ret[0] = this.chr2tid(chr);
        return ret;
    }

    private TabixIterator query(int tid, int beg, int end) {
        TPair64[] chunks;
        int i;
        if (tid < 0) {
            return null;
        }
        TabixIndex idx = this.tabixIndexes[tid];
        int[] bins = new int[MAX_BIN];
        int numBins = TabixReader.reg2bins(beg, end, bins);
        long minFileOffset = idx.minOffset(beg);
        if (this.debug) {
            Gpr.debug("minFileOffset: " + minFileOffset);
        }
        int numChunks = 0;
        for (i = 0; i < numBins; ++i) {
            chunks = idx.get(bins[i]);
            if (chunks == null) continue;
            numChunks += chunks.length;
            if (!this.debug) continue;
            StringBuilder sb = new StringBuilder();
            for (TPair64 tp : chunks) {
                sb.append("\t\t" + tp + "\n");
            }
            Gpr.debug("\tnumChunks: " + numChunks + "\n" + sb);
        }
        if (numChunks == 0) {
            return null;
        }
        Object[] chunksOff = new TPair64[numChunks];
        numChunks = 0;
        for (i = 0; i < numBins; ++i) {
            chunks = idx.get(bins[i]);
            if (chunks == null) continue;
            for (int j = 0; j < chunks.length; ++j) {
                if (!TPair64.less64(minFileOffset, chunks[j].v)) continue;
                chunksOff[numChunks++] = new TPair64(chunks[j]);
            }
        }
        if (numChunks == 0) {
            return null;
        }
        Arrays.sort(chunksOff, 0, numChunks);
        int l = 0;
        for (i = 1; i < numChunks; ++i) {
            if (!TPair64.less64(((TPair64)chunksOff[l]).v, ((TPair64)chunksOff[i]).v)) continue;
            ((TPair64)chunksOff[++l]).u = ((TPair64)chunksOff[i]).u;
            ((TPair64)chunksOff[l]).v = ((TPair64)chunksOff[i]).v;
        }
        numChunks = l + 1;
        for (i = 1; i < numChunks; ++i) {
            if (TPair64.less64(((TPair64)chunksOff[i - 1]).v, ((TPair64)chunksOff[i]).u)) continue;
            ((TPair64)chunksOff[i - 1]).v = ((TPair64)chunksOff[i]).u;
        }
        l = 0;
        for (i = 1; i < numChunks; ++i) {
            if (((TPair64)chunksOff[l]).v >> 16 == ((TPair64)chunksOff[i]).u >> 16) {
                ((TPair64)chunksOff[l]).v = ((TPair64)chunksOff[i]).v;
                continue;
            }
            ((TPair64)chunksOff[++l]).u = ((TPair64)chunksOff[i]).u;
            ((TPair64)chunksOff[l]).v = ((TPair64)chunksOff[i]).v;
        }
        numChunks = l + 1;
        TPair64[] mergedChunks = new TPair64[numChunks];
        for (i = 0; i < numChunks; ++i) {
            mergedChunks[i] = new TPair64(((TPair64)chunksOff[i]).u, ((TPair64)chunksOff[i]).v);
        }
        return new TabixIterator(this, tid, beg, end, mergedChunks);
    }

    public TabixIterator query(String reg) {
        int[] x2 = this.parseReg(reg);
        this.tabixIterator = this.query(x2[0], x2[1], x2[2]);
        return this.tabixIterator;
    }

    public TabixIterator query(Variant variant) {
        TabixIterator tabixIterator;
        int tid = this.chr2tid(variant.getChromosomeName());
        int start = variant.getStart();
        int end = variant.getEnd() + 1;
        if (variant.isIns()) {
            --start;
        }
        if ((tabixIterator = this.query(tid, start, end)) != null) {
            tabixIterator.setDebug(this.debug);
        }
        if (this.debug) {
            Gpr.debug("Query: " + variant + "\ttabixIterator: " + tabixIterator);
        }
        return tabixIterator;
    }

    public void readIndex() throws IOException {
        this.readIndex(new File(this.fileName + ".tbi"));
    }

    public void readIndex(File fp) throws IOException {
        if (fp == null) {
            return;
        }
        BlockCompressedInputStream is = new BlockCompressedInputStream(fp);
        byte[] buf = new byte[4];
        is.read(buf, 0, 4);
        int numSeqs = TabixReader.readInt(is);
        this.sequenceNames = new String[numSeqs];
        this.sequenceName2tid = new HashMap();
        this.mPreset = TabixReader.readInt(is);
        this.mSc = TabixReader.readInt(is);
        this.mBc = TabixReader.readInt(is);
        this.mEc = TabixReader.readInt(is);
        this.mMeta = TabixReader.readInt(is);
        this.mSkip = TabixReader.readInt(is);
        if (this.debug) {
            Gpr.debug("Tabix index:\n\tNumber of sequences: " + numSeqs + "\n\tmPreset: " + this.mPreset + "\n\tmSc    : " + this.mSc + "\n\tmBc    : " + this.mBc + "\n\tmEc    : " + this.mEc + "\n\tmMeta  : " + this.mMeta + "\n\tmSkip  : " + this.mSkip);
        }
        int sequencesLength = TabixReader.readInt(is);
        buf = new byte[sequencesLength];
        is.read(buf);
        int j = 0;
        int tid = 0;
        for (int i = 0; i < buf.length; ++i) {
            if (buf[i] != 0) continue;
            byte[] b = new byte[i - j];
            System.arraycopy(buf, j, b, 0, b.length);
            String chrName = new String(b);
            if (this.debug) {
                Gpr.debug("sequenceNames[" + tid + "] = s: '" + chrName + "'");
            }
            this.sequenceName2tid.put(chrName, tid);
            this.sequenceName2tid.put(Chromosome.simpleName(chrName), tid);
            this.sequenceNames[tid++] = chrName;
            j = i + 1;
        }
        this.tabixIndexes = new TabixIndex[this.sequenceNames.length];
        for (int seqNum = 0; seqNum < this.sequenceNames.length; ++seqNum) {
            TabixIndex tabixIndex = new TabixIndex();
            tabixIndex.setDebug(this.debug);
            tabixIndex.readIndex(is);
            this.tabixIndexes[seqNum] = tabixIndex;
            if (!this.debug) continue;
            String txtfile = this.fileName + ".tabixIndex_" + this.sequenceNames[seqNum] + ".txt";
            Gpr.debug("Writing to file " + txtfile);
            Gpr.toFile(txtfile, this.tabixIndexes[seqNum]);
        }
        is.close();
    }

    public String readLine() throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        while ((c = this.fileInputStream.read()) >= 0 && c != 10) {
            buf.append((char)c);
        }
        if (c < 0) {
            return null;
        }
        return buf.toString();
    }

    void seek(long pos) throws IOException {
        if (this.debug) {
            Gpr.debug("seek(" + pos + ")");
        }
        this.fileInputStream.seek(pos);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tabixIndexes.length; ++i) {
            sb.append("TabixIndex[" + i + "]:\t" + this.tabixIndexes[i] + "\n");
        }
        return sb.toString();
    }
}

