/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.util.List;
import org.biojava.bio.structure.Chain;
import org.biojava.bio.structure.Group;
import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava.bio.structure.io.PDBFileReader;
import org.biojava.bio.structure.io.mmcif.AllChemCompProvider;
import org.biojava.bio.structure.io.mmcif.ChemCompGroupFactory;

public class DemoChangeChemCompProvider {
    public static void main(String[] args) {
        String pdbId = "1O1G";
        boolean loadChemComp = true;
        PDBFileReader reader = new PDBFileReader();
        if (loadChemComp) {
            AllChemCompProvider all = new AllChemCompProvider();
            ChemCompGroupFactory.setChemCompProvider(all);
        }
        DemoChangeChemCompProvider demo = new DemoChangeChemCompProvider();
        demo.basicLoad(reader, loadChemComp, pdbId);
    }

    public void basicLoad(PDBFileReader reader, boolean loadChemComp, String pdbId) {
        try {
            reader.setPdbDirectorySplit(true);
            reader.setAutoFetch(true);
            FileParsingParameters params = new FileParsingParameters();
            params.setAlignSeqRes(true);
            params.setLoadChemCompInfo(loadChemComp);
            params.setParseSecStruc(false);
            reader.setFileParsingParameters(params);
            Structure struc = reader.getStructureById(pdbId);
            this.printStructure(struc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void printStructure(Structure struc) {
        System.out.println(struc);
        String pdbid = struc.getPDBCode();
        for (int i = 0; i < struc.nrModels(); ++i) {
            for (Chain ch : struc.getModel(i)) {
                if (!ch.getChainID().equals("A")) continue;
                System.out.println(pdbid + ">>>" + ch.getChainID() + ">>>" + ch.getAtomSequence());
                System.out.println(pdbid + ">>>" + ch.getChainID() + ">>>" + ch.getSeqResSequence());
                List<Group> group = ch.getSeqResGroups();
                int seqPos = 0;
                for (Group gp : group) {
                    System.out.println(ch.getChainID() + ":" + seqPos + ":" + gp.getResidueNumber() + ":" + gp.getPDBName() + " " + gp.getType());
                    ++seqPos;
                }
            }
        }
    }
}

