/*
 * Decompiled with CFR 0.152.
 */
package demo;

import org.biojava.bio.structure.Structure;
import org.biojava.bio.structure.align.util.AtomCache;
import org.biojava.bio.structure.io.FileParsingParameters;
import org.biojava3.structure.StructureIO;

public class DemoAtomCache {
    public static void main(String[] args) {
        DemoAtomCache.demoAtomCache();
        DemoAtomCache.demoStructureIO();
    }

    private static void demoStructureIO() {
        try {
            Structure s1 = StructureIO.getStructure("4hhb");
            Structure structure = StructureIO.getBiologicalAssembly("1stp", 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void demoAtomCache() {
        String[] pdbIDs;
        AtomCache cache = new AtomCache();
        FileParsingParameters params = cache.getFileParsingParams();
        params.setLoadChemCompInfo(false);
        params.setAlignSeqRes(true);
        params.setHeaderOnly(false);
        params.setParseCAOnly(false);
        params.setParseSecStruc(false);
        for (String pdbID : pdbIDs = new String[]{"4hhb", "1cdg", "5pti", "1gav", "WRONGID"}) {
            try {
                Structure s = cache.getStructure(pdbID);
                if (s == null) {
                    System.out.println("could not find structure " + pdbID);
                    continue;
                }
                System.out.println(s);
            }
            catch (Exception e) {
                System.err.println("Can't load structure " + pdbID + " reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

