/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.util.lang;

import java.io.IOException;

public final class Hex {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static Appendable append(Appendable appendable, short s) {
        return Hex.append(appendable, (long)s, 4);
    }

    public static Appendable append(Appendable appendable, short s, int n) {
        return Hex.append(appendable, (long)s, n);
    }

    public static Appendable append(Appendable appendable, int n) {
        return Hex.append(appendable, (long)n, 8);
    }

    public static Appendable append(Appendable appendable, int n, int n2) {
        return Hex.append(appendable, (long)n, n2);
    }

    public static Appendable append(Appendable appendable, long l) {
        return Hex.append(appendable, l, 16);
    }

    public static Appendable append(Appendable appendable, long l, int n) {
        try {
            for (int i = (n << 2) - 4; i >= 0; i -= 4) {
                appendable.append(DIGITS[(byte)(l >> i) & 0xF]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public static Appendable append(Appendable appendable, byte[] byArray) {
        try {
            for (byte by2 : byArray) {
                appendable.append(DIGITS[(byte)((by2 & 0xF0) >> 4)]);
                appendable.append(DIGITS[(byte)(by2 & 0xF)]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return appendable;
    }

    public static long parseLong(CharSequence charSequence) {
        long l = 0L;
        int n = 0;
        for (int i = 0; i < charSequence.length() && n < 16; ++i) {
            char c = charSequence.charAt(i);
            if (c > '/' && c < ':') {
                n = (byte)(n + 1);
                l <<= 4;
                l |= (long)(c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                n = (byte)(n + 1);
                l <<= 4;
                l |= (long)(c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            l <<= 4;
            l |= (long)(c - 87);
        }
        return l;
    }

    public static short parseShort(String string2) {
        short s = 0;
        int n = 0;
        for (int i = 0; i < string2.length() && n < 4; ++i) {
            char c = string2.charAt(i);
            if (c > '/' && c < ':') {
                n = (byte)(n + 1);
                s = (short)(s << 4);
                s = (short)(s | c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                n = (byte)(n + 1);
                s = (short)(s << 4);
                s = (short)(s | c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            n = (byte)(n + 1);
            s = (short)(s << 4);
            s = (short)(s | c - 87);
        }
        return s;
    }
}

