/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.testCases;

import com.clineff.commandLine.ClinEff;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEffect;
import org.snpeff.vcf.VcfEntry;

public class TestCasesIntegrationWorkflow
extends TestCase {
    public static boolean verbose = false;
    public static final String DIR = "test/integration/workflow";

    List<VcfEntry> clinEff(String[] args) {
        return this.clinEff(args, true);
    }

    List<VcfEntry> clinEff(String[] args, boolean suppressReports) {
        ClinEff clinEff = new ClinEff(args);
        clinEff.setLog(false);
        clinEff.setVerbose(verbose);
        clinEff.setSuppressOutput(!verbose);
        clinEff.setSuppressReports(suppressReports);
        clinEff.setSaveResults(true);
        boolean ok = clinEff.run();
        Assert.assertTrue("ClinEff finished with errors. OK: " + ok, ok);
        return clinEff.getResults();
    }

    public void test_01() {
        Gpr.debug("Test");
        String testNum = "01";
        String[] args = new String[]{"-c", "test/integration/workflow/clinEff_" + testNum + ".config", "-w", "test/integration/workflow/workflow_" + testNum + ".config", "testHg19Chr19", "test/integration/workflow/test_" + testNum + ".vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        if (verbose) {
            Gpr.debug(ve);
        }
        VcfEffect veff = ve.getVcfEffects().get(0);
        if (verbose) {
            Gpr.debug(veff);
        }
        Assert.assertEquals("NM_000400.3", veff.getTranscriptId());
        Assert.assertEquals((Object)EffectType.NON_SYNONYMOUS_CODING, (Object)veff.getEffectType());
    }

    public void test_02() {
        Gpr.debug("Test");
        String testNum = "02";
        String[] args = new String[]{"-c", "test/integration/workflow/clinEff_" + testNum + ".config", "-w", "test/integration/workflow/workflow_" + testNum + ".config", "testHg19Chr22", "test/integration/workflow/test_" + testNum + ".vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        if (verbose) {
            Gpr.debug(ve);
        }
        Assert.assertEquals("ENSG00000206252", ve.getInfo("dbNSFP_Ensembl_geneid"));
        Assert.assertEquals("ENST00000383146", ve.getInfo("dbNSFP_Ensembl_transcriptid"));
        Assert.assertNull("This annotation should not be present", ve.getInfo("dbNSFP_1000Gp3_AF"));
        Assert.assertNull("This annotation should not be present", ve.getInfo("dbNSFP_ExAC_AF"));
    }

    public void test_03() {
        Gpr.debug("Test");
        String testNum = "03";
        String[] args = new String[]{"-c", "test/integration/workflow/clinEff_" + testNum + ".config", "-w", "test/integration/workflow/workflow_" + testNum + ".config", "testHg19Chr19", "test/integration/workflow/test_" + testNum + ".vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        if (verbose) {
            Gpr.debug("Vcf entry: " + ve);
        }
        String geneSets = ve.getInfo("MSigDb");
        if (verbose) {
            Gpr.debug("Gene sets: " + geneSets);
        }
        Assert.assertNotNull(geneSets);
        Assert.assertFalse(geneSets.isEmpty());
    }

    public void test_04() {
        Gpr.debug("Test");
        String testNum = "04";
        String[] args = new String[]{"-c", "test/integration/workflow/clinEff_" + testNum + ".config", "-w", "test/integration/workflow/workflow_" + testNum + ".config", "testHg19Chr19", "test/integration/workflow/test_" + testNum + ".vcf"};
        List<VcfEntry> res = this.clinEff(args);
        VcfEntry ve = res.get(0);
        if (verbose) {
            Gpr.debug("Vcf entry: " + ve);
        }
        Assert.assertEquals("RCV000120789.2", ve.getInfo("CLNACC"));
        Assert.assertEquals("2", ve.getInfo("CLNSIG"));
    }

    public void test_05() {
        Gpr.debug("Test");
        String testNum = "05";
        String genome = "testHg3775Chr1";
        String[] args = new String[]{"-c", "test/integration/workflow/clinEff_" + testNum + ".config", "-w", "test/integration/workflow/workflow_" + testNum + ".config", genome, "test/integration/workflow/test_" + testNum + ".vcf"};
        List<VcfEntry> res = this.clinEff(args, false);
        VcfEntry ve = res.get(0);
        if (verbose) {
            Gpr.debug("Vcf entry: " + ve);
        }
    }
}

