/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.util.RuntimeEOFException;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeaderEntry;
import org.snpeff.vcf.VcfHeaderInfo;
import org.snpeff.vcf.VcfInfoType;
import org.snpsift.SnpSift;
import org.snpsift.lang.expression.Expression;

public class SnpSiftCmdVcfOperator
extends SnpSift {
    private static final List<Double> EMPTY_VALS = new LinkedList<Double>();
    protected String fields;
    protected String outField;
    protected Operator operator;
    protected String[] infoFields;

    public SnpSiftCmdVcfOperator() {
    }

    public SnpSiftCmdVcfOperator(String[] args) {
        super(args);
    }

    @Override
    public boolean annotate(VcfEntry vcfEntry) {
        List<Double> values2 = this.getValues(vcfEntry);
        Double res = this.applyOp(values2);
        if (res != null) {
            vcfEntry.addInfo(this.outField, "" + res);
        }
        return false;
    }

    public Double applyOp(List<Double> vals) {
        if (vals.isEmpty()) {
            return null;
        }
        double res = this.initialValue();
        block6: for (Double val : vals) {
            switch (this.operator) {
                case MIN: {
                    res = Math.min(res, val);
                    continue block6;
                }
                case MAX: {
                    res = Math.max(res, val);
                    continue block6;
                }
                case PLUS: {
                    res += val.doubleValue();
                    continue block6;
                }
                case PRODUCT: {
                    res *= val.doubleValue();
                    continue block6;
                }
            }
            throw new RuntimeEOFException("Unknown operator '" + (Object)((Object)this.operator) + "'");
        }
        return res;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public List<Double> getValues(VcfEntry vcfEntry) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (String field2 : this.infoFields) {
            vals.addAll(this.getValues(vcfEntry, field2));
        }
        return vals;
    }

    public List<Double> getValues(VcfEntry vcfEntry, String field2) {
        String valsStr = vcfEntry.getInfo(field2);
        if (valsStr == null || valsStr.isEmpty()) {
            return EMPTY_VALS;
        }
        LinkedList<Double> vals = new LinkedList<Double>();
        for (String valStr : valsStr.split(",")) {
            if (VcfEntry.isEmpty(valStr)) continue;
            try {
                double v = Double.parseDouble(valStr);
                vals.add(v);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return vals;
    }

    @Override
    protected List<VcfHeaderEntry> headers() {
        List<VcfHeaderEntry> headerInfos = super.headers();
        headerInfos.add(new VcfHeaderInfo(this.outField, VcfInfoType.Float, "1", "Operation '" + (Object)((Object)this.operator) + "' applied to fileds '" + this.fields + "'"));
        return headerInfos;
    }

    protected double initialValue() {
        switch (this.operator) {
            case MIN: {
                return Double.MAX_VALUE;
            }
            case MAX: {
                return Double.MIN_VALUE;
            }
            case PLUS: {
                return 0.0;
            }
            case PRODUCT: {
                return 1.0;
            }
        }
        throw new RuntimeEOFException("Unknown operator '" + (Object)((Object)this.operator) + "'");
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        if (args == null || args.length < 1) {
            this.usage(null);
        }
        new ArrayList();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                switch (arg.toLowerCase()) {
                    case "-fields": {
                        if (i + 1 < args.length) {
                            this.fields = args[++i];
                        } else {
                            this.usage("Option '-fields' without argument");
                        }
                        this.infoFields = this.fields.split(",");
                        break;
                    }
                    case "-op": {
                        String op = "";
                        if (i + 1 < args.length) {
                            op = args[++i];
                        } else {
                            this.usage("Option '-fields' without argument");
                        }
                        try {
                            this.operator = Operator.valueOf(op.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            this.usage("Unknown operator '" + op + "'");
                        }
                        break;
                    }
                    case "-outfield": {
                        if (i + 1 < args.length) {
                            this.outField = args[++i];
                            break;
                        }
                        this.usage("Option '-outField' without argument");
                        break;
                    }
                    default: {
                        this.usage("Unknown command line option '" + arg + "'");
                        break;
                    }
                }
                continue;
            }
            if (this.vcfInputFile == null || this.vcfInputFile.isEmpty()) {
                this.vcfInputFile = arg;
                continue;
            }
            this.usage("Unused command line argument '" + arg + "'");
        }
        if (this.help) {
            this.usage(null);
        }
        if (this.fields == null || this.fields.isEmpty()) {
            this.usage("Missing '-fields' input field names");
        }
        if (this.outField == null || this.outField.isEmpty()) {
            this.usage("Missing '-outfield' output field name");
        }
        if (this.operator == null) {
            this.usage("Missing '-op' operator field");
        }
    }

    @Override
    public boolean run() {
        this.run(false);
        return true;
    }

    public List<VcfEntry> run(boolean createList) {
        if (this.debug) {
            Expression.debug = true;
        }
        LinkedList<VcfEntry> vcfEntries = createList ? new LinkedList<VcfEntry>() : null;
        this.showVcfHeader = !createList;
        VcfFileIterator vcfFile = this.openVcfInputFile();
        this.annotateInit(vcfFile);
        for (VcfEntry vcfEntry : vcfFile) {
            this.processVcfHeader(vcfFile);
            this.annotate(vcfEntry);
            if (vcfEntries != null) {
                vcfEntries.add(vcfEntry);
                continue;
            }
            System.out.println(vcfEntry);
        }
        this.annotateFinish(vcfFile);
        return vcfEntries;
    }

    @Override
    public void usage(String msg) {
        if (msg != null) {
            System.err.println("Error: " + msg);
            this.showCmd();
        }
        this.showVersion();
        System.err.println("Kew version " + VERSION);
        System.err.println("Usage: kew maxPopFreq [options] [files]");
        System.err.println("");
        System.err.println("\nCommands line options: ");
        System.err.println("\t-fields <filedNames>    : Input VCF field names (comma separated list).");
        System.err.println("\t-op <operator>          : Operator to be applied to the fields");
        System.err.println("\t-outfield <filedName>   : Ouptut field name.");
        System.exit(-1);
    }

    public static enum Operator {
        PLUS,
        MAX,
        MIN,
        PRODUCT;

    }
}

