/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.HgvsDna;
import org.snpeff.snpEffect.HgvsProtein;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.EffFormatVersion;
import org.snpeff.vcf.VcfEffect;

public class TestCasesStructuralDup
extends TestCasesBase {
    EffFormatVersion formatVersion = EffFormatVersion.FORMAT_ANN;

    Set<String> arrayToSet(String[] array) {
        HashSet<String> set = new HashSet<String>();
        if (array != null) {
            for (String h : array) {
                set.add(h);
            }
        }
        return set;
    }

    protected void checkEffects(Variant variant, EffectType[] expEffs, String[] expHgvsp, String[] expHgvsc, VariantEffect.EffectImpact expectedImpact, String[] expAnns) {
        HashSet<EffectType> expectedEffs = new HashSet<EffectType>();
        if (expEffs != null) {
            for (EffectType et : expEffs) {
                expectedEffs.add(et);
            }
        }
        Set<String> expectedHgvsp = this.arrayToSet(expHgvsp);
        Set<String> expectedHgvsc = this.arrayToSet(expHgvsc);
        Set<String> expectedAnns = this.arrayToSet(expAnns);
        this.initSnpEffPredictor();
        if (this.verbose) {
            Gpr.debug("Variant: " + variant);
            for (Gene g : this.genome.getGenes()) {
                Gpr.debug("\tGene: " + g.getId());
                for (Transcript tr : g) {
                    Gpr.debug(tr + "\n\n" + tr.toStringAsciiArt(true));
                }
            }
        }
        VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
        if (this.verbose) {
            Gpr.debug("VariantEffects: " + effects);
        }
        Assert.assertEquals(true, effects.size() >= 1);
        HashSet<EffectType> effs = new HashSet<EffectType>();
        HashSet<String> hgvscs = new HashSet<String>();
        HashSet<String> hgvsps = new HashSet<String>();
        HashSet<String> anns = new HashSet<String>();
        boolean impactOk = false;
        for (VariantEffect varEff : effects) {
            effs.addAll(varEff.getEffectTypes());
            HgvsDna hgvsc = new HgvsDna(varEff);
            String hgvsDna = hgvsc.toString();
            hgvscs.add(hgvsDna);
            HgvsProtein hgvsp = new HgvsProtein(varEff);
            String hgvsProt = hgvsp.toString();
            hgvsps.add(hgvsProt);
            impactOk |= varEff.hasEffectImpact(expectedImpact);
            VcfEffect vcfEffect = new VcfEffect(varEff, this.formatVersion);
            String annField = vcfEffect.toString();
            anns.add(annField);
            if (!this.verbose) continue;
            Gpr.debug("Effect: " + varEff.toStr() + "\n\tHGVS.c: " + hgvsDna + "\n\tHGVS.p: " + hgvsProt + "\n\tANN   : " + annField);
        }
        Assert.assertTrue("Effects do not match\n\tExpected : " + expectedEffs + "\n\tFound    : " + effs, effs.containsAll(expectedEffs));
        Assert.assertTrue("Effect impact '" + (Object)((Object)expectedImpact) + "' not found", impactOk);
        Assert.assertTrue("HGVS.c do not match\n\tExpected : " + expectedHgvsc + "\n\tFound    : " + hgvscs, hgvscs.containsAll(expectedHgvsc));
        Assert.assertTrue("HGVS.p do not match\n\tExpected : " + expectedHgvsp + "\n\tFound    : " + hgvsps, hgvsps.containsAll(expectedHgvsp));
        Assert.assertTrue("ANN fields do not match\n\tExpected : " + expectedAnns + "\n\tFound    : " + anns, anns.containsAll(expectedAnns));
    }

    @Override
    protected void init() {
        this.randSeed = 20151205;
        this.genomeName = "testCase";
        this.addUtrs = false;
        this.onlyPlusStrand = true;
        this.onlyMinusStrand = false;
        this.numGenes = 2;
        this.maxGeneLen = 1000;
        this.maxTranscripts = 1;
        this.maxExons = 5;
        this.minExons = 2;
        this.shiftHgvs = false;
        this.initRand();
    }

    @Test
    public void test01_dupGene() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 950, 1250, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.GENE_DUPLICATION};
        String[] expHgvsc = null;
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODERATE;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test01_dupTr() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 950, 1200, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.TRANSCRIPT_DUPLICATION};
        String[] expHgvsc = null;
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODERATE;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test02() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1100, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION, EffectType.FRAME_SHIFT};
        String[] expHgvsc = new String[]{"c.33-5_45+43dup"};
        String[] expHgvsp = new String[]{"p.Arg16fs", "p.Arg16_Gly18delinsCysValAlaAsnTerThrTrp"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test03() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1160, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION};
        String[] expHgvsc = new String[]{"c.33-5_*3dup"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.LOW;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test04() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1040, 1050, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION_PARTIAL};
        String[] expHgvsc = new String[]{"c.33-5_38dup"};
        String[] expHgvsp = new String[]{"p.Val12_Leu13insPheVal"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test05() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 1150, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION_PARTIAL};
        String[] expHgvsc = new String[]{"c.38_48dup"};
        String[] expHgvsp = new String[]{"p.Arg16_???19delinsCysTerLeuGluAspMetAsp"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test06() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 2150, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION, EffectType.EXON_DUPLICATION_PARTIAL, EffectType.TRANSCRIPT_DUPLICATION, EffectType.GENE_FUSION};
        String[] expHgvsc = new String[]{"n.1051_2151dup"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.LOW;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test07() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1100, 2000, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION};
        String[] expHgvsc = new String[]{"n.1101_2001dup"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.LOW;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test08() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1100, 2075, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION, EffectType.FRAME_SHIFT, EffectType.GENE_FUSION};
        String[] expHgvsc = new String[]{"n.1101_2076dup"};
        String[] expHgvsp = new String[]{"p.Ser2_Leu10delinsTyrPheProPheThrProThrSerAlaAla???", "p.Ser2fs"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test09() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 1050, 2120, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.EXON_DUPLICATION, EffectType.EXON_DUPLICATION_PARTIAL, EffectType.GENE_FUSION};
        String[] expHgvsc = new String[]{"n.1051_2121dup", "c.38_*963dup", "c.-1016_15dup"};
        String[] expHgvsp = new String[]{"p.Pro6_Arg7delinsTyrAlaHisValLeuProPhe"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.HIGH;
        this.checkEffects(variant, expEffs, expHgvsp, expHgvsc, expectedImpact, null);
    }

    @Test
    public void test10() {
        Gpr.debug("Test");
        Variant variant = new Variant((Marker)this.chromosome, 991, 1020, "");
        variant.setVariantType(Variant.VariantType.DUP);
        EffectType[] expEffs = new EffectType[]{EffectType.INTRON};
        String[] expHgvsc = new String[]{"c.32+3_33-25dup"};
        VariantEffect.EffectImpact expectedImpact = VariantEffect.EffectImpact.MODIFIER;
        this.checkEffects(variant, expEffs, null, expHgvsc, expectedImpact, null);
    }
}

