/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.snpEffect.testCases.unity.TestCasesBase;
import org.snpeff.util.Gpr;

public class TestCasesIntervalVariant
extends TestCasesBase {
    public static int N = 1000;

    @Override
    protected void init() {
        super.init();
        this.randSeed = 20120426;
    }

    @Test
    public void test_01() {
        Gpr.debug("Test");
        for (int i = 0; i < N; ++i) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("INTERVAL (Variant) Test iteration: " + i + "\n" + this.transcript);
            } else {
                Gpr.showMark(i + 1, 1);
            }
            for (int pos = 0; pos < this.chromosome.size(); ++pos) {
                int n;
                int intLen = this.rand.nextInt(100) + 1;
                int start = pos;
                int end = Math.min(pos + intLen, this.chromosome.getEnd());
                Variant variant = new Variant((Marker)this.chromosome, start, end, "");
                Assert.assertEquals(true, variant.isInterval());
                EffectType expectedEffect = null;
                if (this.transcript.intersects(variant)) {
                    for (Exon exon : this.transcript) {
                        if (!exon.intersects(variant)) continue;
                        expectedEffect = EffectType.EXON;
                    }
                    for (Intron intron : this.transcript.introns()) {
                        if (!intron.intersects(variant)) continue;
                        expectedEffect = EffectType.INTRON;
                    }
                } else if (this.gene.intersects(variant)) {
                    if (expectedEffect == null) {
                        expectedEffect = EffectType.INTRAGENIC;
                    }
                } else {
                    expectedEffect = EffectType.INTERGENIC;
                }
                VariantEffects effects = this.snpEffectPredictor.variantEffect(variant);
                Assert.assertEquals(false, effects.isEmpty());
                if (this.debug && effects.size() > 1) {
                    System.out.println("Found more than one effect: " + effects.size() + "\n" + this.transcript);
                    for (VariantEffect eff : effects) {
                        System.out.println("\t" + eff);
                    }
                }
                boolean bl = false;
                StringBuilder effSb = new StringBuilder();
                for (VariantEffect effect : effects) {
                    String effstr = effect.effect(true, true, true, false, false);
                    n |= effect.hasEffectType(expectedEffect);
                    effSb.append(effstr + " ");
                }
                if (this.debug || n == 0) {
                    System.out.println("\nVariant         : " + variant + "\nExpected Effect : '" + (Object)((Object)expectedEffect) + "'\nEffects         : '" + effSb + "'\n--------------------------------------------------------------\n");
                }
                Assert.assertEquals(true, n != 0);
            }
        }
    }
}

