/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import java.util.HashSet;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.binseq.DnaNSequence;
import org.snpeff.binseq.coder.DnaCoder;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;

public class TestCasesDnaNSequence {
    public static boolean verbose = false;

    String change(String sequence2, int numChanges, Random rand) {
        HashSet<Integer> changedPos = new HashSet<Integer>();
        char[] chars = sequence2.toCharArray();
        int i = 0;
        while (i < numChanges) {
            char newBase;
            int pos = rand.nextInt(chars.length);
            if (changedPos.contains(pos) || chars[pos] == (newBase = this.randBase(rand))) continue;
            chars[pos] = newBase;
            changedPos.add(pos);
            ++i;
        }
        return new String(chars);
    }

    char randBase(Random rand) {
        int r = rand.nextInt(5);
        if (r < 4) {
            return DnaCoder.get().toBase(r);
        }
        return 'N';
    }

    public void randDnaSeqGetBasesTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaNSequence bseq = new DnaNSequence(seq2);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                int randLen = rand.nextInt(len - randPos);
                String basesOri = seq2.substring(randPos, randPos + randLen);
                String basesBin = bseq.getBases(randPos, randLen);
                Assert.assertEquals(basesOri, basesBin);
                if (!verbose) continue;
                System.out.println("randDnaSeqGetBasesTest:\tPos: " + randPos + "\tLen: " + randLen + "\t'" + basesOri + "'\t=\t'" + basesBin + "'");
            }
        }
    }

    public void randDnaSeqGetBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaNSequence test:" + t + "\tlen:" + len + "\t" + seq2);
            }
            DnaNSequence bseq = new DnaNSequence(seq2);
            for (int i = 0; i < numTestsPerSeq; ++i) {
                int randPos = rand.nextInt(len);
                char baseOri = seq2.charAt(randPos);
                char baseBin = bseq.getBase(randPos);
                Assert.assertEquals(baseOri, baseBin);
            }
        }
    }

    public void randDnaSeqTest(int numTests, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            if (verbose) {
                System.out.println("DnaNSequence test:" + t + "\tlen:" + len + "\t" + seq2);
            }
            DnaNSequence bseq = new DnaNSequence(seq2);
            Assert.assertEquals(seq2, bseq.toString());
        }
    }

    public void randReplaceBaseTest(int numTests, int numTestsPerSeq, int lenMask, long seed) {
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            String seq2 = "";
            int len = (rand.nextInt() & lenMask) + 10;
            seq2 = this.randSeq(len, rand);
            DnaNSequence bseq = new DnaNSequence(seq2);
            if (verbose) {
                System.out.println("randReplaceBaseTest\nOri    :\t" + seq2);
            }
            for (int i = 0; i < numTestsPerSeq; ++i) {
                char baseOri;
                int randPos = rand.nextInt(len);
                char randBase = baseOri = seq2.charAt(randPos);
                while (randBase == baseOri) {
                    randBase = this.randBase(rand);
                }
                char[] seqChars = seq2.toCharArray();
                seqChars[randPos] = randBase;
                seq2 = new String(seqChars);
                bseq.setBase(randPos, randBase);
                if (verbose) {
                    System.out.println("Changed:\t" + seq2 + "\tpos: " + randPos + "\trandbase: " + randBase + "\n\t\t" + bseq);
                }
                Assert.assertEquals(seq2, bseq.toString());
            }
        }
    }

    String randSeq(int len, Random rand) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(this.randBase(rand));
        }
        return sb.toString();
    }

    @Test
    public void test_01_short() {
        Gpr.debug("Test");
        long seed = 20100615L;
        int lenMask = 255;
        int numTests = 1000;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    @Test
    public void test_01_short_getBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_01_short_getBases() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_01_short_replaceBase() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 255;
        int numTests = 1000;
        int numTestsPerSeq = 100;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long() {
        Gpr.debug("Test");
        long seed = 20100614L;
        int lenMask = 65535;
        int numTests = 10;
        this.randDnaSeqTest(numTests, lenMask, seed);
    }

    @Test
    public void test_02_long_getBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long_getBases() {
        Gpr.debug("Test");
        long seed = 20110218L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randDnaSeqGetBasesTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_02_long_replaceBase() {
        Gpr.debug("Test");
        long seed = 20110217L;
        int lenMask = 65535;
        int numTests = 10;
        int numTestsPerSeq = 1000;
        this.randReplaceBaseTest(numTests, numTestsPerSeq, lenMask, seed);
    }

    @Test
    public void test_13_reverseWc() {
        Gpr.debug("Test");
        long seed = 20100615L;
        int lenMask = 4095;
        int numTests = 1000;
        Random rand = new Random(seed);
        for (int t = 0; t < numTests; ++t) {
            int len = (rand.nextInt() & lenMask) + 10;
            String seq2 = this.randSeq(len, rand);
            String seqRwc = GprSeq.reverseWc(seq2);
            DnaNSequence bseq = new DnaNSequence(seq2);
            DnaNSequence rwc = (DnaNSequence)bseq.reverseWc();
            Assert.assertEquals(seqRwc.toUpperCase(), rwc.getSequence().toUpperCase());
        }
    }
}

