/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.testCases.unity;

import junit.framework.Assert;
import org.junit.Test;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;

public class TestCasesCodonTable {
    public static boolean debug = false;

    @Test
    public void test_01() {
        Gpr.debug("Test");
        CodonTable codonTable = CodonTables.getInstance().getTable("Standard");
        Assert.assertEquals(4, codonTable.degenerate("GGT", 2));
        Assert.assertEquals(2, codonTable.degenerate("GAA", 2));
        Assert.assertEquals(3, codonTable.degenerate("ATT", 2));
    }

    @Test
    public void test_02() {
        Gpr.debug("Test");
        String genomeVersion = "test_ctab";
        Config config = new Config(genomeVersion);
        String chr1Name = "any_chromo";
        Genome genome = config.getGenome();
        Chromosome chr1 = genome.getOrCreateChromosome(chr1Name);
        if (debug) {
            Gpr.debug("Codon table [" + chr1Name + "]: " + chr1.getCodonTable().getName());
        }
        Assert.assertEquals("Blepharisma_Macronuclear", chr1.getCodonTable().getName());
        String chrMtName = "MT";
        Chromosome chrMt = genome.getOrCreateChromosome(chrMtName);
        if (debug) {
            Gpr.debug("Codon table [" + chrMtName + "]: " + chrMt.getCodonTable().getName());
        }
        Assert.assertEquals("Vertebrate_Mitochondrial", chrMt.getCodonTable().getName());
    }
}

